/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.DirectDeploySettings;
import software.amazon.awssdk.services.sagemaker.model.EmrServerlessSettings;
import software.amazon.awssdk.services.sagemaker.model.GenerativeAiSettings;
import software.amazon.awssdk.services.sagemaker.model.IdentityProviderOAuthSetting;
import software.amazon.awssdk.services.sagemaker.model.IdentityProviderOAuthSettingsCopier;
import software.amazon.awssdk.services.sagemaker.model.KendraSettings;
import software.amazon.awssdk.services.sagemaker.model.ModelRegisterSettings;
import software.amazon.awssdk.services.sagemaker.model.TimeSeriesForecastingSettings;
import software.amazon.awssdk.services.sagemaker.model.WorkspaceSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CanvasAppSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CanvasAppSettings> {
    private static final SdkField<TimeSeriesForecastingSettings> TIME_SERIES_FORECASTING_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimeSeriesForecastingSettings").getter(CanvasAppSettings.getter(CanvasAppSettings::timeSeriesForecastingSettings)).setter(CanvasAppSettings.setter(Builder::timeSeriesForecastingSettings)).constructor(TimeSeriesForecastingSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeSeriesForecastingSettings").build()}).build();
    private static final SdkField<ModelRegisterSettings> MODEL_REGISTER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelRegisterSettings").getter(CanvasAppSettings.getter(CanvasAppSettings::modelRegisterSettings)).setter(CanvasAppSettings.setter(Builder::modelRegisterSettings)).constructor(ModelRegisterSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelRegisterSettings").build()}).build();
    private static final SdkField<WorkspaceSettings> WORKSPACE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WorkspaceSettings").getter(CanvasAppSettings.getter(CanvasAppSettings::workspaceSettings)).setter(CanvasAppSettings.setter(Builder::workspaceSettings)).constructor(WorkspaceSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceSettings").build()}).build();
    private static final SdkField<List<IdentityProviderOAuthSetting>> IDENTITY_PROVIDER_O_AUTH_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IdentityProviderOAuthSettings").getter(CanvasAppSettings.getter(CanvasAppSettings::identityProviderOAuthSettings)).setter(CanvasAppSettings.setter(Builder::identityProviderOAuthSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderOAuthSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IdentityProviderOAuthSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DirectDeploySettings> DIRECT_DEPLOY_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DirectDeploySettings").getter(CanvasAppSettings.getter(CanvasAppSettings::directDeploySettings)).setter(CanvasAppSettings.setter(Builder::directDeploySettings)).constructor(DirectDeploySettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectDeploySettings").build()}).build();
    private static final SdkField<KendraSettings> KENDRA_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KendraSettings").getter(CanvasAppSettings.getter(CanvasAppSettings::kendraSettings)).setter(CanvasAppSettings.setter(Builder::kendraSettings)).constructor(KendraSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KendraSettings").build()}).build();
    private static final SdkField<GenerativeAiSettings> GENERATIVE_AI_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GenerativeAiSettings").getter(CanvasAppSettings.getter(CanvasAppSettings::generativeAiSettings)).setter(CanvasAppSettings.setter(Builder::generativeAiSettings)).constructor(GenerativeAiSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerativeAiSettings").build()}).build();
    private static final SdkField<EmrServerlessSettings> EMR_SERVERLESS_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EmrServerlessSettings").getter(CanvasAppSettings.getter(CanvasAppSettings::emrServerlessSettings)).setter(CanvasAppSettings.setter(Builder::emrServerlessSettings)).constructor(EmrServerlessSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmrServerlessSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_SERIES_FORECASTING_SETTINGS_FIELD, MODEL_REGISTER_SETTINGS_FIELD, WORKSPACE_SETTINGS_FIELD, IDENTITY_PROVIDER_O_AUTH_SETTINGS_FIELD, DIRECT_DEPLOY_SETTINGS_FIELD, KENDRA_SETTINGS_FIELD, GENERATIVE_AI_SETTINGS_FIELD, EMR_SERVERLESS_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TimeSeriesForecastingSettings", TIME_SERIES_FORECASTING_SETTINGS_FIELD);
            this.put("ModelRegisterSettings", MODEL_REGISTER_SETTINGS_FIELD);
            this.put("WorkspaceSettings", WORKSPACE_SETTINGS_FIELD);
            this.put("IdentityProviderOAuthSettings", IDENTITY_PROVIDER_O_AUTH_SETTINGS_FIELD);
            this.put("DirectDeploySettings", DIRECT_DEPLOY_SETTINGS_FIELD);
            this.put("KendraSettings", KENDRA_SETTINGS_FIELD);
            this.put("GenerativeAiSettings", GENERATIVE_AI_SETTINGS_FIELD);
            this.put("EmrServerlessSettings", EMR_SERVERLESS_SETTINGS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final TimeSeriesForecastingSettings timeSeriesForecastingSettings;
    private final ModelRegisterSettings modelRegisterSettings;
    private final WorkspaceSettings workspaceSettings;
    private final List<IdentityProviderOAuthSetting> identityProviderOAuthSettings;
    private final DirectDeploySettings directDeploySettings;
    private final KendraSettings kendraSettings;
    private final GenerativeAiSettings generativeAiSettings;
    private final EmrServerlessSettings emrServerlessSettings;

    private CanvasAppSettings(BuilderImpl builder) {
        this.timeSeriesForecastingSettings = builder.timeSeriesForecastingSettings;
        this.modelRegisterSettings = builder.modelRegisterSettings;
        this.workspaceSettings = builder.workspaceSettings;
        this.identityProviderOAuthSettings = builder.identityProviderOAuthSettings;
        this.directDeploySettings = builder.directDeploySettings;
        this.kendraSettings = builder.kendraSettings;
        this.generativeAiSettings = builder.generativeAiSettings;
        this.emrServerlessSettings = builder.emrServerlessSettings;
    }

    public final TimeSeriesForecastingSettings timeSeriesForecastingSettings() {
        return this.timeSeriesForecastingSettings;
    }

    public final ModelRegisterSettings modelRegisterSettings() {
        return this.modelRegisterSettings;
    }

    public final WorkspaceSettings workspaceSettings() {
        return this.workspaceSettings;
    }

    public final boolean hasIdentityProviderOAuthSettings() {
        return this.identityProviderOAuthSettings != null && !(this.identityProviderOAuthSettings instanceof SdkAutoConstructList);
    }

    public final List<IdentityProviderOAuthSetting> identityProviderOAuthSettings() {
        return this.identityProviderOAuthSettings;
    }

    public final DirectDeploySettings directDeploySettings() {
        return this.directDeploySettings;
    }

    public final KendraSettings kendraSettings() {
        return this.kendraSettings;
    }

    public final GenerativeAiSettings generativeAiSettings() {
        return this.generativeAiSettings;
    }

    public final EmrServerlessSettings emrServerlessSettings() {
        return this.emrServerlessSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timeSeriesForecastingSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelRegisterSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIdentityProviderOAuthSettings() ? this.identityProviderOAuthSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.directDeploySettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.kendraSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.generativeAiSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.emrServerlessSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CanvasAppSettings)) {
            return false;
        }
        CanvasAppSettings other = (CanvasAppSettings)obj;
        return Objects.equals(this.timeSeriesForecastingSettings(), other.timeSeriesForecastingSettings()) && Objects.equals(this.modelRegisterSettings(), other.modelRegisterSettings()) && Objects.equals(this.workspaceSettings(), other.workspaceSettings()) && this.hasIdentityProviderOAuthSettings() == other.hasIdentityProviderOAuthSettings() && Objects.equals(this.identityProviderOAuthSettings(), other.identityProviderOAuthSettings()) && Objects.equals(this.directDeploySettings(), other.directDeploySettings()) && Objects.equals(this.kendraSettings(), other.kendraSettings()) && Objects.equals(this.generativeAiSettings(), other.generativeAiSettings()) && Objects.equals(this.emrServerlessSettings(), other.emrServerlessSettings());
    }

    public final String toString() {
        return ToString.builder((String)"CanvasAppSettings").add("TimeSeriesForecastingSettings", (Object)this.timeSeriesForecastingSettings()).add("ModelRegisterSettings", (Object)this.modelRegisterSettings()).add("WorkspaceSettings", (Object)this.workspaceSettings()).add("IdentityProviderOAuthSettings", this.hasIdentityProviderOAuthSettings() ? this.identityProviderOAuthSettings() : null).add("DirectDeploySettings", (Object)this.directDeploySettings()).add("KendraSettings", (Object)this.kendraSettings()).add("GenerativeAiSettings", (Object)this.generativeAiSettings()).add("EmrServerlessSettings", (Object)this.emrServerlessSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TimeSeriesForecastingSettings": {
                return Optional.ofNullable(clazz.cast(this.timeSeriesForecastingSettings()));
            }
            case "ModelRegisterSettings": {
                return Optional.ofNullable(clazz.cast(this.modelRegisterSettings()));
            }
            case "WorkspaceSettings": {
                return Optional.ofNullable(clazz.cast(this.workspaceSettings()));
            }
            case "IdentityProviderOAuthSettings": {
                return Optional.ofNullable(clazz.cast(this.identityProviderOAuthSettings()));
            }
            case "DirectDeploySettings": {
                return Optional.ofNullable(clazz.cast(this.directDeploySettings()));
            }
            case "KendraSettings": {
                return Optional.ofNullable(clazz.cast(this.kendraSettings()));
            }
            case "GenerativeAiSettings": {
                return Optional.ofNullable(clazz.cast(this.generativeAiSettings()));
            }
            case "EmrServerlessSettings": {
                return Optional.ofNullable(clazz.cast(this.emrServerlessSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CanvasAppSettings, T> g) {
        return obj -> g.apply((CanvasAppSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private TimeSeriesForecastingSettings timeSeriesForecastingSettings;
        private ModelRegisterSettings modelRegisterSettings;
        private WorkspaceSettings workspaceSettings;
        private List<IdentityProviderOAuthSetting> identityProviderOAuthSettings = DefaultSdkAutoConstructList.getInstance();
        private DirectDeploySettings directDeploySettings;
        private KendraSettings kendraSettings;
        private GenerativeAiSettings generativeAiSettings;
        private EmrServerlessSettings emrServerlessSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(CanvasAppSettings model) {
            this.timeSeriesForecastingSettings(model.timeSeriesForecastingSettings);
            this.modelRegisterSettings(model.modelRegisterSettings);
            this.workspaceSettings(model.workspaceSettings);
            this.identityProviderOAuthSettings(model.identityProviderOAuthSettings);
            this.directDeploySettings(model.directDeploySettings);
            this.kendraSettings(model.kendraSettings);
            this.generativeAiSettings(model.generativeAiSettings);
            this.emrServerlessSettings(model.emrServerlessSettings);
        }

        public final TimeSeriesForecastingSettings.Builder getTimeSeriesForecastingSettings() {
            return this.timeSeriesForecastingSettings != null ? this.timeSeriesForecastingSettings.toBuilder() : null;
        }

        public final void setTimeSeriesForecastingSettings(TimeSeriesForecastingSettings.BuilderImpl timeSeriesForecastingSettings) {
            this.timeSeriesForecastingSettings = timeSeriesForecastingSettings != null ? timeSeriesForecastingSettings.build() : null;
        }

        @Override
        public final Builder timeSeriesForecastingSettings(TimeSeriesForecastingSettings timeSeriesForecastingSettings) {
            this.timeSeriesForecastingSettings = timeSeriesForecastingSettings;
            return this;
        }

        public final ModelRegisterSettings.Builder getModelRegisterSettings() {
            return this.modelRegisterSettings != null ? this.modelRegisterSettings.toBuilder() : null;
        }

        public final void setModelRegisterSettings(ModelRegisterSettings.BuilderImpl modelRegisterSettings) {
            this.modelRegisterSettings = modelRegisterSettings != null ? modelRegisterSettings.build() : null;
        }

        @Override
        public final Builder modelRegisterSettings(ModelRegisterSettings modelRegisterSettings) {
            this.modelRegisterSettings = modelRegisterSettings;
            return this;
        }

        public final WorkspaceSettings.Builder getWorkspaceSettings() {
            return this.workspaceSettings != null ? this.workspaceSettings.toBuilder() : null;
        }

        public final void setWorkspaceSettings(WorkspaceSettings.BuilderImpl workspaceSettings) {
            this.workspaceSettings = workspaceSettings != null ? workspaceSettings.build() : null;
        }

        @Override
        public final Builder workspaceSettings(WorkspaceSettings workspaceSettings) {
            this.workspaceSettings = workspaceSettings;
            return this;
        }

        public final List<IdentityProviderOAuthSetting.Builder> getIdentityProviderOAuthSettings() {
            List<IdentityProviderOAuthSetting.Builder> result = IdentityProviderOAuthSettingsCopier.copyToBuilder(this.identityProviderOAuthSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIdentityProviderOAuthSettings(Collection<IdentityProviderOAuthSetting.BuilderImpl> identityProviderOAuthSettings) {
            this.identityProviderOAuthSettings = IdentityProviderOAuthSettingsCopier.copyFromBuilder(identityProviderOAuthSettings);
        }

        @Override
        public final Builder identityProviderOAuthSettings(Collection<IdentityProviderOAuthSetting> identityProviderOAuthSettings) {
            this.identityProviderOAuthSettings = IdentityProviderOAuthSettingsCopier.copy(identityProviderOAuthSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityProviderOAuthSettings(IdentityProviderOAuthSetting ... identityProviderOAuthSettings) {
            this.identityProviderOAuthSettings(Arrays.asList(identityProviderOAuthSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityProviderOAuthSettings(Consumer<IdentityProviderOAuthSetting.Builder> ... identityProviderOAuthSettings) {
            this.identityProviderOAuthSettings(Stream.of(identityProviderOAuthSettings).map(c -> (IdentityProviderOAuthSetting)((IdentityProviderOAuthSetting.Builder)IdentityProviderOAuthSetting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final DirectDeploySettings.Builder getDirectDeploySettings() {
            return this.directDeploySettings != null ? this.directDeploySettings.toBuilder() : null;
        }

        public final void setDirectDeploySettings(DirectDeploySettings.BuilderImpl directDeploySettings) {
            this.directDeploySettings = directDeploySettings != null ? directDeploySettings.build() : null;
        }

        @Override
        public final Builder directDeploySettings(DirectDeploySettings directDeploySettings) {
            this.directDeploySettings = directDeploySettings;
            return this;
        }

        public final KendraSettings.Builder getKendraSettings() {
            return this.kendraSettings != null ? this.kendraSettings.toBuilder() : null;
        }

        public final void setKendraSettings(KendraSettings.BuilderImpl kendraSettings) {
            this.kendraSettings = kendraSettings != null ? kendraSettings.build() : null;
        }

        @Override
        public final Builder kendraSettings(KendraSettings kendraSettings) {
            this.kendraSettings = kendraSettings;
            return this;
        }

        public final GenerativeAiSettings.Builder getGenerativeAiSettings() {
            return this.generativeAiSettings != null ? this.generativeAiSettings.toBuilder() : null;
        }

        public final void setGenerativeAiSettings(GenerativeAiSettings.BuilderImpl generativeAiSettings) {
            this.generativeAiSettings = generativeAiSettings != null ? generativeAiSettings.build() : null;
        }

        @Override
        public final Builder generativeAiSettings(GenerativeAiSettings generativeAiSettings) {
            this.generativeAiSettings = generativeAiSettings;
            return this;
        }

        public final EmrServerlessSettings.Builder getEmrServerlessSettings() {
            return this.emrServerlessSettings != null ? this.emrServerlessSettings.toBuilder() : null;
        }

        public final void setEmrServerlessSettings(EmrServerlessSettings.BuilderImpl emrServerlessSettings) {
            this.emrServerlessSettings = emrServerlessSettings != null ? emrServerlessSettings.build() : null;
        }

        @Override
        public final Builder emrServerlessSettings(EmrServerlessSettings emrServerlessSettings) {
            this.emrServerlessSettings = emrServerlessSettings;
            return this;
        }

        public CanvasAppSettings build() {
            return new CanvasAppSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CanvasAppSettings> {
        public Builder timeSeriesForecastingSettings(TimeSeriesForecastingSettings var1);

        default public Builder timeSeriesForecastingSettings(Consumer<TimeSeriesForecastingSettings.Builder> timeSeriesForecastingSettings) {
            return this.timeSeriesForecastingSettings((TimeSeriesForecastingSettings)((TimeSeriesForecastingSettings.Builder)TimeSeriesForecastingSettings.builder().applyMutation(timeSeriesForecastingSettings)).build());
        }

        public Builder modelRegisterSettings(ModelRegisterSettings var1);

        default public Builder modelRegisterSettings(Consumer<ModelRegisterSettings.Builder> modelRegisterSettings) {
            return this.modelRegisterSettings((ModelRegisterSettings)((ModelRegisterSettings.Builder)ModelRegisterSettings.builder().applyMutation(modelRegisterSettings)).build());
        }

        public Builder workspaceSettings(WorkspaceSettings var1);

        default public Builder workspaceSettings(Consumer<WorkspaceSettings.Builder> workspaceSettings) {
            return this.workspaceSettings((WorkspaceSettings)((WorkspaceSettings.Builder)WorkspaceSettings.builder().applyMutation(workspaceSettings)).build());
        }

        public Builder identityProviderOAuthSettings(Collection<IdentityProviderOAuthSetting> var1);

        public Builder identityProviderOAuthSettings(IdentityProviderOAuthSetting ... var1);

        public Builder identityProviderOAuthSettings(Consumer<IdentityProviderOAuthSetting.Builder> ... var1);

        public Builder directDeploySettings(DirectDeploySettings var1);

        default public Builder directDeploySettings(Consumer<DirectDeploySettings.Builder> directDeploySettings) {
            return this.directDeploySettings((DirectDeploySettings)((DirectDeploySettings.Builder)DirectDeploySettings.builder().applyMutation(directDeploySettings)).build());
        }

        public Builder kendraSettings(KendraSettings var1);

        default public Builder kendraSettings(Consumer<KendraSettings.Builder> kendraSettings) {
            return this.kendraSettings((KendraSettings)((KendraSettings.Builder)KendraSettings.builder().applyMutation(kendraSettings)).build());
        }

        public Builder generativeAiSettings(GenerativeAiSettings var1);

        default public Builder generativeAiSettings(Consumer<GenerativeAiSettings.Builder> generativeAiSettings) {
            return this.generativeAiSettings((GenerativeAiSettings)((GenerativeAiSettings.Builder)GenerativeAiSettings.builder().applyMutation(generativeAiSettings)).build());
        }

        public Builder emrServerlessSettings(EmrServerlessSettings var1);

        default public Builder emrServerlessSettings(Consumer<EmrServerlessSettings.Builder> emrServerlessSettings) {
            return this.emrServerlessSettings((EmrServerlessSettings)((EmrServerlessSettings.Builder)EmrServerlessSettings.builder().applyMutation(emrServerlessSettings)).build());
        }
    }
}

