/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.S3ModelDataSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AdditionalModelDataSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AdditionalModelDataSource> {
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelName").getter(AdditionalModelDataSource.getter(AdditionalModelDataSource::channelName)).setter(AdditionalModelDataSource.setter(Builder::channelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelName").build()}).build();
    private static final SdkField<S3ModelDataSource> S3_DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3DataSource").getter(AdditionalModelDataSource.getter(AdditionalModelDataSource::s3DataSource)).setter(AdditionalModelDataSource.setter(Builder::s3DataSource)).constructor(S3ModelDataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DataSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_NAME_FIELD, S3_DATA_SOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ChannelName", CHANNEL_NAME_FIELD);
            this.put("S3DataSource", S3_DATA_SOURCE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String channelName;
    private final S3ModelDataSource s3DataSource;

    private AdditionalModelDataSource(BuilderImpl builder) {
        this.channelName = builder.channelName;
        this.s3DataSource = builder.s3DataSource;
    }

    public final String channelName() {
        return this.channelName;
    }

    public final S3ModelDataSource s3DataSource() {
        return this.s3DataSource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.channelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3DataSource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdditionalModelDataSource)) {
            return false;
        }
        AdditionalModelDataSource other = (AdditionalModelDataSource)obj;
        return Objects.equals(this.channelName(), other.channelName()) && Objects.equals(this.s3DataSource(), other.s3DataSource());
    }

    public final String toString() {
        return ToString.builder((String)"AdditionalModelDataSource").add("ChannelName", (Object)this.channelName()).add("S3DataSource", (Object)this.s3DataSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelName": {
                return Optional.ofNullable(clazz.cast(this.channelName()));
            }
            case "S3DataSource": {
                return Optional.ofNullable(clazz.cast(this.s3DataSource()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AdditionalModelDataSource, T> g) {
        return obj -> g.apply((AdditionalModelDataSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String channelName;
        private S3ModelDataSource s3DataSource;

        private BuilderImpl() {
        }

        private BuilderImpl(AdditionalModelDataSource model) {
            this.channelName(model.channelName);
            this.s3DataSource(model.s3DataSource);
        }

        public final String getChannelName() {
            return this.channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final S3ModelDataSource.Builder getS3DataSource() {
            return this.s3DataSource != null ? this.s3DataSource.toBuilder() : null;
        }

        public final void setS3DataSource(S3ModelDataSource.BuilderImpl s3DataSource) {
            this.s3DataSource = s3DataSource != null ? s3DataSource.build() : null;
        }

        @Override
        public final Builder s3DataSource(S3ModelDataSource s3DataSource) {
            this.s3DataSource = s3DataSource;
            return this;
        }

        public AdditionalModelDataSource build() {
            return new AdditionalModelDataSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AdditionalModelDataSource> {
        public Builder channelName(String var1);

        public Builder s3DataSource(S3ModelDataSource var1);

        default public Builder s3DataSource(Consumer<S3ModelDataSource.Builder> s3DataSource) {
            return this.s3DataSource((S3ModelDataSource)((S3ModelDataSource.Builder)S3ModelDataSource.builder().applyMutation(s3DataSource)).build());
        }
    }
}

