/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.s3control.S3ControlClient;
import software.amazon.awssdk.services.s3control.internal.UserAgentUtils;
import software.amazon.awssdk.services.s3control.model.ListStorageLensConfigurationsRequest;
import software.amazon.awssdk.services.s3control.model.ListStorageLensConfigurationsResponse;

public class ListStorageLensConfigurationsIterable
implements SdkIterable<ListStorageLensConfigurationsResponse> {
    private final S3ControlClient client;
    private final ListStorageLensConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStorageLensConfigurationsIterable(S3ControlClient client, ListStorageLensConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListStorageLensConfigurationsResponseFetcher();
    }

    public Iterator<ListStorageLensConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListStorageLensConfigurationsResponseFetcher
    implements SyncPageFetcher<ListStorageLensConfigurationsResponse> {
        private ListStorageLensConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListStorageLensConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListStorageLensConfigurationsResponse nextPage(ListStorageLensConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListStorageLensConfigurationsIterable.this.client.listStorageLensConfigurations(ListStorageLensConfigurationsIterable.this.firstRequest);
            }
            return ListStorageLensConfigurationsIterable.this.client.listStorageLensConfigurations((ListStorageLensConfigurationsRequest)((Object)ListStorageLensConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

