/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3control.model.RegionalBucket;
import software.amazon.awssdk.services.s3control.model.RegionalBucketListCopier;
import software.amazon.awssdk.services.s3control.model.S3ControlResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRegionalBucketsResponse
extends S3ControlResponse
implements ToCopyableBuilder<Builder, ListRegionalBucketsResponse> {
    private static final SdkField<List<RegionalBucket>> REGIONAL_BUCKET_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RegionalBucketList").getter(ListRegionalBucketsResponse.getter(ListRegionalBucketsResponse::regionalBucketList)).setter(ListRegionalBucketsResponse.setter(Builder::regionalBucketList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionalBucketList").unmarshallLocationName("RegionalBucketList").build(), ListTrait.builder().memberLocationName("RegionalBucket").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RegionalBucket::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionalBucket").unmarshallLocationName("RegionalBucket").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRegionalBucketsResponse.getter(ListRegionalBucketsResponse::nextToken)).setter(ListRegionalBucketsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGIONAL_BUCKET_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("RegionalBucketList", REGIONAL_BUCKET_LIST_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<RegionalBucket> regionalBucketList;
    private final String nextToken;

    private ListRegionalBucketsResponse(BuilderImpl builder) {
        super(builder);
        this.regionalBucketList = builder.regionalBucketList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRegionalBucketList() {
        return this.regionalBucketList != null && !(this.regionalBucketList instanceof SdkAutoConstructList);
    }

    public final List<RegionalBucket> regionalBucketList() {
        return this.regionalBucketList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegionalBucketList() ? this.regionalBucketList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRegionalBucketsResponse)) {
            return false;
        }
        ListRegionalBucketsResponse other = (ListRegionalBucketsResponse)((Object)obj);
        return this.hasRegionalBucketList() == other.hasRegionalBucketList() && Objects.equals(this.regionalBucketList(), other.regionalBucketList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRegionalBucketsResponse").add("RegionalBucketList", this.hasRegionalBucketList() ? this.regionalBucketList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegionalBucketList": {
                return Optional.ofNullable(clazz.cast(this.regionalBucketList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListRegionalBucketsResponse, T> g) {
        return obj -> g.apply((ListRegionalBucketsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3ControlResponse.BuilderImpl
    implements Builder {
        private List<RegionalBucket> regionalBucketList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRegionalBucketsResponse model) {
            super(model);
            this.regionalBucketList(model.regionalBucketList);
            this.nextToken(model.nextToken);
        }

        public final List<RegionalBucket.Builder> getRegionalBucketList() {
            List<RegionalBucket.Builder> result = RegionalBucketListCopier.copyToBuilder(this.regionalBucketList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegionalBucketList(Collection<RegionalBucket.BuilderImpl> regionalBucketList) {
            this.regionalBucketList = RegionalBucketListCopier.copyFromBuilder(regionalBucketList);
        }

        @Override
        public final Builder regionalBucketList(Collection<RegionalBucket> regionalBucketList) {
            this.regionalBucketList = RegionalBucketListCopier.copy(regionalBucketList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionalBucketList(RegionalBucket ... regionalBucketList) {
            this.regionalBucketList(Arrays.asList(regionalBucketList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionalBucketList(Consumer<RegionalBucket.Builder> ... regionalBucketList) {
            this.regionalBucketList(Stream.of(regionalBucketList).map(c -> (RegionalBucket)((RegionalBucket.Builder)RegionalBucket.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRegionalBucketsResponse build() {
            return new ListRegionalBucketsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends S3ControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRegionalBucketsResponse> {
        public Builder regionalBucketList(Collection<RegionalBucket> var1);

        public Builder regionalBucketList(RegionalBucket ... var1);

        public Builder regionalBucketList(Consumer<RegionalBucket.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

