/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3control.model.AccessGrantsLocationsListCopier;
import software.amazon.awssdk.services.s3control.model.ListAccessGrantsLocationsEntry;
import software.amazon.awssdk.services.s3control.model.S3ControlResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAccessGrantsLocationsResponse
extends S3ControlResponse
implements ToCopyableBuilder<Builder, ListAccessGrantsLocationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAccessGrantsLocationsResponse.getter(ListAccessGrantsLocationsResponse::nextToken)).setter(ListAccessGrantsLocationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("NextToken").build()}).build();
    private static final SdkField<List<ListAccessGrantsLocationsEntry>> ACCESS_GRANTS_LOCATIONS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccessGrantsLocationsList").getter(ListAccessGrantsLocationsResponse.getter(ListAccessGrantsLocationsResponse::accessGrantsLocationsList)).setter(ListAccessGrantsLocationsResponse.setter(Builder::accessGrantsLocationsList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessGrantsLocationsList").unmarshallLocationName("AccessGrantsLocationsList").build(), ListTrait.builder().memberLocationName("AccessGrantsLocation").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListAccessGrantsLocationsEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessGrantsLocation").unmarshallLocationName("AccessGrantsLocation").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, ACCESS_GRANTS_LOCATIONS_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("AccessGrantsLocationsList", ACCESS_GRANTS_LOCATIONS_LIST_FIELD);
        }
    });
    private final String nextToken;
    private final List<ListAccessGrantsLocationsEntry> accessGrantsLocationsList;

    private ListAccessGrantsLocationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.accessGrantsLocationsList = builder.accessGrantsLocationsList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasAccessGrantsLocationsList() {
        return this.accessGrantsLocationsList != null && !(this.accessGrantsLocationsList instanceof SdkAutoConstructList);
    }

    public final List<ListAccessGrantsLocationsEntry> accessGrantsLocationsList() {
        return this.accessGrantsLocationsList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccessGrantsLocationsList() ? this.accessGrantsLocationsList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccessGrantsLocationsResponse)) {
            return false;
        }
        ListAccessGrantsLocationsResponse other = (ListAccessGrantsLocationsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasAccessGrantsLocationsList() == other.hasAccessGrantsLocationsList() && Objects.equals(this.accessGrantsLocationsList(), other.accessGrantsLocationsList());
    }

    public final String toString() {
        return ToString.builder((String)"ListAccessGrantsLocationsResponse").add("NextToken", (Object)this.nextToken()).add("AccessGrantsLocationsList", this.hasAccessGrantsLocationsList() ? this.accessGrantsLocationsList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "AccessGrantsLocationsList": {
                return Optional.ofNullable(clazz.cast(this.accessGrantsLocationsList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListAccessGrantsLocationsResponse, T> g) {
        return obj -> g.apply((ListAccessGrantsLocationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3ControlResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ListAccessGrantsLocationsEntry> accessGrantsLocationsList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccessGrantsLocationsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.accessGrantsLocationsList(model.accessGrantsLocationsList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ListAccessGrantsLocationsEntry.Builder> getAccessGrantsLocationsList() {
            List<ListAccessGrantsLocationsEntry.Builder> result = AccessGrantsLocationsListCopier.copyToBuilder(this.accessGrantsLocationsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessGrantsLocationsList(Collection<ListAccessGrantsLocationsEntry.BuilderImpl> accessGrantsLocationsList) {
            this.accessGrantsLocationsList = AccessGrantsLocationsListCopier.copyFromBuilder(accessGrantsLocationsList);
        }

        @Override
        public final Builder accessGrantsLocationsList(Collection<ListAccessGrantsLocationsEntry> accessGrantsLocationsList) {
            this.accessGrantsLocationsList = AccessGrantsLocationsListCopier.copy(accessGrantsLocationsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessGrantsLocationsList(ListAccessGrantsLocationsEntry ... accessGrantsLocationsList) {
            this.accessGrantsLocationsList(Arrays.asList(accessGrantsLocationsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessGrantsLocationsList(Consumer<ListAccessGrantsLocationsEntry.Builder> ... accessGrantsLocationsList) {
            this.accessGrantsLocationsList(Stream.of(accessGrantsLocationsList).map(c -> (ListAccessGrantsLocationsEntry)((ListAccessGrantsLocationsEntry.Builder)ListAccessGrantsLocationsEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListAccessGrantsLocationsResponse build() {
            return new ListAccessGrantsLocationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends S3ControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAccessGrantsLocationsResponse> {
        public Builder nextToken(String var1);

        public Builder accessGrantsLocationsList(Collection<ListAccessGrantsLocationsEntry> var1);

        public Builder accessGrantsLocationsList(ListAccessGrantsLocationsEntry ... var1);

        public Builder accessGrantsLocationsList(Consumer<ListAccessGrantsLocationsEntry.Builder> ... var1);
    }
}

