/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rum.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StateEnum {
    CREATED("CREATED"),
    DELETING("DELETING"),
    ACTIVE("ACTIVE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StateEnum> VALUE_MAP;
    private final String value;

    private StateEnum(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StateEnum fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StateEnum> knownValues() {
        EnumSet<StateEnum> knownValues = EnumSet.allOf(StateEnum.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StateEnum.class, StateEnum::toString);
    }
}

