/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoveryreadiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.route53recoveryreadiness.model.Route53RecoveryReadinessResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetReadinessCheckResponse
extends Route53RecoveryReadinessResponse
implements ToCopyableBuilder<Builder, GetReadinessCheckResponse> {
    private static final SdkField<String> READINESS_CHECK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReadinessCheckArn").getter(GetReadinessCheckResponse.getter(GetReadinessCheckResponse::readinessCheckArn)).setter(GetReadinessCheckResponse.setter(Builder::readinessCheckArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readinessCheckArn").build()}).build();
    private static final SdkField<String> READINESS_CHECK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReadinessCheckName").getter(GetReadinessCheckResponse.getter(GetReadinessCheckResponse::readinessCheckName)).setter(GetReadinessCheckResponse.setter(Builder::readinessCheckName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readinessCheckName").build()}).build();
    private static final SdkField<String> RESOURCE_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceSet").getter(GetReadinessCheckResponse.getter(GetReadinessCheckResponse::resourceSet)).setter(GetReadinessCheckResponse.setter(Builder::resourceSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceSet").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(GetReadinessCheckResponse.getter(GetReadinessCheckResponse::tags)).setter(GetReadinessCheckResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(READINESS_CHECK_ARN_FIELD, READINESS_CHECK_NAME_FIELD, RESOURCE_SET_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("readinessCheckArn", READINESS_CHECK_ARN_FIELD);
            this.put("readinessCheckName", READINESS_CHECK_NAME_FIELD);
            this.put("resourceSet", RESOURCE_SET_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final String readinessCheckArn;
    private final String readinessCheckName;
    private final String resourceSet;
    private final Map<String, String> tags;

    private GetReadinessCheckResponse(BuilderImpl builder) {
        super(builder);
        this.readinessCheckArn = builder.readinessCheckArn;
        this.readinessCheckName = builder.readinessCheckName;
        this.resourceSet = builder.resourceSet;
        this.tags = builder.tags;
    }

    public final String readinessCheckArn() {
        return this.readinessCheckArn;
    }

    public final String readinessCheckName() {
        return this.readinessCheckName;
    }

    public final String resourceSet() {
        return this.resourceSet;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.readinessCheckArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.readinessCheckName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReadinessCheckResponse)) {
            return false;
        }
        GetReadinessCheckResponse other = (GetReadinessCheckResponse)((Object)obj);
        return Objects.equals(this.readinessCheckArn(), other.readinessCheckArn()) && Objects.equals(this.readinessCheckName(), other.readinessCheckName()) && Objects.equals(this.resourceSet(), other.resourceSet()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetReadinessCheckResponse").add("ReadinessCheckArn", (Object)this.readinessCheckArn()).add("ReadinessCheckName", (Object)this.readinessCheckName()).add("ResourceSet", (Object)this.resourceSet()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReadinessCheckArn": {
                return Optional.ofNullable(clazz.cast(this.readinessCheckArn()));
            }
            case "ReadinessCheckName": {
                return Optional.ofNullable(clazz.cast(this.readinessCheckName()));
            }
            case "ResourceSet": {
                return Optional.ofNullable(clazz.cast(this.resourceSet()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetReadinessCheckResponse, T> g) {
        return obj -> g.apply((GetReadinessCheckResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53RecoveryReadinessResponse.BuilderImpl
    implements Builder {
        private String readinessCheckArn;
        private String readinessCheckName;
        private String resourceSet;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetReadinessCheckResponse model) {
            super(model);
            this.readinessCheckArn(model.readinessCheckArn);
            this.readinessCheckName(model.readinessCheckName);
            this.resourceSet(model.resourceSet);
            this.tags(model.tags);
        }

        public final String getReadinessCheckArn() {
            return this.readinessCheckArn;
        }

        public final void setReadinessCheckArn(String readinessCheckArn) {
            this.readinessCheckArn = readinessCheckArn;
        }

        @Override
        public final Builder readinessCheckArn(String readinessCheckArn) {
            this.readinessCheckArn = readinessCheckArn;
            return this;
        }

        public final String getReadinessCheckName() {
            return this.readinessCheckName;
        }

        public final void setReadinessCheckName(String readinessCheckName) {
            this.readinessCheckName = readinessCheckName;
        }

        @Override
        public final Builder readinessCheckName(String readinessCheckName) {
            this.readinessCheckName = readinessCheckName;
            return this;
        }

        public final String getResourceSet() {
            return this.resourceSet;
        }

        public final void setResourceSet(String resourceSet) {
            this.resourceSet = resourceSet;
        }

        @Override
        public final Builder resourceSet(String resourceSet) {
            this.resourceSet = resourceSet;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public GetReadinessCheckResponse build() {
            return new GetReadinessCheckResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Route53RecoveryReadinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetReadinessCheckResponse> {
        public Builder readinessCheckArn(String var1);

        public Builder readinessCheckName(String var1);

        public Builder resourceSet(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

