/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53domains.model.DomainSuggestion;
import software.amazon.awssdk.services.route53domains.model.DomainSuggestionsListCopier;
import software.amazon.awssdk.services.route53domains.model.Route53DomainsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDomainSuggestionsResponse
extends Route53DomainsResponse
implements ToCopyableBuilder<Builder, GetDomainSuggestionsResponse> {
    private static final SdkField<List<DomainSuggestion>> SUGGESTIONS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SuggestionsList").getter(GetDomainSuggestionsResponse.getter(GetDomainSuggestionsResponse::suggestionsList)).setter(GetDomainSuggestionsResponse.setter(Builder::suggestionsList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuggestionsList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DomainSuggestion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUGGESTIONS_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SuggestionsList", SUGGESTIONS_LIST_FIELD);
        }
    });
    private final List<DomainSuggestion> suggestionsList;

    private GetDomainSuggestionsResponse(BuilderImpl builder) {
        super(builder);
        this.suggestionsList = builder.suggestionsList;
    }

    public final boolean hasSuggestionsList() {
        return this.suggestionsList != null && !(this.suggestionsList instanceof SdkAutoConstructList);
    }

    public final List<DomainSuggestion> suggestionsList() {
        return this.suggestionsList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuggestionsList() ? this.suggestionsList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDomainSuggestionsResponse)) {
            return false;
        }
        GetDomainSuggestionsResponse other = (GetDomainSuggestionsResponse)((Object)obj);
        return this.hasSuggestionsList() == other.hasSuggestionsList() && Objects.equals(this.suggestionsList(), other.suggestionsList());
    }

    public final String toString() {
        return ToString.builder((String)"GetDomainSuggestionsResponse").add("SuggestionsList", this.hasSuggestionsList() ? this.suggestionsList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SuggestionsList": {
                return Optional.ofNullable(clazz.cast(this.suggestionsList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetDomainSuggestionsResponse, T> g) {
        return obj -> g.apply((GetDomainSuggestionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53DomainsResponse.BuilderImpl
    implements Builder {
        private List<DomainSuggestion> suggestionsList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDomainSuggestionsResponse model) {
            super(model);
            this.suggestionsList(model.suggestionsList);
        }

        public final List<DomainSuggestion.Builder> getSuggestionsList() {
            List<DomainSuggestion.Builder> result = DomainSuggestionsListCopier.copyToBuilder(this.suggestionsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuggestionsList(Collection<DomainSuggestion.BuilderImpl> suggestionsList) {
            this.suggestionsList = DomainSuggestionsListCopier.copyFromBuilder(suggestionsList);
        }

        @Override
        public final Builder suggestionsList(Collection<DomainSuggestion> suggestionsList) {
            this.suggestionsList = DomainSuggestionsListCopier.copy(suggestionsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggestionsList(DomainSuggestion ... suggestionsList) {
            this.suggestionsList(Arrays.asList(suggestionsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggestionsList(Consumer<DomainSuggestion.Builder> ... suggestionsList) {
            this.suggestionsList(Stream.of(suggestionsList).map(c -> (DomainSuggestion)((DomainSuggestion.Builder)DomainSuggestion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetDomainSuggestionsResponse build() {
            return new GetDomainSuggestionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Route53DomainsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDomainSuggestionsResponse> {
        public Builder suggestionsList(Collection<DomainSuggestion> var1);

        public Builder suggestionsList(DomainSuggestion ... var1);

        public Builder suggestionsList(Consumer<DomainSuggestion.Builder> ... var1);
    }
}

