/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53.model.CloudWatchAlarmConfiguration;
import software.amazon.awssdk.services.route53.model.HealthCheckConfig;
import software.amazon.awssdk.services.route53.model.LinkedService;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HealthCheck
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HealthCheck> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(HealthCheck.getter(HealthCheck::id)).setter(HealthCheck.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id").build()}).build();
    private static final SdkField<String> CALLER_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CallerReference").getter(HealthCheck.getter(HealthCheck::callerReference)).setter(HealthCheck.setter(Builder::callerReference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallerReference").unmarshallLocationName("CallerReference").build()}).build();
    private static final SdkField<LinkedService> LINKED_SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LinkedService").getter(HealthCheck.getter(HealthCheck::linkedService)).setter(HealthCheck.setter(Builder::linkedService)).constructor(LinkedService::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkedService").unmarshallLocationName("LinkedService").build()}).build();
    private static final SdkField<HealthCheckConfig> HEALTH_CHECK_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HealthCheckConfig").getter(HealthCheck.getter(HealthCheck::healthCheckConfig)).setter(HealthCheck.setter(Builder::healthCheckConfig)).constructor(HealthCheckConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckConfig").unmarshallLocationName("HealthCheckConfig").build()}).build();
    private static final SdkField<Long> HEALTH_CHECK_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("HealthCheckVersion").getter(HealthCheck.getter(HealthCheck::healthCheckVersion)).setter(HealthCheck.setter(Builder::healthCheckVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckVersion").unmarshallLocationName("HealthCheckVersion").build()}).build();
    private static final SdkField<CloudWatchAlarmConfiguration> CLOUD_WATCH_ALARM_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudWatchAlarmConfiguration").getter(HealthCheck.getter(HealthCheck::cloudWatchAlarmConfiguration)).setter(HealthCheck.setter(Builder::cloudWatchAlarmConfiguration)).constructor(CloudWatchAlarmConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchAlarmConfiguration").unmarshallLocationName("CloudWatchAlarmConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, CALLER_REFERENCE_FIELD, LINKED_SERVICE_FIELD, HEALTH_CHECK_CONFIG_FIELD, HEALTH_CHECK_VERSION_FIELD, CLOUD_WATCH_ALARM_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Id", ID_FIELD);
            this.put("CallerReference", CALLER_REFERENCE_FIELD);
            this.put("LinkedService", LINKED_SERVICE_FIELD);
            this.put("HealthCheckConfig", HEALTH_CHECK_CONFIG_FIELD);
            this.put("HealthCheckVersion", HEALTH_CHECK_VERSION_FIELD);
            this.put("CloudWatchAlarmConfiguration", CLOUD_WATCH_ALARM_CONFIGURATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String callerReference;
    private final LinkedService linkedService;
    private final HealthCheckConfig healthCheckConfig;
    private final Long healthCheckVersion;
    private final CloudWatchAlarmConfiguration cloudWatchAlarmConfiguration;

    private HealthCheck(BuilderImpl builder) {
        this.id = builder.id;
        this.callerReference = builder.callerReference;
        this.linkedService = builder.linkedService;
        this.healthCheckConfig = builder.healthCheckConfig;
        this.healthCheckVersion = builder.healthCheckVersion;
        this.cloudWatchAlarmConfiguration = builder.cloudWatchAlarmConfiguration;
    }

    public final String id() {
        return this.id;
    }

    public final String callerReference() {
        return this.callerReference;
    }

    public final LinkedService linkedService() {
        return this.linkedService;
    }

    public final HealthCheckConfig healthCheckConfig() {
        return this.healthCheckConfig;
    }

    public final Long healthCheckVersion() {
        return this.healthCheckVersion;
    }

    public final CloudWatchAlarmConfiguration cloudWatchAlarmConfiguration() {
        return this.cloudWatchAlarmConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.callerReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.linkedService());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchAlarmConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HealthCheck)) {
            return false;
        }
        HealthCheck other = (HealthCheck)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.callerReference(), other.callerReference()) && Objects.equals(this.linkedService(), other.linkedService()) && Objects.equals(this.healthCheckConfig(), other.healthCheckConfig()) && Objects.equals(this.healthCheckVersion(), other.healthCheckVersion()) && Objects.equals(this.cloudWatchAlarmConfiguration(), other.cloudWatchAlarmConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"HealthCheck").add("Id", (Object)this.id()).add("CallerReference", (Object)this.callerReference()).add("LinkedService", (Object)this.linkedService()).add("HealthCheckConfig", (Object)this.healthCheckConfig()).add("HealthCheckVersion", (Object)this.healthCheckVersion()).add("CloudWatchAlarmConfiguration", (Object)this.cloudWatchAlarmConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "CallerReference": {
                return Optional.ofNullable(clazz.cast(this.callerReference()));
            }
            case "LinkedService": {
                return Optional.ofNullable(clazz.cast(this.linkedService()));
            }
            case "HealthCheckConfig": {
                return Optional.ofNullable(clazz.cast(this.healthCheckConfig()));
            }
            case "HealthCheckVersion": {
                return Optional.ofNullable(clazz.cast(this.healthCheckVersion()));
            }
            case "CloudWatchAlarmConfiguration": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchAlarmConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<HealthCheck, T> g) {
        return obj -> g.apply((HealthCheck)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String callerReference;
        private LinkedService linkedService;
        private HealthCheckConfig healthCheckConfig;
        private Long healthCheckVersion;
        private CloudWatchAlarmConfiguration cloudWatchAlarmConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(HealthCheck model) {
            this.id(model.id);
            this.callerReference(model.callerReference);
            this.linkedService(model.linkedService);
            this.healthCheckConfig(model.healthCheckConfig);
            this.healthCheckVersion(model.healthCheckVersion);
            this.cloudWatchAlarmConfiguration(model.cloudWatchAlarmConfiguration);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getCallerReference() {
            return this.callerReference;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final LinkedService.Builder getLinkedService() {
            return this.linkedService != null ? this.linkedService.toBuilder() : null;
        }

        public final void setLinkedService(LinkedService.BuilderImpl linkedService) {
            this.linkedService = linkedService != null ? linkedService.build() : null;
        }

        @Override
        public final Builder linkedService(LinkedService linkedService) {
            this.linkedService = linkedService;
            return this;
        }

        public final HealthCheckConfig.Builder getHealthCheckConfig() {
            return this.healthCheckConfig != null ? this.healthCheckConfig.toBuilder() : null;
        }

        public final void setHealthCheckConfig(HealthCheckConfig.BuilderImpl healthCheckConfig) {
            this.healthCheckConfig = healthCheckConfig != null ? healthCheckConfig.build() : null;
        }

        @Override
        public final Builder healthCheckConfig(HealthCheckConfig healthCheckConfig) {
            this.healthCheckConfig = healthCheckConfig;
            return this;
        }

        public final Long getHealthCheckVersion() {
            return this.healthCheckVersion;
        }

        public final void setHealthCheckVersion(Long healthCheckVersion) {
            this.healthCheckVersion = healthCheckVersion;
        }

        @Override
        public final Builder healthCheckVersion(Long healthCheckVersion) {
            this.healthCheckVersion = healthCheckVersion;
            return this;
        }

        public final CloudWatchAlarmConfiguration.Builder getCloudWatchAlarmConfiguration() {
            return this.cloudWatchAlarmConfiguration != null ? this.cloudWatchAlarmConfiguration.toBuilder() : null;
        }

        public final void setCloudWatchAlarmConfiguration(CloudWatchAlarmConfiguration.BuilderImpl cloudWatchAlarmConfiguration) {
            this.cloudWatchAlarmConfiguration = cloudWatchAlarmConfiguration != null ? cloudWatchAlarmConfiguration.build() : null;
        }

        @Override
        public final Builder cloudWatchAlarmConfiguration(CloudWatchAlarmConfiguration cloudWatchAlarmConfiguration) {
            this.cloudWatchAlarmConfiguration = cloudWatchAlarmConfiguration;
            return this;
        }

        public HealthCheck build() {
            return new HealthCheck(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HealthCheck> {
        public Builder id(String var1);

        public Builder callerReference(String var1);

        public Builder linkedService(LinkedService var1);

        default public Builder linkedService(Consumer<LinkedService.Builder> linkedService) {
            return this.linkedService((LinkedService)((LinkedService.Builder)LinkedService.builder().applyMutation(linkedService)).build());
        }

        public Builder healthCheckConfig(HealthCheckConfig var1);

        default public Builder healthCheckConfig(Consumer<HealthCheckConfig.Builder> healthCheckConfig) {
            return this.healthCheckConfig((HealthCheckConfig)((HealthCheckConfig.Builder)HealthCheckConfig.builder().applyMutation(healthCheckConfig)).build());
        }

        public Builder healthCheckVersion(Long var1);

        public Builder cloudWatchAlarmConfiguration(CloudWatchAlarmConfiguration var1);

        default public Builder cloudWatchAlarmConfiguration(Consumer<CloudWatchAlarmConfiguration.Builder> cloudWatchAlarmConfiguration) {
            return this.cloudWatchAlarmConfiguration((CloudWatchAlarmConfiguration)((CloudWatchAlarmConfiguration.Builder)CloudWatchAlarmConfiguration.builder().applyMutation(cloudWatchAlarmConfiguration)).build());
        }
    }
}

