/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourceexplorer2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resourceexplorer2.ResourceExplorer2AsyncClient;
import software.amazon.awssdk.services.resourceexplorer2.internal.UserAgentUtils;
import software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesForMembersRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesForMembersResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.MemberIndex;

public class ListIndexesForMembersPublisher
implements SdkPublisher<ListIndexesForMembersResponse> {
    private final ResourceExplorer2AsyncClient client;
    private final ListIndexesForMembersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListIndexesForMembersPublisher(ResourceExplorer2AsyncClient client, ListIndexesForMembersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListIndexesForMembersPublisher(ResourceExplorer2AsyncClient client, ListIndexesForMembersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListIndexesForMembersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListIndexesForMembersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MemberIndex> indexes() {
        Function<ListIndexesForMembersResponse, Iterator> getIterator = response -> {
            if (response != null && response.indexes() != null) {
                return response.indexes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListIndexesForMembersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListIndexesForMembersResponseFetcher
    implements AsyncPageFetcher<ListIndexesForMembersResponse> {
        private ListIndexesForMembersResponseFetcher() {
        }

        public boolean hasNextPage(ListIndexesForMembersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListIndexesForMembersResponse> nextPage(ListIndexesForMembersResponse previousPage) {
            if (previousPage == null) {
                return ListIndexesForMembersPublisher.this.client.listIndexesForMembers(ListIndexesForMembersPublisher.this.firstRequest);
            }
            return ListIndexesForMembersPublisher.this.client.listIndexesForMembers((ListIndexesForMembersRequest)((Object)ListIndexesForMembersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

