/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resiliencehub.model.ErrorDetail;
import software.amazon.awssdk.services.resiliencehub.model.ErrorDetailListCopier;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubResponse;
import software.amazon.awssdk.services.resiliencehub.model.ResourceImportStatusType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDraftAppVersionResourcesImportStatusResponse
extends ResiliencehubResponse
implements ToCopyableBuilder<Builder, DescribeDraftAppVersionResourcesImportStatusResponse> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appArn").getter(DescribeDraftAppVersionResourcesImportStatusResponse.getter(DescribeDraftAppVersionResourcesImportStatusResponse::appArn)).setter(DescribeDraftAppVersionResourcesImportStatusResponse.setter(Builder::appArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()}).build();
    private static final SdkField<String> APP_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appVersion").getter(DescribeDraftAppVersionResourcesImportStatusResponse.getter(DescribeDraftAppVersionResourcesImportStatusResponse::appVersion)).setter(DescribeDraftAppVersionResourcesImportStatusResponse.setter(Builder::appVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appVersion").build()}).build();
    private static final SdkField<List<ErrorDetail>> ERROR_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errorDetails").getter(DescribeDraftAppVersionResourcesImportStatusResponse.getter(DescribeDraftAppVersionResourcesImportStatusResponse::errorDetails)).setter(DescribeDraftAppVersionResourcesImportStatusResponse.setter(Builder::errorDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ErrorDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorMessage").getter(DescribeDraftAppVersionResourcesImportStatusResponse.getter(DescribeDraftAppVersionResourcesImportStatusResponse::errorMessage)).setter(DescribeDraftAppVersionResourcesImportStatusResponse.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DescribeDraftAppVersionResourcesImportStatusResponse.getter(DescribeDraftAppVersionResourcesImportStatusResponse::statusAsString)).setter(DescribeDraftAppVersionResourcesImportStatusResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> STATUS_CHANGE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("statusChangeTime").getter(DescribeDraftAppVersionResourcesImportStatusResponse.getter(DescribeDraftAppVersionResourcesImportStatusResponse::statusChangeTime)).setter(DescribeDraftAppVersionResourcesImportStatusResponse.setter(Builder::statusChangeTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusChangeTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD, APP_VERSION_FIELD, ERROR_DETAILS_FIELD, ERROR_MESSAGE_FIELD, STATUS_FIELD, STATUS_CHANGE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("appArn", APP_ARN_FIELD);
            this.put("appVersion", APP_VERSION_FIELD);
            this.put("errorDetails", ERROR_DETAILS_FIELD);
            this.put("errorMessage", ERROR_MESSAGE_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("statusChangeTime", STATUS_CHANGE_TIME_FIELD);
        }
    });
    private final String appArn;
    private final String appVersion;
    private final List<ErrorDetail> errorDetails;
    private final String errorMessage;
    private final String status;
    private final Instant statusChangeTime;

    private DescribeDraftAppVersionResourcesImportStatusResponse(BuilderImpl builder) {
        super(builder);
        this.appArn = builder.appArn;
        this.appVersion = builder.appVersion;
        this.errorDetails = builder.errorDetails;
        this.errorMessage = builder.errorMessage;
        this.status = builder.status;
        this.statusChangeTime = builder.statusChangeTime;
    }

    public final String appArn() {
        return this.appArn;
    }

    public final String appVersion() {
        return this.appVersion;
    }

    public final boolean hasErrorDetails() {
        return this.errorDetails != null && !(this.errorDetails instanceof SdkAutoConstructList);
    }

    public final List<ErrorDetail> errorDetails() {
        return this.errorDetails;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final ResourceImportStatusType status() {
        return ResourceImportStatusType.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant statusChangeTime() {
        return this.statusChangeTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.appVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrorDetails() ? this.errorDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusChangeTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDraftAppVersionResourcesImportStatusResponse)) {
            return false;
        }
        DescribeDraftAppVersionResourcesImportStatusResponse other = (DescribeDraftAppVersionResourcesImportStatusResponse)((Object)obj);
        return Objects.equals(this.appArn(), other.appArn()) && Objects.equals(this.appVersion(), other.appVersion()) && this.hasErrorDetails() == other.hasErrorDetails() && Objects.equals(this.errorDetails(), other.errorDetails()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusChangeTime(), other.statusChangeTime());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDraftAppVersionResourcesImportStatusResponse").add("AppArn", (Object)this.appArn()).add("AppVersion", (Object)this.appVersion()).add("ErrorDetails", this.hasErrorDetails() ? this.errorDetails() : null).add("ErrorMessage", (Object)this.errorMessage()).add("Status", (Object)this.statusAsString()).add("StatusChangeTime", (Object)this.statusChangeTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appArn": {
                return Optional.ofNullable(clazz.cast(this.appArn()));
            }
            case "appVersion": {
                return Optional.ofNullable(clazz.cast(this.appVersion()));
            }
            case "errorDetails": {
                return Optional.ofNullable(clazz.cast(this.errorDetails()));
            }
            case "errorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusChangeTime": {
                return Optional.ofNullable(clazz.cast(this.statusChangeTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDraftAppVersionResourcesImportStatusResponse, T> g) {
        return obj -> g.apply((DescribeDraftAppVersionResourcesImportStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubResponse.BuilderImpl
    implements Builder {
        private String appArn;
        private String appVersion;
        private List<ErrorDetail> errorDetails = DefaultSdkAutoConstructList.getInstance();
        private String errorMessage;
        private String status;
        private Instant statusChangeTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDraftAppVersionResourcesImportStatusResponse model) {
            super(model);
            this.appArn(model.appArn);
            this.appVersion(model.appVersion);
            this.errorDetails(model.errorDetails);
            this.errorMessage(model.errorMessage);
            this.status(model.status);
            this.statusChangeTime(model.statusChangeTime);
        }

        public final String getAppArn() {
            return this.appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final String getAppVersion() {
            return this.appVersion;
        }

        public final void setAppVersion(String appVersion) {
            this.appVersion = appVersion;
        }

        @Override
        public final Builder appVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public final List<ErrorDetail.Builder> getErrorDetails() {
            List<ErrorDetail.Builder> result = ErrorDetailListCopier.copyToBuilder(this.errorDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrorDetails(Collection<ErrorDetail.BuilderImpl> errorDetails) {
            this.errorDetails = ErrorDetailListCopier.copyFromBuilder(errorDetails);
        }

        @Override
        public final Builder errorDetails(Collection<ErrorDetail> errorDetails) {
            this.errorDetails = ErrorDetailListCopier.copy(errorDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorDetails(ErrorDetail ... errorDetails) {
            this.errorDetails(Arrays.asList(errorDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorDetails(Consumer<ErrorDetail.Builder> ... errorDetails) {
            this.errorDetails(Stream.of(errorDetails).map(c -> (ErrorDetail)((ErrorDetail.Builder)ErrorDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceImportStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStatusChangeTime() {
            return this.statusChangeTime;
        }

        public final void setStatusChangeTime(Instant statusChangeTime) {
            this.statusChangeTime = statusChangeTime;
        }

        @Override
        public final Builder statusChangeTime(Instant statusChangeTime) {
            this.statusChangeTime = statusChangeTime;
            return this;
        }

        @Override
        public DescribeDraftAppVersionResourcesImportStatusResponse build() {
            return new DescribeDraftAppVersionResourcesImportStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ResiliencehubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDraftAppVersionResourcesImportStatusResponse> {
        public Builder appArn(String var1);

        public Builder appVersion(String var1);

        public Builder errorDetails(Collection<ErrorDetail> var1);

        public Builder errorDetails(ErrorDetail ... var1);

        public Builder errorDetails(Consumer<ErrorDetail.Builder> ... var1);

        public Builder errorMessage(String var1);

        public Builder status(String var1);

        public Builder status(ResourceImportStatusType var1);

        public Builder statusChangeTime(Instant var1);
    }
}

