/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.ComparedFace;
import software.amazon.awssdk.services.rekognition.model.KnownGender;
import software.amazon.awssdk.services.rekognition.model.UrlsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Celebrity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Celebrity> {
    private static final SdkField<List<String>> URLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Urls").getter(Celebrity.getter(Celebrity::urls)).setter(Celebrity.setter(Builder::urls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Urls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Celebrity.getter(Celebrity::name)).setter(Celebrity.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(Celebrity.getter(Celebrity::id)).setter(Celebrity.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<ComparedFace> FACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Face").getter(Celebrity.getter(Celebrity::face)).setter(Celebrity.setter(Builder::face)).constructor(ComparedFace::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Face").build()}).build();
    private static final SdkField<Float> MATCH_CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("MatchConfidence").getter(Celebrity.getter(Celebrity::matchConfidence)).setter(Celebrity.setter(Builder::matchConfidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchConfidence").build()}).build();
    private static final SdkField<KnownGender> KNOWN_GENDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KnownGender").getter(Celebrity.getter(Celebrity::knownGender)).setter(Celebrity.setter(Builder::knownGender)).constructor(KnownGender::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KnownGender").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URLS_FIELD, NAME_FIELD, ID_FIELD, FACE_FIELD, MATCH_CONFIDENCE_FIELD, KNOWN_GENDER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Urls", URLS_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("Id", ID_FIELD);
            this.put("Face", FACE_FIELD);
            this.put("MatchConfidence", MATCH_CONFIDENCE_FIELD);
            this.put("KnownGender", KNOWN_GENDER_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> urls;
    private final String name;
    private final String id;
    private final ComparedFace face;
    private final Float matchConfidence;
    private final KnownGender knownGender;

    private Celebrity(BuilderImpl builder) {
        this.urls = builder.urls;
        this.name = builder.name;
        this.id = builder.id;
        this.face = builder.face;
        this.matchConfidence = builder.matchConfidence;
        this.knownGender = builder.knownGender;
    }

    public final boolean hasUrls() {
        return this.urls != null && !(this.urls instanceof SdkAutoConstructList);
    }

    public final List<String> urls() {
        return this.urls;
    }

    public final String name() {
        return this.name;
    }

    public final String id() {
        return this.id;
    }

    public final ComparedFace face() {
        return this.face;
    }

    public final Float matchConfidence() {
        return this.matchConfidence;
    }

    public final KnownGender knownGender() {
        return this.knownGender;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUrls() ? this.urls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.face());
        hashCode = 31 * hashCode + Objects.hashCode(this.matchConfidence());
        hashCode = 31 * hashCode + Objects.hashCode(this.knownGender());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Celebrity)) {
            return false;
        }
        Celebrity other = (Celebrity)obj;
        return this.hasUrls() == other.hasUrls() && Objects.equals(this.urls(), other.urls()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.face(), other.face()) && Objects.equals(this.matchConfidence(), other.matchConfidence()) && Objects.equals(this.knownGender(), other.knownGender());
    }

    public final String toString() {
        return ToString.builder((String)"Celebrity").add("Urls", this.hasUrls() ? this.urls() : null).add("Name", (Object)this.name()).add("Id", (Object)this.id()).add("Face", (Object)this.face()).add("MatchConfidence", (Object)this.matchConfidence()).add("KnownGender", (Object)this.knownGender()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Urls": {
                return Optional.ofNullable(clazz.cast(this.urls()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Face": {
                return Optional.ofNullable(clazz.cast(this.face()));
            }
            case "MatchConfidence": {
                return Optional.ofNullable(clazz.cast(this.matchConfidence()));
            }
            case "KnownGender": {
                return Optional.ofNullable(clazz.cast(this.knownGender()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Celebrity, T> g) {
        return obj -> g.apply((Celebrity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> urls = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private String id;
        private ComparedFace face;
        private Float matchConfidence;
        private KnownGender knownGender;

        private BuilderImpl() {
        }

        private BuilderImpl(Celebrity model) {
            this.urls(model.urls);
            this.name(model.name);
            this.id(model.id);
            this.face(model.face);
            this.matchConfidence(model.matchConfidence);
            this.knownGender(model.knownGender);
        }

        public final Collection<String> getUrls() {
            if (this.urls instanceof SdkAutoConstructList) {
                return null;
            }
            return this.urls;
        }

        public final void setUrls(Collection<String> urls) {
            this.urls = UrlsCopier.copy(urls);
        }

        @Override
        public final Builder urls(Collection<String> urls) {
            this.urls = UrlsCopier.copy(urls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder urls(String ... urls) {
            this.urls(Arrays.asList(urls));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final ComparedFace.Builder getFace() {
            return this.face != null ? this.face.toBuilder() : null;
        }

        public final void setFace(ComparedFace.BuilderImpl face) {
            this.face = face != null ? face.build() : null;
        }

        @Override
        public final Builder face(ComparedFace face) {
            this.face = face;
            return this;
        }

        public final Float getMatchConfidence() {
            return this.matchConfidence;
        }

        public final void setMatchConfidence(Float matchConfidence) {
            this.matchConfidence = matchConfidence;
        }

        @Override
        public final Builder matchConfidence(Float matchConfidence) {
            this.matchConfidence = matchConfidence;
            return this;
        }

        public final KnownGender.Builder getKnownGender() {
            return this.knownGender != null ? this.knownGender.toBuilder() : null;
        }

        public final void setKnownGender(KnownGender.BuilderImpl knownGender) {
            this.knownGender = knownGender != null ? knownGender.build() : null;
        }

        @Override
        public final Builder knownGender(KnownGender knownGender) {
            this.knownGender = knownGender;
            return this;
        }

        public Celebrity build() {
            return new Celebrity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Celebrity> {
        public Builder urls(Collection<String> var1);

        public Builder urls(String ... var1);

        public Builder name(String var1);

        public Builder id(String var1);

        public Builder face(ComparedFace var1);

        default public Builder face(Consumer<ComparedFace.Builder> face) {
            return this.face((ComparedFace)((ComparedFace.Builder)ComparedFace.builder().applyMutation(face)).build());
        }

        public Builder matchConfidence(Float var1);

        public Builder knownGender(KnownGender var1);

        default public Builder knownGender(Consumer<KnownGender.Builder> knownGender) {
            return this.knownGender((KnownGender)((KnownGender.Builder)KnownGender.builder().applyMutation(knownGender)).build());
        }
    }
}

