/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshiftserverless.RedshiftServerlessAsyncClient;
import software.amazon.awssdk.services.redshiftserverless.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotCopyConfigurationsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotCopyConfigurationsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.SnapshotCopyConfiguration;

public class ListSnapshotCopyConfigurationsPublisher
implements SdkPublisher<ListSnapshotCopyConfigurationsResponse> {
    private final RedshiftServerlessAsyncClient client;
    private final ListSnapshotCopyConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSnapshotCopyConfigurationsPublisher(RedshiftServerlessAsyncClient client, ListSnapshotCopyConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSnapshotCopyConfigurationsPublisher(RedshiftServerlessAsyncClient client, ListSnapshotCopyConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSnapshotCopyConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSnapshotCopyConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SnapshotCopyConfiguration> snapshotCopyConfigurations() {
        Function<ListSnapshotCopyConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.snapshotCopyConfigurations() != null) {
                return response.snapshotCopyConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSnapshotCopyConfigurationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSnapshotCopyConfigurationsResponseFetcher
    implements AsyncPageFetcher<ListSnapshotCopyConfigurationsResponse> {
        private ListSnapshotCopyConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListSnapshotCopyConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSnapshotCopyConfigurationsResponse> nextPage(ListSnapshotCopyConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListSnapshotCopyConfigurationsPublisher.this.client.listSnapshotCopyConfigurations(ListSnapshotCopyConfigurationsPublisher.this.firstRequest);
            }
            return ListSnapshotCopyConfigurationsPublisher.this.client.listSnapshotCopyConfigurations((ListSnapshotCopyConfigurationsRequest)((Object)ListSnapshotCopyConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

