/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.CertificateAssociation;
import software.amazon.awssdk.services.redshift.model.CertificateAssociationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Association
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Association> {
    private static final SdkField<String> CUSTOM_DOMAIN_CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomDomainCertificateArn").getter(Association.getter(Association::customDomainCertificateArn)).setter(Association.setter(Builder::customDomainCertificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDomainCertificateArn").build()}).build();
    private static final SdkField<Instant> CUSTOM_DOMAIN_CERTIFICATE_EXPIRY_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CustomDomainCertificateExpiryDate").getter(Association.getter(Association::customDomainCertificateExpiryDate)).setter(Association.setter(Builder::customDomainCertificateExpiryDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDomainCertificateExpiryDate").build()}).build();
    private static final SdkField<List<CertificateAssociation>> CERTIFICATE_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CertificateAssociations").getter(Association.getter(Association::certificateAssociations)).setter(Association.setter(Builder::certificateAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAssociations").build(), ListTrait.builder().memberLocationName("CertificateAssociation").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CertificateAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAssociation").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_DOMAIN_CERTIFICATE_ARN_FIELD, CUSTOM_DOMAIN_CERTIFICATE_EXPIRY_DATE_FIELD, CERTIFICATE_ASSOCIATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CustomDomainCertificateArn", CUSTOM_DOMAIN_CERTIFICATE_ARN_FIELD);
            this.put("CustomDomainCertificateExpiryDate", CUSTOM_DOMAIN_CERTIFICATE_EXPIRY_DATE_FIELD);
            this.put("CertificateAssociations", CERTIFICATE_ASSOCIATIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String customDomainCertificateArn;
    private final Instant customDomainCertificateExpiryDate;
    private final List<CertificateAssociation> certificateAssociations;

    private Association(BuilderImpl builder) {
        this.customDomainCertificateArn = builder.customDomainCertificateArn;
        this.customDomainCertificateExpiryDate = builder.customDomainCertificateExpiryDate;
        this.certificateAssociations = builder.certificateAssociations;
    }

    public final String customDomainCertificateArn() {
        return this.customDomainCertificateArn;
    }

    public final Instant customDomainCertificateExpiryDate() {
        return this.customDomainCertificateExpiryDate;
    }

    public final boolean hasCertificateAssociations() {
        return this.certificateAssociations != null && !(this.certificateAssociations instanceof SdkAutoConstructList);
    }

    public final List<CertificateAssociation> certificateAssociations() {
        return this.certificateAssociations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.customDomainCertificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.customDomainCertificateExpiryDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCertificateAssociations() ? this.certificateAssociations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Association)) {
            return false;
        }
        Association other = (Association)obj;
        return Objects.equals(this.customDomainCertificateArn(), other.customDomainCertificateArn()) && Objects.equals(this.customDomainCertificateExpiryDate(), other.customDomainCertificateExpiryDate()) && this.hasCertificateAssociations() == other.hasCertificateAssociations() && Objects.equals(this.certificateAssociations(), other.certificateAssociations());
    }

    public final String toString() {
        return ToString.builder((String)"Association").add("CustomDomainCertificateArn", (Object)this.customDomainCertificateArn()).add("CustomDomainCertificateExpiryDate", (Object)this.customDomainCertificateExpiryDate()).add("CertificateAssociations", this.hasCertificateAssociations() ? this.certificateAssociations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomDomainCertificateArn": {
                return Optional.ofNullable(clazz.cast(this.customDomainCertificateArn()));
            }
            case "CustomDomainCertificateExpiryDate": {
                return Optional.ofNullable(clazz.cast(this.customDomainCertificateExpiryDate()));
            }
            case "CertificateAssociations": {
                return Optional.ofNullable(clazz.cast(this.certificateAssociations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Association, T> g) {
        return obj -> g.apply((Association)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String customDomainCertificateArn;
        private Instant customDomainCertificateExpiryDate;
        private List<CertificateAssociation> certificateAssociations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Association model) {
            this.customDomainCertificateArn(model.customDomainCertificateArn);
            this.customDomainCertificateExpiryDate(model.customDomainCertificateExpiryDate);
            this.certificateAssociations(model.certificateAssociations);
        }

        public final String getCustomDomainCertificateArn() {
            return this.customDomainCertificateArn;
        }

        public final void setCustomDomainCertificateArn(String customDomainCertificateArn) {
            this.customDomainCertificateArn = customDomainCertificateArn;
        }

        @Override
        public final Builder customDomainCertificateArn(String customDomainCertificateArn) {
            this.customDomainCertificateArn = customDomainCertificateArn;
            return this;
        }

        public final Instant getCustomDomainCertificateExpiryDate() {
            return this.customDomainCertificateExpiryDate;
        }

        public final void setCustomDomainCertificateExpiryDate(Instant customDomainCertificateExpiryDate) {
            this.customDomainCertificateExpiryDate = customDomainCertificateExpiryDate;
        }

        @Override
        public final Builder customDomainCertificateExpiryDate(Instant customDomainCertificateExpiryDate) {
            this.customDomainCertificateExpiryDate = customDomainCertificateExpiryDate;
            return this;
        }

        public final List<CertificateAssociation.Builder> getCertificateAssociations() {
            List<CertificateAssociation.Builder> result = CertificateAssociationListCopier.copyToBuilder(this.certificateAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCertificateAssociations(Collection<CertificateAssociation.BuilderImpl> certificateAssociations) {
            this.certificateAssociations = CertificateAssociationListCopier.copyFromBuilder(certificateAssociations);
        }

        @Override
        public final Builder certificateAssociations(Collection<CertificateAssociation> certificateAssociations) {
            this.certificateAssociations = CertificateAssociationListCopier.copy(certificateAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificateAssociations(CertificateAssociation ... certificateAssociations) {
            this.certificateAssociations(Arrays.asList(certificateAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificateAssociations(Consumer<CertificateAssociation.Builder> ... certificateAssociations) {
            this.certificateAssociations(Stream.of(certificateAssociations).map(c -> (CertificateAssociation)((CertificateAssociation.Builder)CertificateAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Association build() {
            return new Association(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Association> {
        public Builder customDomainCertificateArn(String var1);

        public Builder customDomainCertificateExpiryDate(Instant var1);

        public Builder certificateAssociations(Collection<CertificateAssociation> var1);

        public Builder certificateAssociations(CertificateAssociation ... var1);

        public Builder certificateAssociations(Consumer<CertificateAssociation.Builder> ... var1);
    }
}

