/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServerlessV2ScalingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServerlessV2ScalingConfiguration> {
    private static final SdkField<Double> MIN_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MinCapacity").getter(ServerlessV2ScalingConfiguration.getter(ServerlessV2ScalingConfiguration::minCapacity)).setter(ServerlessV2ScalingConfiguration.setter(Builder::minCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinCapacity").build()}).build();
    private static final SdkField<Double> MAX_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MaxCapacity").getter(ServerlessV2ScalingConfiguration.getter(ServerlessV2ScalingConfiguration::maxCapacity)).setter(ServerlessV2ScalingConfiguration.setter(Builder::maxCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCapacity").build()}).build();
    private static final SdkField<Integer> SECONDS_UNTIL_AUTO_PAUSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SecondsUntilAutoPause").getter(ServerlessV2ScalingConfiguration.getter(ServerlessV2ScalingConfiguration::secondsUntilAutoPause)).setter(ServerlessV2ScalingConfiguration.setter(Builder::secondsUntilAutoPause)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondsUntilAutoPause").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_CAPACITY_FIELD, MAX_CAPACITY_FIELD, SECONDS_UNTIL_AUTO_PAUSE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("MinCapacity", MIN_CAPACITY_FIELD);
            this.put("MaxCapacity", MAX_CAPACITY_FIELD);
            this.put("SecondsUntilAutoPause", SECONDS_UNTIL_AUTO_PAUSE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Double minCapacity;
    private final Double maxCapacity;
    private final Integer secondsUntilAutoPause;

    private ServerlessV2ScalingConfiguration(BuilderImpl builder) {
        this.minCapacity = builder.minCapacity;
        this.maxCapacity = builder.maxCapacity;
        this.secondsUntilAutoPause = builder.secondsUntilAutoPause;
    }

    public final Double minCapacity() {
        return this.minCapacity;
    }

    public final Double maxCapacity() {
        return this.maxCapacity;
    }

    public final Integer secondsUntilAutoPause() {
        return this.secondsUntilAutoPause;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.minCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondsUntilAutoPause());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerlessV2ScalingConfiguration)) {
            return false;
        }
        ServerlessV2ScalingConfiguration other = (ServerlessV2ScalingConfiguration)obj;
        return Objects.equals(this.minCapacity(), other.minCapacity()) && Objects.equals(this.maxCapacity(), other.maxCapacity()) && Objects.equals(this.secondsUntilAutoPause(), other.secondsUntilAutoPause());
    }

    public final String toString() {
        return ToString.builder((String)"ServerlessV2ScalingConfiguration").add("MinCapacity", (Object)this.minCapacity()).add("MaxCapacity", (Object)this.maxCapacity()).add("SecondsUntilAutoPause", (Object)this.secondsUntilAutoPause()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MinCapacity": {
                return Optional.ofNullable(clazz.cast(this.minCapacity()));
            }
            case "MaxCapacity": {
                return Optional.ofNullable(clazz.cast(this.maxCapacity()));
            }
            case "SecondsUntilAutoPause": {
                return Optional.ofNullable(clazz.cast(this.secondsUntilAutoPause()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ServerlessV2ScalingConfiguration, T> g) {
        return obj -> g.apply((ServerlessV2ScalingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double minCapacity;
        private Double maxCapacity;
        private Integer secondsUntilAutoPause;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerlessV2ScalingConfiguration model) {
            this.minCapacity(model.minCapacity);
            this.maxCapacity(model.maxCapacity);
            this.secondsUntilAutoPause(model.secondsUntilAutoPause);
        }

        public final Double getMinCapacity() {
            return this.minCapacity;
        }

        public final void setMinCapacity(Double minCapacity) {
            this.minCapacity = minCapacity;
        }

        @Override
        public final Builder minCapacity(Double minCapacity) {
            this.minCapacity = minCapacity;
            return this;
        }

        public final Double getMaxCapacity() {
            return this.maxCapacity;
        }

        public final void setMaxCapacity(Double maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Double maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final Integer getSecondsUntilAutoPause() {
            return this.secondsUntilAutoPause;
        }

        public final void setSecondsUntilAutoPause(Integer secondsUntilAutoPause) {
            this.secondsUntilAutoPause = secondsUntilAutoPause;
        }

        @Override
        public final Builder secondsUntilAutoPause(Integer secondsUntilAutoPause) {
            this.secondsUntilAutoPause = secondsUntilAutoPause;
            return this;
        }

        public ServerlessV2ScalingConfiguration build() {
            return new ServerlessV2ScalingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServerlessV2ScalingConfiguration> {
        public Builder minCapacity(Double var1);

        public Builder maxCapacity(Double var1);

        public Builder secondsUntilAutoPause(Integer var1);
    }
}

