/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ram.model.RamResponse;
import software.amazon.awssdk.services.ram.model.ServiceNameAndResourceType;
import software.amazon.awssdk.services.ram.model.ServiceNameAndResourceTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResourceTypesResponse
extends RamResponse
implements ToCopyableBuilder<Builder, ListResourceTypesResponse> {
    private static final SdkField<List<ServiceNameAndResourceType>> RESOURCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceTypes").getter(ListResourceTypesResponse.getter(ListResourceTypesResponse::resourceTypes)).setter(ListResourceTypesResponse.setter(Builder::resourceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceNameAndResourceType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListResourceTypesResponse.getter(ListResourceTypesResponse::nextToken)).setter(ListResourceTypesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("resourceTypes", RESOURCE_TYPES_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ServiceNameAndResourceType> resourceTypes;
    private final String nextToken;

    private ListResourceTypesResponse(BuilderImpl builder) {
        super(builder);
        this.resourceTypes = builder.resourceTypes;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasResourceTypes() {
        return this.resourceTypes != null && !(this.resourceTypes instanceof SdkAutoConstructList);
    }

    public final List<ServiceNameAndResourceType> resourceTypes() {
        return this.resourceTypes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTypes() ? this.resourceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceTypesResponse)) {
            return false;
        }
        ListResourceTypesResponse other = (ListResourceTypesResponse)((Object)obj);
        return this.hasResourceTypes() == other.hasResourceTypes() && Objects.equals(this.resourceTypes(), other.resourceTypes()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListResourceTypesResponse").add("ResourceTypes", this.hasResourceTypes() ? this.resourceTypes() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceTypes": {
                return Optional.ofNullable(clazz.cast(this.resourceTypes()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListResourceTypesResponse, T> g) {
        return obj -> g.apply((ListResourceTypesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RamResponse.BuilderImpl
    implements Builder {
        private List<ServiceNameAndResourceType> resourceTypes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceTypesResponse model) {
            super(model);
            this.resourceTypes(model.resourceTypes);
            this.nextToken(model.nextToken);
        }

        public final List<ServiceNameAndResourceType.Builder> getResourceTypes() {
            List<ServiceNameAndResourceType.Builder> result = ServiceNameAndResourceTypeListCopier.copyToBuilder(this.resourceTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceTypes(Collection<ServiceNameAndResourceType.BuilderImpl> resourceTypes) {
            this.resourceTypes = ServiceNameAndResourceTypeListCopier.copyFromBuilder(resourceTypes);
        }

        @Override
        public final Builder resourceTypes(Collection<ServiceNameAndResourceType> resourceTypes) {
            this.resourceTypes = ServiceNameAndResourceTypeListCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(ServiceNameAndResourceType ... resourceTypes) {
            this.resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(Consumer<ServiceNameAndResourceType.Builder> ... resourceTypes) {
            this.resourceTypes(Stream.of(resourceTypes).map(c -> (ServiceNameAndResourceType)((ServiceNameAndResourceType.Builder)ServiceNameAndResourceType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListResourceTypesResponse build() {
            return new ListResourceTypesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResourceTypesResponse> {
        public Builder resourceTypes(Collection<ServiceNameAndResourceType> var1);

        public Builder resourceTypes(ServiceNameAndResourceType ... var1);

        public Builder resourceTypes(Consumer<ServiceNameAndResourceType.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

