/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.ImageSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Image
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Image> {
    private static final SdkField<ImageSource> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Source").getter(Image.getter(Image::source)).setter(Image.setter(Builder::source)).constructor(ImageSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<String> GENERATED_IMAGE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GeneratedImageUrl").getter(Image.getter(Image::generatedImageUrl)).setter(Image.setter(Builder::generatedImageUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratedImageUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD, GENERATED_IMAGE_URL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Source", SOURCE_FIELD);
            this.put("GeneratedImageUrl", GENERATED_IMAGE_URL_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final ImageSource source;
    private final String generatedImageUrl;

    private Image(BuilderImpl builder) {
        this.source = builder.source;
        this.generatedImageUrl = builder.generatedImageUrl;
    }

    public final ImageSource source() {
        return this.source;
    }

    public final String generatedImageUrl() {
        return this.generatedImageUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.generatedImageUrl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Image)) {
            return false;
        }
        Image other = (Image)obj;
        return Objects.equals(this.source(), other.source()) && Objects.equals(this.generatedImageUrl(), other.generatedImageUrl());
    }

    public final String toString() {
        return ToString.builder((String)"Image").add("Source", (Object)this.source()).add("GeneratedImageUrl", (Object)this.generatedImageUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "GeneratedImageUrl": {
                return Optional.ofNullable(clazz.cast(this.generatedImageUrl()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Image, T> g) {
        return obj -> g.apply((Image)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ImageSource source;
        private String generatedImageUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(Image model) {
            this.source(model.source);
            this.generatedImageUrl(model.generatedImageUrl);
        }

        public final ImageSource.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(ImageSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(ImageSource source) {
            this.source = source;
            return this;
        }

        public final String getGeneratedImageUrl() {
            return this.generatedImageUrl;
        }

        public final void setGeneratedImageUrl(String generatedImageUrl) {
            this.generatedImageUrl = generatedImageUrl;
        }

        @Override
        public final Builder generatedImageUrl(String generatedImageUrl) {
            this.generatedImageUrl = generatedImageUrl;
            return this;
        }

        public Image build() {
            return new Image(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Image> {
        public Builder source(ImageSource var1);

        default public Builder source(Consumer<ImageSource.Builder> source) {
            return this.source((ImageSource)((ImageSource.Builder)ImageSource.builder().applyMutation(source)).build());
        }

        public Builder generatedImageUrl(String var1);
    }
}

