/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.DataSource;

final class DataSourceListCopier {
    DataSourceListCopier() {
    }

    static List<DataSource> copy(Collection<? extends DataSource> dataSourceListParam) {
        Object list;
        if (dataSourceListParam == null || dataSourceListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(dataSourceListParam.size());
            dataSourceListParam.forEach(entry -> modifiableList.add(entry));
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<DataSource> copyFromBuilder(Collection<? extends DataSource.Builder> dataSourceListParam) {
        Object list;
        if (dataSourceListParam == null || dataSourceListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(dataSourceListParam.size());
            dataSourceListParam.forEach(entry -> {
                DataSource member = entry == null ? null : (DataSource)entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<DataSource.Builder> copyToBuilder(Collection<? extends DataSource> dataSourceListParam) {
        Object list;
        if (dataSourceListParam == null || dataSourceListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(dataSourceListParam.size());
            dataSourceListParam.forEach(entry -> {
                DataSource.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}

