/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.DashboardVersion;
import software.amazon.awssdk.services.quicksight.model.LinkEntityArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Dashboard
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Dashboard> {
    private static final SdkField<String> DASHBOARD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DashboardId").getter(Dashboard.getter(Dashboard::dashboardId)).setter(Dashboard.setter(Builder::dashboardId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(Dashboard.getter(Dashboard::arn)).setter(Dashboard.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Dashboard.getter(Dashboard::name)).setter(Dashboard.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<DashboardVersion> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Version").getter(Dashboard.getter(Dashboard::version)).setter(Dashboard.setter(Builder::version)).constructor(DashboardVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(Dashboard.getter(Dashboard::createdTime)).setter(Dashboard.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<Instant> LAST_PUBLISHED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastPublishedTime").getter(Dashboard.getter(Dashboard::lastPublishedTime)).setter(Dashboard.setter(Builder::lastPublishedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastPublishedTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(Dashboard.getter(Dashboard::lastUpdatedTime)).setter(Dashboard.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<List<String>> LINK_ENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LinkEntities").getter(Dashboard.getter(Dashboard::linkEntities)).setter(Dashboard.setter(Builder::linkEntities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkEntities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_ID_FIELD, ARN_FIELD, NAME_FIELD, VERSION_FIELD, CREATED_TIME_FIELD, LAST_PUBLISHED_TIME_FIELD, LAST_UPDATED_TIME_FIELD, LINK_ENTITIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DashboardId", DASHBOARD_ID_FIELD);
            this.put("Arn", ARN_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("Version", VERSION_FIELD);
            this.put("CreatedTime", CREATED_TIME_FIELD);
            this.put("LastPublishedTime", LAST_PUBLISHED_TIME_FIELD);
            this.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
            this.put("LinkEntities", LINK_ENTITIES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String dashboardId;
    private final String arn;
    private final String name;
    private final DashboardVersion version;
    private final Instant createdTime;
    private final Instant lastPublishedTime;
    private final Instant lastUpdatedTime;
    private final List<String> linkEntities;

    private Dashboard(BuilderImpl builder) {
        this.dashboardId = builder.dashboardId;
        this.arn = builder.arn;
        this.name = builder.name;
        this.version = builder.version;
        this.createdTime = builder.createdTime;
        this.lastPublishedTime = builder.lastPublishedTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.linkEntities = builder.linkEntities;
    }

    public final String dashboardId() {
        return this.dashboardId;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final DashboardVersion version() {
        return this.version;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final Instant lastPublishedTime() {
        return this.lastPublishedTime;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final boolean hasLinkEntities() {
        return this.linkEntities != null && !(this.linkEntities instanceof SdkAutoConstructList);
    }

    public final List<String> linkEntities() {
        return this.linkEntities;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastPublishedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLinkEntities() ? this.linkEntities() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Dashboard)) {
            return false;
        }
        Dashboard other = (Dashboard)obj;
        return Objects.equals(this.dashboardId(), other.dashboardId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.lastPublishedTime(), other.lastPublishedTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && this.hasLinkEntities() == other.hasLinkEntities() && Objects.equals(this.linkEntities(), other.linkEntities());
    }

    public final String toString() {
        return ToString.builder((String)"Dashboard").add("DashboardId", (Object)this.dashboardId()).add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Version", (Object)this.version()).add("CreatedTime", (Object)this.createdTime()).add("LastPublishedTime", (Object)this.lastPublishedTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("LinkEntities", this.hasLinkEntities() ? this.linkEntities() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DashboardId": {
                return Optional.ofNullable(clazz.cast(this.dashboardId()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "LastPublishedTime": {
                return Optional.ofNullable(clazz.cast(this.lastPublishedTime()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "LinkEntities": {
                return Optional.ofNullable(clazz.cast(this.linkEntities()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Dashboard, T> g) {
        return obj -> g.apply((Dashboard)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dashboardId;
        private String arn;
        private String name;
        private DashboardVersion version;
        private Instant createdTime;
        private Instant lastPublishedTime;
        private Instant lastUpdatedTime;
        private List<String> linkEntities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Dashboard model) {
            this.dashboardId(model.dashboardId);
            this.arn(model.arn);
            this.name(model.name);
            this.version(model.version);
            this.createdTime(model.createdTime);
            this.lastPublishedTime(model.lastPublishedTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.linkEntities(model.linkEntities);
        }

        public final String getDashboardId() {
            return this.dashboardId;
        }

        public final void setDashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
        }

        @Override
        public final Builder dashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final DashboardVersion.Builder getVersion() {
            return this.version != null ? this.version.toBuilder() : null;
        }

        public final void setVersion(DashboardVersion.BuilderImpl version) {
            this.version = version != null ? version.build() : null;
        }

        @Override
        public final Builder version(DashboardVersion version) {
            this.version = version;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastPublishedTime() {
            return this.lastPublishedTime;
        }

        public final void setLastPublishedTime(Instant lastPublishedTime) {
            this.lastPublishedTime = lastPublishedTime;
        }

        @Override
        public final Builder lastPublishedTime(Instant lastPublishedTime) {
            this.lastPublishedTime = lastPublishedTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final Collection<String> getLinkEntities() {
            if (this.linkEntities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.linkEntities;
        }

        public final void setLinkEntities(Collection<String> linkEntities) {
            this.linkEntities = LinkEntityArnListCopier.copy(linkEntities);
        }

        @Override
        public final Builder linkEntities(Collection<String> linkEntities) {
            this.linkEntities = LinkEntityArnListCopier.copy(linkEntities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder linkEntities(String ... linkEntities) {
            this.linkEntities(Arrays.asList(linkEntities));
            return this;
        }

        public Dashboard build() {
            return new Dashboard(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Dashboard> {
        public Builder dashboardId(String var1);

        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder version(DashboardVersion var1);

        default public Builder version(Consumer<DashboardVersion.Builder> version) {
            return this.version((DashboardVersion)((DashboardVersion.Builder)DashboardVersion.builder().applyMutation(version)).build());
        }

        public Builder createdTime(Instant var1);

        public Builder lastPublishedTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder linkEntities(Collection<String> var1);

        public Builder linkEntities(String ... var1);
    }
}

