/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobDataSourceCredentials;
import software.amazon.awssdk.services.quicksight.model.DataSourceParameters;
import software.amazon.awssdk.services.quicksight.model.SslProperties;
import software.amazon.awssdk.services.quicksight.model.VpcConnectionProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssetBundleImportJobDataSourceOverrideParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssetBundleImportJobDataSourceOverrideParameters> {
    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSourceId").getter(AssetBundleImportJobDataSourceOverrideParameters.getter(AssetBundleImportJobDataSourceOverrideParameters::dataSourceId)).setter(AssetBundleImportJobDataSourceOverrideParameters.setter(Builder::dataSourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AssetBundleImportJobDataSourceOverrideParameters.getter(AssetBundleImportJobDataSourceOverrideParameters::name)).setter(AssetBundleImportJobDataSourceOverrideParameters.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<DataSourceParameters> DATA_SOURCE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSourceParameters").getter(AssetBundleImportJobDataSourceOverrideParameters.getter(AssetBundleImportJobDataSourceOverrideParameters::dataSourceParameters)).setter(AssetBundleImportJobDataSourceOverrideParameters.setter(Builder::dataSourceParameters)).constructor(DataSourceParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceParameters").build()}).build();
    private static final SdkField<VpcConnectionProperties> VPC_CONNECTION_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConnectionProperties").getter(AssetBundleImportJobDataSourceOverrideParameters.getter(AssetBundleImportJobDataSourceOverrideParameters::vpcConnectionProperties)).setter(AssetBundleImportJobDataSourceOverrideParameters.setter(Builder::vpcConnectionProperties)).constructor(VpcConnectionProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConnectionProperties").build()}).build();
    private static final SdkField<SslProperties> SSL_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SslProperties").getter(AssetBundleImportJobDataSourceOverrideParameters.getter(AssetBundleImportJobDataSourceOverrideParameters::sslProperties)).setter(AssetBundleImportJobDataSourceOverrideParameters.setter(Builder::sslProperties)).constructor(SslProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslProperties").build()}).build();
    private static final SdkField<AssetBundleImportJobDataSourceCredentials> CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Credentials").getter(AssetBundleImportJobDataSourceOverrideParameters.getter(AssetBundleImportJobDataSourceOverrideParameters::credentials)).setter(AssetBundleImportJobDataSourceOverrideParameters.setter(Builder::credentials)).constructor(AssetBundleImportJobDataSourceCredentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Credentials").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_ID_FIELD, NAME_FIELD, DATA_SOURCE_PARAMETERS_FIELD, VPC_CONNECTION_PROPERTIES_FIELD, SSL_PROPERTIES_FIELD, CREDENTIALS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DataSourceId", DATA_SOURCE_ID_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("DataSourceParameters", DATA_SOURCE_PARAMETERS_FIELD);
            this.put("VpcConnectionProperties", VPC_CONNECTION_PROPERTIES_FIELD);
            this.put("SslProperties", SSL_PROPERTIES_FIELD);
            this.put("Credentials", CREDENTIALS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String dataSourceId;
    private final String name;
    private final DataSourceParameters dataSourceParameters;
    private final VpcConnectionProperties vpcConnectionProperties;
    private final SslProperties sslProperties;
    private final AssetBundleImportJobDataSourceCredentials credentials;

    private AssetBundleImportJobDataSourceOverrideParameters(BuilderImpl builder) {
        this.dataSourceId = builder.dataSourceId;
        this.name = builder.name;
        this.dataSourceParameters = builder.dataSourceParameters;
        this.vpcConnectionProperties = builder.vpcConnectionProperties;
        this.sslProperties = builder.sslProperties;
        this.credentials = builder.credentials;
    }

    public final String dataSourceId() {
        return this.dataSourceId;
    }

    public final String name() {
        return this.name;
    }

    public final DataSourceParameters dataSourceParameters() {
        return this.dataSourceParameters;
    }

    public final VpcConnectionProperties vpcConnectionProperties() {
        return this.vpcConnectionProperties;
    }

    public final SslProperties sslProperties() {
        return this.sslProperties;
    }

    public final AssetBundleImportJobDataSourceCredentials credentials() {
        return this.credentials;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConnectionProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.sslProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentials());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetBundleImportJobDataSourceOverrideParameters)) {
            return false;
        }
        AssetBundleImportJobDataSourceOverrideParameters other = (AssetBundleImportJobDataSourceOverrideParameters)obj;
        return Objects.equals(this.dataSourceId(), other.dataSourceId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.dataSourceParameters(), other.dataSourceParameters()) && Objects.equals(this.vpcConnectionProperties(), other.vpcConnectionProperties()) && Objects.equals(this.sslProperties(), other.sslProperties()) && Objects.equals(this.credentials(), other.credentials());
    }

    public final String toString() {
        return ToString.builder((String)"AssetBundleImportJobDataSourceOverrideParameters").add("DataSourceId", (Object)this.dataSourceId()).add("Name", (Object)this.name()).add("DataSourceParameters", (Object)this.dataSourceParameters()).add("VpcConnectionProperties", (Object)this.vpcConnectionProperties()).add("SslProperties", (Object)this.sslProperties()).add("Credentials", (Object)this.credentials()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSourceId": {
                return Optional.ofNullable(clazz.cast(this.dataSourceId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "DataSourceParameters": {
                return Optional.ofNullable(clazz.cast(this.dataSourceParameters()));
            }
            case "VpcConnectionProperties": {
                return Optional.ofNullable(clazz.cast(this.vpcConnectionProperties()));
            }
            case "SslProperties": {
                return Optional.ofNullable(clazz.cast(this.sslProperties()));
            }
            case "Credentials": {
                return Optional.ofNullable(clazz.cast(this.credentials()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AssetBundleImportJobDataSourceOverrideParameters, T> g) {
        return obj -> g.apply((AssetBundleImportJobDataSourceOverrideParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataSourceId;
        private String name;
        private DataSourceParameters dataSourceParameters;
        private VpcConnectionProperties vpcConnectionProperties;
        private SslProperties sslProperties;
        private AssetBundleImportJobDataSourceCredentials credentials;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetBundleImportJobDataSourceOverrideParameters model) {
            this.dataSourceId(model.dataSourceId);
            this.name(model.name);
            this.dataSourceParameters(model.dataSourceParameters);
            this.vpcConnectionProperties(model.vpcConnectionProperties);
            this.sslProperties(model.sslProperties);
            this.credentials(model.credentials);
        }

        public final String getDataSourceId() {
            return this.dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final DataSourceParameters.Builder getDataSourceParameters() {
            return this.dataSourceParameters != null ? this.dataSourceParameters.toBuilder() : null;
        }

        public final void setDataSourceParameters(DataSourceParameters.BuilderImpl dataSourceParameters) {
            this.dataSourceParameters = dataSourceParameters != null ? dataSourceParameters.build() : null;
        }

        @Override
        public final Builder dataSourceParameters(DataSourceParameters dataSourceParameters) {
            this.dataSourceParameters = dataSourceParameters;
            return this;
        }

        public final VpcConnectionProperties.Builder getVpcConnectionProperties() {
            return this.vpcConnectionProperties != null ? this.vpcConnectionProperties.toBuilder() : null;
        }

        public final void setVpcConnectionProperties(VpcConnectionProperties.BuilderImpl vpcConnectionProperties) {
            this.vpcConnectionProperties = vpcConnectionProperties != null ? vpcConnectionProperties.build() : null;
        }

        @Override
        public final Builder vpcConnectionProperties(VpcConnectionProperties vpcConnectionProperties) {
            this.vpcConnectionProperties = vpcConnectionProperties;
            return this;
        }

        public final SslProperties.Builder getSslProperties() {
            return this.sslProperties != null ? this.sslProperties.toBuilder() : null;
        }

        public final void setSslProperties(SslProperties.BuilderImpl sslProperties) {
            this.sslProperties = sslProperties != null ? sslProperties.build() : null;
        }

        @Override
        public final Builder sslProperties(SslProperties sslProperties) {
            this.sslProperties = sslProperties;
            return this;
        }

        public final AssetBundleImportJobDataSourceCredentials.Builder getCredentials() {
            return this.credentials != null ? this.credentials.toBuilder() : null;
        }

        public final void setCredentials(AssetBundleImportJobDataSourceCredentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public final Builder credentials(AssetBundleImportJobDataSourceCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public AssetBundleImportJobDataSourceOverrideParameters build() {
            return new AssetBundleImportJobDataSourceOverrideParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssetBundleImportJobDataSourceOverrideParameters> {
        public Builder dataSourceId(String var1);

        public Builder name(String var1);

        public Builder dataSourceParameters(DataSourceParameters var1);

        default public Builder dataSourceParameters(Consumer<DataSourceParameters.Builder> dataSourceParameters) {
            return this.dataSourceParameters((DataSourceParameters)((DataSourceParameters.Builder)DataSourceParameters.builder().applyMutation(dataSourceParameters)).build());
        }

        public Builder vpcConnectionProperties(VpcConnectionProperties var1);

        default public Builder vpcConnectionProperties(Consumer<VpcConnectionProperties.Builder> vpcConnectionProperties) {
            return this.vpcConnectionProperties((VpcConnectionProperties)((VpcConnectionProperties.Builder)VpcConnectionProperties.builder().applyMutation(vpcConnectionProperties)).build());
        }

        public Builder sslProperties(SslProperties var1);

        default public Builder sslProperties(Consumer<SslProperties.Builder> sslProperties) {
            return this.sslProperties((SslProperties)((SslProperties.Builder)SslProperties.builder().applyMutation(sslProperties)).build());
        }

        public Builder credentials(AssetBundleImportJobDataSourceCredentials var1);

        default public Builder credentials(Consumer<AssetBundleImportJobDataSourceCredentials.Builder> credentials) {
            return this.credentials((AssetBundleImportJobDataSourceCredentials)((AssetBundleImportJobDataSourceCredentials.Builder)AssetBundleImportJobDataSourceCredentials.builder().applyMutation(credentials)).build());
        }
    }
}

