/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SyncType {
    TEMPLATE_SYNC("TEMPLATE_SYNC"),
    SERVICE_SYNC("SERVICE_SYNC"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SyncType> VALUE_MAP;
    private final String value;

    private SyncType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SyncType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SyncType> knownValues() {
        EnumSet<SyncType> knownValues = EnumSet.allOf(SyncType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SyncType.class, SyncType::toString);
    }
}

