/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.privatenetworks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.privatenetworks.model.Address;
import software.amazon.awssdk.services.privatenetworks.model.CommitmentConfiguration;
import software.amazon.awssdk.services.privatenetworks.model.PrivateNetworksRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActivateNetworkSiteRequest
extends PrivateNetworksRequest
implements ToCopyableBuilder<Builder, ActivateNetworkSiteRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(ActivateNetworkSiteRequest.getter(ActivateNetworkSiteRequest::clientToken)).setter(ActivateNetworkSiteRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()}).build();
    private static final SdkField<CommitmentConfiguration> COMMITMENT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("commitmentConfiguration").getter(ActivateNetworkSiteRequest.getter(ActivateNetworkSiteRequest::commitmentConfiguration)).setter(ActivateNetworkSiteRequest.setter(Builder::commitmentConfiguration)).constructor(CommitmentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitmentConfiguration").build()}).build();
    private static final SdkField<String> NETWORK_SITE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("networkSiteArn").getter(ActivateNetworkSiteRequest.getter(ActivateNetworkSiteRequest::networkSiteArn)).setter(ActivateNetworkSiteRequest.setter(Builder::networkSiteArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkSiteArn").build()}).build();
    private static final SdkField<Address> SHIPPING_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("shippingAddress").getter(ActivateNetworkSiteRequest.getter(ActivateNetworkSiteRequest::shippingAddress)).setter(ActivateNetworkSiteRequest.setter(Builder::shippingAddress)).constructor(Address::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shippingAddress").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, COMMITMENT_CONFIGURATION_FIELD, NETWORK_SITE_ARN_FIELD, SHIPPING_ADDRESS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("clientToken", CLIENT_TOKEN_FIELD);
            this.put("commitmentConfiguration", COMMITMENT_CONFIGURATION_FIELD);
            this.put("networkSiteArn", NETWORK_SITE_ARN_FIELD);
            this.put("shippingAddress", SHIPPING_ADDRESS_FIELD);
        }
    });
    private final String clientToken;
    private final CommitmentConfiguration commitmentConfiguration;
    private final String networkSiteArn;
    private final Address shippingAddress;

    private ActivateNetworkSiteRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.commitmentConfiguration = builder.commitmentConfiguration;
        this.networkSiteArn = builder.networkSiteArn;
        this.shippingAddress = builder.shippingAddress;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final CommitmentConfiguration commitmentConfiguration() {
        return this.commitmentConfiguration;
    }

    public final String networkSiteArn() {
        return this.networkSiteArn;
    }

    public final Address shippingAddress() {
        return this.shippingAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.commitmentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkSiteArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.shippingAddress());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivateNetworkSiteRequest)) {
            return false;
        }
        ActivateNetworkSiteRequest other = (ActivateNetworkSiteRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.commitmentConfiguration(), other.commitmentConfiguration()) && Objects.equals(this.networkSiteArn(), other.networkSiteArn()) && Objects.equals(this.shippingAddress(), other.shippingAddress());
    }

    public final String toString() {
        return ToString.builder((String)"ActivateNetworkSiteRequest").add("ClientToken", (Object)this.clientToken()).add("CommitmentConfiguration", (Object)this.commitmentConfiguration()).add("NetworkSiteArn", (Object)this.networkSiteArn()).add("ShippingAddress", (Object)this.shippingAddress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "commitmentConfiguration": {
                return Optional.ofNullable(clazz.cast(this.commitmentConfiguration()));
            }
            case "networkSiteArn": {
                return Optional.ofNullable(clazz.cast(this.networkSiteArn()));
            }
            case "shippingAddress": {
                return Optional.ofNullable(clazz.cast(this.shippingAddress()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ActivateNetworkSiteRequest, T> g) {
        return obj -> g.apply((ActivateNetworkSiteRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PrivateNetworksRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private CommitmentConfiguration commitmentConfiguration;
        private String networkSiteArn;
        private Address shippingAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(ActivateNetworkSiteRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.commitmentConfiguration(model.commitmentConfiguration);
            this.networkSiteArn(model.networkSiteArn);
            this.shippingAddress(model.shippingAddress);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final CommitmentConfiguration.Builder getCommitmentConfiguration() {
            return this.commitmentConfiguration != null ? this.commitmentConfiguration.toBuilder() : null;
        }

        public final void setCommitmentConfiguration(CommitmentConfiguration.BuilderImpl commitmentConfiguration) {
            this.commitmentConfiguration = commitmentConfiguration != null ? commitmentConfiguration.build() : null;
        }

        @Override
        public final Builder commitmentConfiguration(CommitmentConfiguration commitmentConfiguration) {
            this.commitmentConfiguration = commitmentConfiguration;
            return this;
        }

        public final String getNetworkSiteArn() {
            return this.networkSiteArn;
        }

        public final void setNetworkSiteArn(String networkSiteArn) {
            this.networkSiteArn = networkSiteArn;
        }

        @Override
        public final Builder networkSiteArn(String networkSiteArn) {
            this.networkSiteArn = networkSiteArn;
            return this;
        }

        public final Address.Builder getShippingAddress() {
            return this.shippingAddress != null ? this.shippingAddress.toBuilder() : null;
        }

        public final void setShippingAddress(Address.BuilderImpl shippingAddress) {
            this.shippingAddress = shippingAddress != null ? shippingAddress.build() : null;
        }

        @Override
        public final Builder shippingAddress(Address shippingAddress) {
            this.shippingAddress = shippingAddress;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ActivateNetworkSiteRequest build() {
            return new ActivateNetworkSiteRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PrivateNetworksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ActivateNetworkSiteRequest> {
        public Builder clientToken(String var1);

        public Builder commitmentConfiguration(CommitmentConfiguration var1);

        default public Builder commitmentConfiguration(Consumer<CommitmentConfiguration.Builder> commitmentConfiguration) {
            return this.commitmentConfiguration((CommitmentConfiguration)((CommitmentConfiguration.Builder)CommitmentConfiguration.builder().applyMutation(commitmentConfiguration)).build());
        }

        public Builder networkSiteArn(String var1);

        public Builder shippingAddress(Address var1);

        default public Builder shippingAddress(Consumer<Address.Builder> shippingAddress) {
            return this.shippingAddress((Address)((Address.Builder)Address.builder().applyMutation(shippingAddress)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

