/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pipes.model.MQBrokerAccessCredentials;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PipeSourceActiveMQBrokerParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PipeSourceActiveMQBrokerParameters> {
    private static final SdkField<MQBrokerAccessCredentials> CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Credentials").getter(PipeSourceActiveMQBrokerParameters.getter(PipeSourceActiveMQBrokerParameters::credentials)).setter(PipeSourceActiveMQBrokerParameters.setter(Builder::credentials)).constructor(MQBrokerAccessCredentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Credentials").build()}).build();
    private static final SdkField<String> QUEUE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueueName").getter(PipeSourceActiveMQBrokerParameters.getter(PipeSourceActiveMQBrokerParameters::queueName)).setter(PipeSourceActiveMQBrokerParameters.setter(Builder::queueName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueName").build()}).build();
    private static final SdkField<Integer> BATCH_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BatchSize").getter(PipeSourceActiveMQBrokerParameters.getter(PipeSourceActiveMQBrokerParameters::batchSize)).setter(PipeSourceActiveMQBrokerParameters.setter(Builder::batchSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchSize").build()}).build();
    private static final SdkField<Integer> MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumBatchingWindowInSeconds").getter(PipeSourceActiveMQBrokerParameters.getter(PipeSourceActiveMQBrokerParameters::maximumBatchingWindowInSeconds)).setter(PipeSourceActiveMQBrokerParameters.setter(Builder::maximumBatchingWindowInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumBatchingWindowInSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREDENTIALS_FIELD, QUEUE_NAME_FIELD, BATCH_SIZE_FIELD, MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Credentials", CREDENTIALS_FIELD);
            this.put("QueueName", QUEUE_NAME_FIELD);
            this.put("BatchSize", BATCH_SIZE_FIELD);
            this.put("MaximumBatchingWindowInSeconds", MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final MQBrokerAccessCredentials credentials;
    private final String queueName;
    private final Integer batchSize;
    private final Integer maximumBatchingWindowInSeconds;

    private PipeSourceActiveMQBrokerParameters(BuilderImpl builder) {
        this.credentials = builder.credentials;
        this.queueName = builder.queueName;
        this.batchSize = builder.batchSize;
        this.maximumBatchingWindowInSeconds = builder.maximumBatchingWindowInSeconds;
    }

    public final MQBrokerAccessCredentials credentials() {
        return this.credentials;
    }

    public final String queueName() {
        return this.queueName;
    }

    public final Integer batchSize() {
        return this.batchSize;
    }

    public final Integer maximumBatchingWindowInSeconds() {
        return this.maximumBatchingWindowInSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.credentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueName());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumBatchingWindowInSeconds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipeSourceActiveMQBrokerParameters)) {
            return false;
        }
        PipeSourceActiveMQBrokerParameters other = (PipeSourceActiveMQBrokerParameters)obj;
        return Objects.equals(this.credentials(), other.credentials()) && Objects.equals(this.queueName(), other.queueName()) && Objects.equals(this.batchSize(), other.batchSize()) && Objects.equals(this.maximumBatchingWindowInSeconds(), other.maximumBatchingWindowInSeconds());
    }

    public final String toString() {
        return ToString.builder((String)"PipeSourceActiveMQBrokerParameters").add("Credentials", (Object)this.credentials()).add("QueueName", (Object)(this.queueName() == null ? null : "*** Sensitive Data Redacted ***")).add("BatchSize", (Object)this.batchSize()).add("MaximumBatchingWindowInSeconds", (Object)this.maximumBatchingWindowInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Credentials": {
                return Optional.ofNullable(clazz.cast(this.credentials()));
            }
            case "QueueName": {
                return Optional.ofNullable(clazz.cast(this.queueName()));
            }
            case "BatchSize": {
                return Optional.ofNullable(clazz.cast(this.batchSize()));
            }
            case "MaximumBatchingWindowInSeconds": {
                return Optional.ofNullable(clazz.cast(this.maximumBatchingWindowInSeconds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PipeSourceActiveMQBrokerParameters, T> g) {
        return obj -> g.apply((PipeSourceActiveMQBrokerParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private MQBrokerAccessCredentials credentials;
        private String queueName;
        private Integer batchSize;
        private Integer maximumBatchingWindowInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(PipeSourceActiveMQBrokerParameters model) {
            this.credentials(model.credentials);
            this.queueName(model.queueName);
            this.batchSize(model.batchSize);
            this.maximumBatchingWindowInSeconds(model.maximumBatchingWindowInSeconds);
        }

        public final MQBrokerAccessCredentials.Builder getCredentials() {
            return this.credentials != null ? this.credentials.toBuilder() : null;
        }

        public final void setCredentials(MQBrokerAccessCredentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public final Builder credentials(MQBrokerAccessCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final String getQueueName() {
            return this.queueName;
        }

        public final void setQueueName(String queueName) {
            this.queueName = queueName;
        }

        @Override
        public final Builder queueName(String queueName) {
            this.queueName = queueName;
            return this;
        }

        public final Integer getBatchSize() {
            return this.batchSize;
        }

        public final void setBatchSize(Integer batchSize) {
            this.batchSize = batchSize;
        }

        @Override
        public final Builder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public final Integer getMaximumBatchingWindowInSeconds() {
            return this.maximumBatchingWindowInSeconds;
        }

        public final void setMaximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
        }

        @Override
        public final Builder maximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
            return this;
        }

        public PipeSourceActiveMQBrokerParameters build() {
            return new PipeSourceActiveMQBrokerParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PipeSourceActiveMQBrokerParameters> {
        public Builder credentials(MQBrokerAccessCredentials var1);

        default public Builder credentials(Consumer<MQBrokerAccessCredentials.Builder> credentials) {
            return this.credentials((MQBrokerAccessCredentials)((MQBrokerAccessCredentials.Builder)MQBrokerAccessCredentials.builder().applyMutation(credentials)).build());
        }

        public Builder queueName(String var1);

        public Builder batchSize(Integer var1);

        public Builder maximumBatchingWindowInSeconds(Integer var1);
    }
}

