/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SelectValidation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SelectValidation> {
    private static final SdkField<Integer> MIN_CHOICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinChoices").getter(SelectValidation.getter(SelectValidation::minChoices)).setter(SelectValidation.setter(Builder::minChoices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinChoices").build()}).build();
    private static final SdkField<Integer> MAX_CHOICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxChoices").getter(SelectValidation.getter(SelectValidation::maxChoices)).setter(SelectValidation.setter(Builder::maxChoices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxChoices").build()}).build();
    private static final SdkField<List<String>> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Options").getter(SelectValidation.getter(SelectValidation::options)).setter(SelectValidation.setter(Builder::options)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_CHOICES_FIELD, MAX_CHOICES_FIELD, OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("MinChoices", MIN_CHOICES_FIELD);
            this.put("MaxChoices", MAX_CHOICES_FIELD);
            this.put("Options", OPTIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Integer minChoices;
    private final Integer maxChoices;
    private final List<String> options;

    private SelectValidation(BuilderImpl builder) {
        this.minChoices = builder.minChoices;
        this.maxChoices = builder.maxChoices;
        this.options = builder.options;
    }

    public final Integer minChoices() {
        return this.minChoices;
    }

    public final Integer maxChoices() {
        return this.maxChoices;
    }

    public final boolean hasOptions() {
        return this.options != null && !(this.options instanceof SdkAutoConstructList);
    }

    public final List<String> options() {
        return this.options;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.minChoices());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxChoices());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOptions() ? this.options() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelectValidation)) {
            return false;
        }
        SelectValidation other = (SelectValidation)obj;
        return Objects.equals(this.minChoices(), other.minChoices()) && Objects.equals(this.maxChoices(), other.maxChoices()) && this.hasOptions() == other.hasOptions() && Objects.equals(this.options(), other.options());
    }

    public final String toString() {
        return ToString.builder((String)"SelectValidation").add("MinChoices", (Object)this.minChoices()).add("MaxChoices", (Object)this.maxChoices()).add("Options", this.hasOptions() ? this.options() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MinChoices": {
                return Optional.ofNullable(clazz.cast(this.minChoices()));
            }
            case "MaxChoices": {
                return Optional.ofNullable(clazz.cast(this.maxChoices()));
            }
            case "Options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SelectValidation, T> g) {
        return obj -> g.apply((SelectValidation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer minChoices;
        private Integer maxChoices;
        private List<String> options = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SelectValidation model) {
            this.minChoices(model.minChoices);
            this.maxChoices(model.maxChoices);
            this.options(model.options);
        }

        public final Integer getMinChoices() {
            return this.minChoices;
        }

        public final void setMinChoices(Integer minChoices) {
            this.minChoices = minChoices;
        }

        @Override
        public final Builder minChoices(Integer minChoices) {
            this.minChoices = minChoices;
            return this;
        }

        public final Integer getMaxChoices() {
            return this.maxChoices;
        }

        public final void setMaxChoices(Integer maxChoices) {
            this.maxChoices = maxChoices;
        }

        @Override
        public final Builder maxChoices(Integer maxChoices) {
            this.maxChoices = maxChoices;
            return this;
        }

        public final Collection<String> getOptions() {
            if (this.options instanceof SdkAutoConstructList) {
                return null;
            }
            return this.options;
        }

        public final void setOptions(Collection<String> options) {
            this.options = StringListCopier.copy(options);
        }

        @Override
        public final Builder options(Collection<String> options) {
            this.options = StringListCopier.copy(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(String ... options) {
            this.options(Arrays.asList(options));
            return this;
        }

        public SelectValidation build() {
            return new SelectValidation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SelectValidation> {
        public Builder minChoices(Integer var1);

        public Builder maxChoices(Integer var1);

        public Builder options(Collection<String> var1);

        public Builder options(String ... var1);
    }
}

