/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FieldType {
    SELECT("SELECT"),
    TEXT("TEXT"),
    ATTACHMENT("ATTACHMENT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FieldType> VALUE_MAP;
    private final String value;

    private FieldType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FieldType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FieldType> knownValues() {
        EnumSet<FieldType> knownValues = EnumSet.allOf(FieldType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FieldType.class, FieldType::toString);
    }
}

