/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.GCMChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateGcmChannelRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, UpdateGcmChannelRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(UpdateGcmChannelRequest.getter(UpdateGcmChannelRequest::applicationId)).setter(UpdateGcmChannelRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("application-id").build()}).build();
    private static final SdkField<GCMChannelRequest> GCM_CHANNEL_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GCMChannelRequest").getter(UpdateGcmChannelRequest.getter(UpdateGcmChannelRequest::gcmChannelRequest)).setter(UpdateGcmChannelRequest.setter(Builder::gcmChannelRequest)).constructor(GCMChannelRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GCMChannelRequest").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, GCM_CHANNEL_REQUEST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("application-id", APPLICATION_ID_FIELD);
            this.put("GCMChannelRequest", GCM_CHANNEL_REQUEST_FIELD);
        }
    });
    private final String applicationId;
    private final GCMChannelRequest gcmChannelRequest;

    private UpdateGcmChannelRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.gcmChannelRequest = builder.gcmChannelRequest;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final GCMChannelRequest gcmChannelRequest() {
        return this.gcmChannelRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.gcmChannelRequest());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGcmChannelRequest)) {
            return false;
        }
        UpdateGcmChannelRequest other = (UpdateGcmChannelRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.gcmChannelRequest(), other.gcmChannelRequest());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateGcmChannelRequest").add("ApplicationId", (Object)this.applicationId()).add("GCMChannelRequest", (Object)this.gcmChannelRequest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "GCMChannelRequest": {
                return Optional.ofNullable(clazz.cast(this.gcmChannelRequest()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateGcmChannelRequest, T> g) {
        return obj -> g.apply((UpdateGcmChannelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private GCMChannelRequest gcmChannelRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGcmChannelRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.gcmChannelRequest(model.gcmChannelRequest);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final GCMChannelRequest.Builder getGcmChannelRequest() {
            return this.gcmChannelRequest != null ? this.gcmChannelRequest.toBuilder() : null;
        }

        public final void setGcmChannelRequest(GCMChannelRequest.BuilderImpl gcmChannelRequest) {
            this.gcmChannelRequest = gcmChannelRequest != null ? gcmChannelRequest.build() : null;
        }

        @Override
        public final Builder gcmChannelRequest(GCMChannelRequest gcmChannelRequest) {
            this.gcmChannelRequest = gcmChannelRequest;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGcmChannelRequest build() {
            return new UpdateGcmChannelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateGcmChannelRequest> {
        public Builder applicationId(String var1);

        public Builder gcmChannelRequest(GCMChannelRequest var1);

        default public Builder gcmChannelRequest(Consumer<GCMChannelRequest.Builder> gcmChannelRequest) {
            return this.gcmChannelRequest((GCMChannelRequest)((GCMChannelRequest.Builder)GCMChannelRequest.builder().applyMutation(gcmChannelRequest)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

