/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalizeruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.personalizeruntime.model.ContextCopier;
import software.amazon.awssdk.services.personalizeruntime.model.FilterValuesCopier;
import software.amazon.awssdk.services.personalizeruntime.model.MetadataColumnsCopier;
import software.amazon.awssdk.services.personalizeruntime.model.PersonalizeRuntimeRequest;
import software.amazon.awssdk.services.personalizeruntime.model.Promotion;
import software.amazon.awssdk.services.personalizeruntime.model.PromotionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRecommendationsRequest
extends PersonalizeRuntimeRequest
implements ToCopyableBuilder<Builder, GetRecommendationsRequest> {
    private static final SdkField<String> CAMPAIGN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("campaignArn").getter(GetRecommendationsRequest.getter(GetRecommendationsRequest::campaignArn)).setter(GetRecommendationsRequest.setter(Builder::campaignArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("campaignArn").build()}).build();
    private static final SdkField<String> ITEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("itemId").getter(GetRecommendationsRequest.getter(GetRecommendationsRequest::itemId)).setter(GetRecommendationsRequest.setter(Builder::itemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemId").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userId").getter(GetRecommendationsRequest.getter(GetRecommendationsRequest::userId)).setter(GetRecommendationsRequest.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()}).build();
    private static final SdkField<Integer> NUM_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("numResults").getter(GetRecommendationsRequest.getter(GetRecommendationsRequest::numResults)).setter(GetRecommendationsRequest.setter(Builder::numResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numResults").build()}).build();
    private static final SdkField<Map<String, String>> CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("context").getter(GetRecommendationsRequest.getter(GetRecommendationsRequest::context)).setter(GetRecommendationsRequest.setter(Builder::context)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("context").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> FILTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filterArn").getter(GetRecommendationsRequest.getter(GetRecommendationsRequest::filterArn)).setter(GetRecommendationsRequest.setter(Builder::filterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterArn").build()}).build();
    private static final SdkField<Map<String, String>> FILTER_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("filterValues").getter(GetRecommendationsRequest.getter(GetRecommendationsRequest::filterValues)).setter(GetRecommendationsRequest.setter(Builder::filterValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterValues").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> RECOMMENDER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recommenderArn").getter(GetRecommendationsRequest.getter(GetRecommendationsRequest::recommenderArn)).setter(GetRecommendationsRequest.setter(Builder::recommenderArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommenderArn").build()}).build();
    private static final SdkField<List<Promotion>> PROMOTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("promotions").getter(GetRecommendationsRequest.getter(GetRecommendationsRequest::promotions)).setter(GetRecommendationsRequest.setter(Builder::promotions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promotions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Promotion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, List<String>>> METADATA_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("metadataColumns").getter(GetRecommendationsRequest.getter(GetRecommendationsRequest::metadataColumns)).setter(GetRecommendationsRequest.setter(Builder::metadataColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataColumns").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAMPAIGN_ARN_FIELD, ITEM_ID_FIELD, USER_ID_FIELD, NUM_RESULTS_FIELD, CONTEXT_FIELD, FILTER_ARN_FIELD, FILTER_VALUES_FIELD, RECOMMENDER_ARN_FIELD, PROMOTIONS_FIELD, METADATA_COLUMNS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("campaignArn", CAMPAIGN_ARN_FIELD);
            this.put("itemId", ITEM_ID_FIELD);
            this.put("userId", USER_ID_FIELD);
            this.put("numResults", NUM_RESULTS_FIELD);
            this.put("context", CONTEXT_FIELD);
            this.put("filterArn", FILTER_ARN_FIELD);
            this.put("filterValues", FILTER_VALUES_FIELD);
            this.put("recommenderArn", RECOMMENDER_ARN_FIELD);
            this.put("promotions", PROMOTIONS_FIELD);
            this.put("metadataColumns", METADATA_COLUMNS_FIELD);
        }
    });
    private final String campaignArn;
    private final String itemId;
    private final String userId;
    private final Integer numResults;
    private final Map<String, String> context;
    private final String filterArn;
    private final Map<String, String> filterValues;
    private final String recommenderArn;
    private final List<Promotion> promotions;
    private final Map<String, List<String>> metadataColumns;

    private GetRecommendationsRequest(BuilderImpl builder) {
        super(builder);
        this.campaignArn = builder.campaignArn;
        this.itemId = builder.itemId;
        this.userId = builder.userId;
        this.numResults = builder.numResults;
        this.context = builder.context;
        this.filterArn = builder.filterArn;
        this.filterValues = builder.filterValues;
        this.recommenderArn = builder.recommenderArn;
        this.promotions = builder.promotions;
        this.metadataColumns = builder.metadataColumns;
    }

    public final String campaignArn() {
        return this.campaignArn;
    }

    public final String itemId() {
        return this.itemId;
    }

    public final String userId() {
        return this.userId;
    }

    public final Integer numResults() {
        return this.numResults;
    }

    public final boolean hasContext() {
        return this.context != null && !(this.context instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> context() {
        return this.context;
    }

    public final String filterArn() {
        return this.filterArn;
    }

    public final boolean hasFilterValues() {
        return this.filterValues != null && !(this.filterValues instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> filterValues() {
        return this.filterValues;
    }

    public final String recommenderArn() {
        return this.recommenderArn;
    }

    public final boolean hasPromotions() {
        return this.promotions != null && !(this.promotions instanceof SdkAutoConstructList);
    }

    public final List<Promotion> promotions() {
        return this.promotions;
    }

    public final boolean hasMetadataColumns() {
        return this.metadataColumns != null && !(this.metadataColumns instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> metadataColumns() {
        return this.metadataColumns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.campaignArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.itemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.numResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContext() ? this.context() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.filterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilterValues() ? this.filterValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.recommenderArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPromotions() ? this.promotions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetadataColumns() ? this.metadataColumns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecommendationsRequest)) {
            return false;
        }
        GetRecommendationsRequest other = (GetRecommendationsRequest)((Object)obj);
        return Objects.equals(this.campaignArn(), other.campaignArn()) && Objects.equals(this.itemId(), other.itemId()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.numResults(), other.numResults()) && this.hasContext() == other.hasContext() && Objects.equals(this.context(), other.context()) && Objects.equals(this.filterArn(), other.filterArn()) && this.hasFilterValues() == other.hasFilterValues() && Objects.equals(this.filterValues(), other.filterValues()) && Objects.equals(this.recommenderArn(), other.recommenderArn()) && this.hasPromotions() == other.hasPromotions() && Objects.equals(this.promotions(), other.promotions()) && this.hasMetadataColumns() == other.hasMetadataColumns() && Objects.equals(this.metadataColumns(), other.metadataColumns());
    }

    public final String toString() {
        return ToString.builder((String)"GetRecommendationsRequest").add("CampaignArn", (Object)this.campaignArn()).add("ItemId", (Object)this.itemId()).add("UserId", (Object)this.userId()).add("NumResults", (Object)this.numResults()).add("Context", (Object)(this.context() == null ? null : "*** Sensitive Data Redacted ***")).add("FilterArn", (Object)this.filterArn()).add("FilterValues", (Object)(this.filterValues() == null ? null : "*** Sensitive Data Redacted ***")).add("RecommenderArn", (Object)this.recommenderArn()).add("Promotions", this.hasPromotions() ? this.promotions() : null).add("MetadataColumns", this.hasMetadataColumns() ? this.metadataColumns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "campaignArn": {
                return Optional.ofNullable(clazz.cast(this.campaignArn()));
            }
            case "itemId": {
                return Optional.ofNullable(clazz.cast(this.itemId()));
            }
            case "userId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "numResults": {
                return Optional.ofNullable(clazz.cast(this.numResults()));
            }
            case "context": {
                return Optional.ofNullable(clazz.cast(this.context()));
            }
            case "filterArn": {
                return Optional.ofNullable(clazz.cast(this.filterArn()));
            }
            case "filterValues": {
                return Optional.ofNullable(clazz.cast(this.filterValues()));
            }
            case "recommenderArn": {
                return Optional.ofNullable(clazz.cast(this.recommenderArn()));
            }
            case "promotions": {
                return Optional.ofNullable(clazz.cast(this.promotions()));
            }
            case "metadataColumns": {
                return Optional.ofNullable(clazz.cast(this.metadataColumns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetRecommendationsRequest, T> g) {
        return obj -> g.apply((GetRecommendationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PersonalizeRuntimeRequest.BuilderImpl
    implements Builder {
        private String campaignArn;
        private String itemId;
        private String userId;
        private Integer numResults;
        private Map<String, String> context = DefaultSdkAutoConstructMap.getInstance();
        private String filterArn;
        private Map<String, String> filterValues = DefaultSdkAutoConstructMap.getInstance();
        private String recommenderArn;
        private List<Promotion> promotions = DefaultSdkAutoConstructList.getInstance();
        private Map<String, List<String>> metadataColumns = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecommendationsRequest model) {
            super(model);
            this.campaignArn(model.campaignArn);
            this.itemId(model.itemId);
            this.userId(model.userId);
            this.numResults(model.numResults);
            this.context(model.context);
            this.filterArn(model.filterArn);
            this.filterValues(model.filterValues);
            this.recommenderArn(model.recommenderArn);
            this.promotions(model.promotions);
            this.metadataColumns(model.metadataColumns);
        }

        public final String getCampaignArn() {
            return this.campaignArn;
        }

        public final void setCampaignArn(String campaignArn) {
            this.campaignArn = campaignArn;
        }

        @Override
        public final Builder campaignArn(String campaignArn) {
            this.campaignArn = campaignArn;
            return this;
        }

        public final String getItemId() {
            return this.itemId;
        }

        public final void setItemId(String itemId) {
            this.itemId = itemId;
        }

        @Override
        public final Builder itemId(String itemId) {
            this.itemId = itemId;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final Integer getNumResults() {
            return this.numResults;
        }

        public final void setNumResults(Integer numResults) {
            this.numResults = numResults;
        }

        @Override
        public final Builder numResults(Integer numResults) {
            this.numResults = numResults;
            return this;
        }

        public final Map<String, String> getContext() {
            if (this.context instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.context;
        }

        public final void setContext(Map<String, String> context) {
            this.context = ContextCopier.copy(context);
        }

        @Override
        public final Builder context(Map<String, String> context) {
            this.context = ContextCopier.copy(context);
            return this;
        }

        public final String getFilterArn() {
            return this.filterArn;
        }

        public final void setFilterArn(String filterArn) {
            this.filterArn = filterArn;
        }

        @Override
        public final Builder filterArn(String filterArn) {
            this.filterArn = filterArn;
            return this;
        }

        public final Map<String, String> getFilterValues() {
            if (this.filterValues instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.filterValues;
        }

        public final void setFilterValues(Map<String, String> filterValues) {
            this.filterValues = FilterValuesCopier.copy(filterValues);
        }

        @Override
        public final Builder filterValues(Map<String, String> filterValues) {
            this.filterValues = FilterValuesCopier.copy(filterValues);
            return this;
        }

        public final String getRecommenderArn() {
            return this.recommenderArn;
        }

        public final void setRecommenderArn(String recommenderArn) {
            this.recommenderArn = recommenderArn;
        }

        @Override
        public final Builder recommenderArn(String recommenderArn) {
            this.recommenderArn = recommenderArn;
            return this;
        }

        public final List<Promotion.Builder> getPromotions() {
            List<Promotion.Builder> result = PromotionListCopier.copyToBuilder(this.promotions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPromotions(Collection<Promotion.BuilderImpl> promotions) {
            this.promotions = PromotionListCopier.copyFromBuilder(promotions);
        }

        @Override
        public final Builder promotions(Collection<Promotion> promotions) {
            this.promotions = PromotionListCopier.copy(promotions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder promotions(Promotion ... promotions) {
            this.promotions(Arrays.asList(promotions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder promotions(Consumer<Promotion.Builder> ... promotions) {
            this.promotions(Stream.of(promotions).map(c -> (Promotion)((Promotion.Builder)Promotion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, ? extends Collection<String>> getMetadataColumns() {
            if (this.metadataColumns instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.metadataColumns;
        }

        public final void setMetadataColumns(Map<String, ? extends Collection<String>> metadataColumns) {
            this.metadataColumns = MetadataColumnsCopier.copy(metadataColumns);
        }

        @Override
        public final Builder metadataColumns(Map<String, ? extends Collection<String>> metadataColumns) {
            this.metadataColumns = MetadataColumnsCopier.copy(metadataColumns);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRecommendationsRequest build() {
            return new GetRecommendationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PersonalizeRuntimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRecommendationsRequest> {
        public Builder campaignArn(String var1);

        public Builder itemId(String var1);

        public Builder userId(String var1);

        public Builder numResults(Integer var1);

        public Builder context(Map<String, String> var1);

        public Builder filterArn(String var1);

        public Builder filterValues(Map<String, String> var1);

        public Builder recommenderArn(String var1);

        public Builder promotions(Collection<Promotion> var1);

        public Builder promotions(Promotion ... var1);

        public Builder promotions(Consumer<Promotion.Builder> ... var1);

        public Builder metadataColumns(Map<String, ? extends Collection<String>> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

