/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.personalize.PersonalizeClient;
import software.amazon.awssdk.services.personalize.internal.UserAgentUtils;
import software.amazon.awssdk.services.personalize.model.ListMetricAttributionsRequest;
import software.amazon.awssdk.services.personalize.model.ListMetricAttributionsResponse;
import software.amazon.awssdk.services.personalize.model.MetricAttributionSummary;

public class ListMetricAttributionsIterable
implements SdkIterable<ListMetricAttributionsResponse> {
    private final PersonalizeClient client;
    private final ListMetricAttributionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMetricAttributionsIterable(PersonalizeClient client, ListMetricAttributionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMetricAttributionsResponseFetcher();
    }

    public Iterator<ListMetricAttributionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MetricAttributionSummary> metricAttributions() {
        Function<ListMetricAttributionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.metricAttributions() != null) {
                return response.metricAttributions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMetricAttributionsResponseFetcher
    implements SyncPageFetcher<ListMetricAttributionsResponse> {
        private ListMetricAttributionsResponseFetcher() {
        }

        public boolean hasNextPage(ListMetricAttributionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMetricAttributionsResponse nextPage(ListMetricAttributionsResponse previousPage) {
            if (previousPage == null) {
                return ListMetricAttributionsIterable.this.client.listMetricAttributions(ListMetricAttributionsIterable.this.firstRequest);
            }
            return ListMetricAttributionsIterable.this.client.listMetricAttributions((ListMetricAttributionsRequest)((Object)ListMetricAttributionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

