/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.panorama.PanoramaClient;
import software.amazon.awssdk.services.panorama.internal.UserAgentUtils;
import software.amazon.awssdk.services.panorama.model.ListApplicationInstanceNodeInstancesRequest;
import software.amazon.awssdk.services.panorama.model.ListApplicationInstanceNodeInstancesResponse;

public class ListApplicationInstanceNodeInstancesIterable
implements SdkIterable<ListApplicationInstanceNodeInstancesResponse> {
    private final PanoramaClient client;
    private final ListApplicationInstanceNodeInstancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListApplicationInstanceNodeInstancesIterable(PanoramaClient client, ListApplicationInstanceNodeInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListApplicationInstanceNodeInstancesResponseFetcher();
    }

    public Iterator<ListApplicationInstanceNodeInstancesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListApplicationInstanceNodeInstancesResponseFetcher
    implements SyncPageFetcher<ListApplicationInstanceNodeInstancesResponse> {
        private ListApplicationInstanceNodeInstancesResponseFetcher() {
        }

        public boolean hasNextPage(ListApplicationInstanceNodeInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListApplicationInstanceNodeInstancesResponse nextPage(ListApplicationInstanceNodeInstancesResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationInstanceNodeInstancesIterable.this.client.listApplicationInstanceNodeInstances(ListApplicationInstanceNodeInstancesIterable.this.firstRequest);
            }
            return ListApplicationInstanceNodeInstancesIterable.this.client.listApplicationInstanceNodeInstances((ListApplicationInstanceNodeInstancesRequest)((Object)ListApplicationInstanceNodeInstancesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

