/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.panorama.model.ApplicationInstanceHealthStatus;
import software.amazon.awssdk.services.panorama.model.ApplicationInstanceStatus;
import software.amazon.awssdk.services.panorama.model.ReportedRuntimeContextState;
import software.amazon.awssdk.services.panorama.model.ReportedRuntimeContextStatesCopier;
import software.amazon.awssdk.services.panorama.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationInstance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationInstance> {
    private static final SdkField<String> APPLICATION_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationInstanceId").getter(ApplicationInstance.getter(ApplicationInstance::applicationInstanceId)).setter(ApplicationInstance.setter(Builder::applicationInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationInstanceId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ApplicationInstance.getter(ApplicationInstance::arn)).setter(ApplicationInstance.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(ApplicationInstance.getter(ApplicationInstance::createdTime)).setter(ApplicationInstance.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<String> DEFAULT_RUNTIME_CONTEXT_DEVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultRuntimeContextDevice").getter(ApplicationInstance.getter(ApplicationInstance::defaultRuntimeContextDevice)).setter(ApplicationInstance.setter(Builder::defaultRuntimeContextDevice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRuntimeContextDevice").build()}).build();
    private static final SdkField<String> DEFAULT_RUNTIME_CONTEXT_DEVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultRuntimeContextDeviceName").getter(ApplicationInstance.getter(ApplicationInstance::defaultRuntimeContextDeviceName)).setter(ApplicationInstance.setter(Builder::defaultRuntimeContextDeviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRuntimeContextDeviceName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ApplicationInstance.getter(ApplicationInstance::description)).setter(ApplicationInstance.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> HEALTH_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HealthStatus").getter(ApplicationInstance.getter(ApplicationInstance::healthStatusAsString)).setter(ApplicationInstance.setter(Builder::healthStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthStatus").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ApplicationInstance.getter(ApplicationInstance::name)).setter(ApplicationInstance.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<ReportedRuntimeContextState>> RUNTIME_CONTEXT_STATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RuntimeContextStates").getter(ApplicationInstance.getter(ApplicationInstance::runtimeContextStates)).setter(ApplicationInstance.setter(Builder::runtimeContextStates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeContextStates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReportedRuntimeContextState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ApplicationInstance.getter(ApplicationInstance::statusAsString)).setter(ApplicationInstance.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusDescription").getter(ApplicationInstance.getter(ApplicationInstance::statusDescription)).setter(ApplicationInstance.setter(Builder::statusDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusDescription").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(ApplicationInstance.getter(ApplicationInstance::tags)).setter(ApplicationInstance.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_INSTANCE_ID_FIELD, ARN_FIELD, CREATED_TIME_FIELD, DEFAULT_RUNTIME_CONTEXT_DEVICE_FIELD, DEFAULT_RUNTIME_CONTEXT_DEVICE_NAME_FIELD, DESCRIPTION_FIELD, HEALTH_STATUS_FIELD, NAME_FIELD, RUNTIME_CONTEXT_STATES_FIELD, STATUS_FIELD, STATUS_DESCRIPTION_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ApplicationInstanceId", APPLICATION_INSTANCE_ID_FIELD);
            this.put("Arn", ARN_FIELD);
            this.put("CreatedTime", CREATED_TIME_FIELD);
            this.put("DefaultRuntimeContextDevice", DEFAULT_RUNTIME_CONTEXT_DEVICE_FIELD);
            this.put("DefaultRuntimeContextDeviceName", DEFAULT_RUNTIME_CONTEXT_DEVICE_NAME_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("HealthStatus", HEALTH_STATUS_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("RuntimeContextStates", RUNTIME_CONTEXT_STATES_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("StatusDescription", STATUS_DESCRIPTION_FIELD);
            this.put("Tags", TAGS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String applicationInstanceId;
    private final String arn;
    private final Instant createdTime;
    private final String defaultRuntimeContextDevice;
    private final String defaultRuntimeContextDeviceName;
    private final String description;
    private final String healthStatus;
    private final String name;
    private final List<ReportedRuntimeContextState> runtimeContextStates;
    private final String status;
    private final String statusDescription;
    private final Map<String, String> tags;

    private ApplicationInstance(BuilderImpl builder) {
        this.applicationInstanceId = builder.applicationInstanceId;
        this.arn = builder.arn;
        this.createdTime = builder.createdTime;
        this.defaultRuntimeContextDevice = builder.defaultRuntimeContextDevice;
        this.defaultRuntimeContextDeviceName = builder.defaultRuntimeContextDeviceName;
        this.description = builder.description;
        this.healthStatus = builder.healthStatus;
        this.name = builder.name;
        this.runtimeContextStates = builder.runtimeContextStates;
        this.status = builder.status;
        this.statusDescription = builder.statusDescription;
        this.tags = builder.tags;
    }

    public final String applicationInstanceId() {
        return this.applicationInstanceId;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final String defaultRuntimeContextDevice() {
        return this.defaultRuntimeContextDevice;
    }

    public final String defaultRuntimeContextDeviceName() {
        return this.defaultRuntimeContextDeviceName;
    }

    public final String description() {
        return this.description;
    }

    public final ApplicationInstanceHealthStatus healthStatus() {
        return ApplicationInstanceHealthStatus.fromValue(this.healthStatus);
    }

    public final String healthStatusAsString() {
        return this.healthStatus;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasRuntimeContextStates() {
        return this.runtimeContextStates != null && !(this.runtimeContextStates instanceof SdkAutoConstructList);
    }

    public final List<ReportedRuntimeContextState> runtimeContextStates() {
        return this.runtimeContextStates;
    }

    public final ApplicationInstanceStatus status() {
        return ApplicationInstanceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusDescription() {
        return this.statusDescription;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultRuntimeContextDevice());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultRuntimeContextDeviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuntimeContextStates() ? this.runtimeContextStates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationInstance)) {
            return false;
        }
        ApplicationInstance other = (ApplicationInstance)obj;
        return Objects.equals(this.applicationInstanceId(), other.applicationInstanceId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.defaultRuntimeContextDevice(), other.defaultRuntimeContextDevice()) && Objects.equals(this.defaultRuntimeContextDeviceName(), other.defaultRuntimeContextDeviceName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.healthStatusAsString(), other.healthStatusAsString()) && Objects.equals(this.name(), other.name()) && this.hasRuntimeContextStates() == other.hasRuntimeContextStates() && Objects.equals(this.runtimeContextStates(), other.runtimeContextStates()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusDescription(), other.statusDescription()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"ApplicationInstance").add("ApplicationInstanceId", (Object)this.applicationInstanceId()).add("Arn", (Object)this.arn()).add("CreatedTime", (Object)this.createdTime()).add("DefaultRuntimeContextDevice", (Object)this.defaultRuntimeContextDevice()).add("DefaultRuntimeContextDeviceName", (Object)this.defaultRuntimeContextDeviceName()).add("Description", (Object)this.description()).add("HealthStatus", (Object)this.healthStatusAsString()).add("Name", (Object)this.name()).add("RuntimeContextStates", this.hasRuntimeContextStates() ? this.runtimeContextStates() : null).add("Status", (Object)this.statusAsString()).add("StatusDescription", (Object)this.statusDescription()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationInstanceId": {
                return Optional.ofNullable(clazz.cast(this.applicationInstanceId()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "DefaultRuntimeContextDevice": {
                return Optional.ofNullable(clazz.cast(this.defaultRuntimeContextDevice()));
            }
            case "DefaultRuntimeContextDeviceName": {
                return Optional.ofNullable(clazz.cast(this.defaultRuntimeContextDeviceName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "HealthStatus": {
                return Optional.ofNullable(clazz.cast(this.healthStatusAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RuntimeContextStates": {
                return Optional.ofNullable(clazz.cast(this.runtimeContextStates()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusDescription": {
                return Optional.ofNullable(clazz.cast(this.statusDescription()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationInstance, T> g) {
        return obj -> g.apply((ApplicationInstance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationInstanceId;
        private String arn;
        private Instant createdTime;
        private String defaultRuntimeContextDevice;
        private String defaultRuntimeContextDeviceName;
        private String description;
        private String healthStatus;
        private String name;
        private List<ReportedRuntimeContextState> runtimeContextStates = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private String statusDescription;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationInstance model) {
            this.applicationInstanceId(model.applicationInstanceId);
            this.arn(model.arn);
            this.createdTime(model.createdTime);
            this.defaultRuntimeContextDevice(model.defaultRuntimeContextDevice);
            this.defaultRuntimeContextDeviceName(model.defaultRuntimeContextDeviceName);
            this.description(model.description);
            this.healthStatus(model.healthStatus);
            this.name(model.name);
            this.runtimeContextStates(model.runtimeContextStates);
            this.status(model.status);
            this.statusDescription(model.statusDescription);
            this.tags(model.tags);
        }

        public final String getApplicationInstanceId() {
            return this.applicationInstanceId;
        }

        public final void setApplicationInstanceId(String applicationInstanceId) {
            this.applicationInstanceId = applicationInstanceId;
        }

        @Override
        public final Builder applicationInstanceId(String applicationInstanceId) {
            this.applicationInstanceId = applicationInstanceId;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getDefaultRuntimeContextDevice() {
            return this.defaultRuntimeContextDevice;
        }

        public final void setDefaultRuntimeContextDevice(String defaultRuntimeContextDevice) {
            this.defaultRuntimeContextDevice = defaultRuntimeContextDevice;
        }

        @Override
        public final Builder defaultRuntimeContextDevice(String defaultRuntimeContextDevice) {
            this.defaultRuntimeContextDevice = defaultRuntimeContextDevice;
            return this;
        }

        public final String getDefaultRuntimeContextDeviceName() {
            return this.defaultRuntimeContextDeviceName;
        }

        public final void setDefaultRuntimeContextDeviceName(String defaultRuntimeContextDeviceName) {
            this.defaultRuntimeContextDeviceName = defaultRuntimeContextDeviceName;
        }

        @Override
        public final Builder defaultRuntimeContextDeviceName(String defaultRuntimeContextDeviceName) {
            this.defaultRuntimeContextDeviceName = defaultRuntimeContextDeviceName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getHealthStatus() {
            return this.healthStatus;
        }

        public final void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        @Override
        public final Builder healthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        @Override
        public final Builder healthStatus(ApplicationInstanceHealthStatus healthStatus) {
            this.healthStatus(healthStatus == null ? null : healthStatus.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<ReportedRuntimeContextState.Builder> getRuntimeContextStates() {
            List<ReportedRuntimeContextState.Builder> result = ReportedRuntimeContextStatesCopier.copyToBuilder(this.runtimeContextStates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuntimeContextStates(Collection<ReportedRuntimeContextState.BuilderImpl> runtimeContextStates) {
            this.runtimeContextStates = ReportedRuntimeContextStatesCopier.copyFromBuilder(runtimeContextStates);
        }

        @Override
        public final Builder runtimeContextStates(Collection<ReportedRuntimeContextState> runtimeContextStates) {
            this.runtimeContextStates = ReportedRuntimeContextStatesCopier.copy(runtimeContextStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runtimeContextStates(ReportedRuntimeContextState ... runtimeContextStates) {
            this.runtimeContextStates(Arrays.asList(runtimeContextStates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runtimeContextStates(Consumer<ReportedRuntimeContextState.Builder> ... runtimeContextStates) {
            this.runtimeContextStates(Stream.of(runtimeContextStates).map(c -> (ReportedRuntimeContextState)((ReportedRuntimeContextState.Builder)ReportedRuntimeContextState.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ApplicationInstanceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusDescription() {
            return this.statusDescription;
        }

        public final void setStatusDescription(String statusDescription) {
            this.statusDescription = statusDescription;
        }

        @Override
        public final Builder statusDescription(String statusDescription) {
            this.statusDescription = statusDescription;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public ApplicationInstance build() {
            return new ApplicationInstance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationInstance> {
        public Builder applicationInstanceId(String var1);

        public Builder arn(String var1);

        public Builder createdTime(Instant var1);

        public Builder defaultRuntimeContextDevice(String var1);

        public Builder defaultRuntimeContextDeviceName(String var1);

        public Builder description(String var1);

        public Builder healthStatus(String var1);

        public Builder healthStatus(ApplicationInstanceHealthStatus var1);

        public Builder name(String var1);

        public Builder runtimeContextStates(Collection<ReportedRuntimeContextState> var1);

        public Builder runtimeContextStates(ReportedRuntimeContextState ... var1);

        public Builder runtimeContextStates(Consumer<ReportedRuntimeContextState.Builder> ... var1);

        public Builder status(String var1);

        public Builder status(ApplicationInstanceStatus var1);

        public Builder statusDescription(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

