/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.osis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.osis.model.OsisRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPipelineBlueprintRequest
extends OsisRequest
implements ToCopyableBuilder<Builder, GetPipelineBlueprintRequest> {
    private static final SdkField<String> BLUEPRINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BlueprintName").getter(GetPipelineBlueprintRequest.getter(GetPipelineBlueprintRequest::blueprintName)).setter(GetPipelineBlueprintRequest.setter(Builder::blueprintName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("BlueprintName").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Format").getter(GetPipelineBlueprintRequest.getter(GetPipelineBlueprintRequest::format)).setter(GetPipelineBlueprintRequest.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("format").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLUEPRINT_NAME_FIELD, FORMAT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("BlueprintName", BLUEPRINT_NAME_FIELD);
            this.put("format", FORMAT_FIELD);
        }
    });
    private final String blueprintName;
    private final String format;

    private GetPipelineBlueprintRequest(BuilderImpl builder) {
        super(builder);
        this.blueprintName = builder.blueprintName;
        this.format = builder.format;
    }

    public final String blueprintName() {
        return this.blueprintName;
    }

    public final String format() {
        return this.format;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.blueprintName());
        hashCode = 31 * hashCode + Objects.hashCode(this.format());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPipelineBlueprintRequest)) {
            return false;
        }
        GetPipelineBlueprintRequest other = (GetPipelineBlueprintRequest)((Object)obj);
        return Objects.equals(this.blueprintName(), other.blueprintName()) && Objects.equals(this.format(), other.format());
    }

    public final String toString() {
        return ToString.builder((String)"GetPipelineBlueprintRequest").add("BlueprintName", (Object)this.blueprintName()).add("Format", (Object)this.format()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BlueprintName": {
                return Optional.ofNullable(clazz.cast(this.blueprintName()));
            }
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.format()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetPipelineBlueprintRequest, T> g) {
        return obj -> g.apply((GetPipelineBlueprintRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OsisRequest.BuilderImpl
    implements Builder {
        private String blueprintName;
        private String format;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPipelineBlueprintRequest model) {
            super(model);
            this.blueprintName(model.blueprintName);
            this.format(model.format);
        }

        public final String getBlueprintName() {
            return this.blueprintName;
        }

        public final void setBlueprintName(String blueprintName) {
            this.blueprintName = blueprintName;
        }

        @Override
        public final Builder blueprintName(String blueprintName) {
            this.blueprintName = blueprintName;
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetPipelineBlueprintRequest build() {
            return new GetPipelineBlueprintRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OsisRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPipelineBlueprintRequest> {
        public Builder blueprintName(String var1);

        public Builder format(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

