/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearchserverless.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.opensearchserverless.OpenSearchServerlessClient;
import software.amazon.awssdk.services.opensearchserverless.internal.UserAgentUtils;
import software.amazon.awssdk.services.opensearchserverless.model.ListLifecyclePoliciesRequest;
import software.amazon.awssdk.services.opensearchserverless.model.ListLifecyclePoliciesResponse;

public class ListLifecyclePoliciesIterable
implements SdkIterable<ListLifecyclePoliciesResponse> {
    private final OpenSearchServerlessClient client;
    private final ListLifecyclePoliciesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLifecyclePoliciesIterable(OpenSearchServerlessClient client, ListLifecyclePoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListLifecyclePoliciesResponseFetcher();
    }

    public Iterator<ListLifecyclePoliciesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListLifecyclePoliciesResponseFetcher
    implements SyncPageFetcher<ListLifecyclePoliciesResponse> {
        private ListLifecyclePoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListLifecyclePoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLifecyclePoliciesResponse nextPage(ListLifecyclePoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListLifecyclePoliciesIterable.this.client.listLifecyclePolicies(ListLifecyclePoliciesIterable.this.firstRequest);
            }
            return ListLifecyclePoliciesIterable.this.client.listLifecyclePolicies((ListLifecyclePoliciesRequest)((Object)ListLifecyclePoliciesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

