/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearchserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opensearchserverless.model.OpenSearchServerlessResponse;
import software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointSummariesCopier;
import software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListVpcEndpointsResponse
extends OpenSearchServerlessResponse
implements ToCopyableBuilder<Builder, ListVpcEndpointsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListVpcEndpointsResponse.getter(ListVpcEndpointsResponse::nextToken)).setter(ListVpcEndpointsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<VpcEndpointSummary>> VPC_ENDPOINT_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("vpcEndpointSummaries").getter(ListVpcEndpointsResponse.getter(ListVpcEndpointsResponse::vpcEndpointSummaries)).setter(ListVpcEndpointsResponse.setter(Builder::vpcEndpointSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcEndpointSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpcEndpointSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, VPC_ENDPOINT_SUMMARIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("vpcEndpointSummaries", VPC_ENDPOINT_SUMMARIES_FIELD);
        }
    });
    private final String nextToken;
    private final List<VpcEndpointSummary> vpcEndpointSummaries;

    private ListVpcEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.vpcEndpointSummaries = builder.vpcEndpointSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasVpcEndpointSummaries() {
        return this.vpcEndpointSummaries != null && !(this.vpcEndpointSummaries instanceof SdkAutoConstructList);
    }

    public final List<VpcEndpointSummary> vpcEndpointSummaries() {
        return this.vpcEndpointSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcEndpointSummaries() ? this.vpcEndpointSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVpcEndpointsResponse)) {
            return false;
        }
        ListVpcEndpointsResponse other = (ListVpcEndpointsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasVpcEndpointSummaries() == other.hasVpcEndpointSummaries() && Objects.equals(this.vpcEndpointSummaries(), other.vpcEndpointSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListVpcEndpointsResponse").add("NextToken", (Object)this.nextToken()).add("VpcEndpointSummaries", this.hasVpcEndpointSummaries() ? this.vpcEndpointSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "vpcEndpointSummaries": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListVpcEndpointsResponse, T> g) {
        return obj -> g.apply((ListVpcEndpointsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchServerlessResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<VpcEndpointSummary> vpcEndpointSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListVpcEndpointsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.vpcEndpointSummaries(model.vpcEndpointSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<VpcEndpointSummary.Builder> getVpcEndpointSummaries() {
            List<VpcEndpointSummary.Builder> result = VpcEndpointSummariesCopier.copyToBuilder(this.vpcEndpointSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcEndpointSummaries(Collection<VpcEndpointSummary.BuilderImpl> vpcEndpointSummaries) {
            this.vpcEndpointSummaries = VpcEndpointSummariesCopier.copyFromBuilder(vpcEndpointSummaries);
        }

        @Override
        public final Builder vpcEndpointSummaries(Collection<VpcEndpointSummary> vpcEndpointSummaries) {
            this.vpcEndpointSummaries = VpcEndpointSummariesCopier.copy(vpcEndpointSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpointSummaries(VpcEndpointSummary ... vpcEndpointSummaries) {
            this.vpcEndpointSummaries(Arrays.asList(vpcEndpointSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpointSummaries(Consumer<VpcEndpointSummary.Builder> ... vpcEndpointSummaries) {
            this.vpcEndpointSummaries(Stream.of(vpcEndpointSummaries).map(c -> (VpcEndpointSummary)((VpcEndpointSummary.Builder)VpcEndpointSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListVpcEndpointsResponse build() {
            return new ListVpcEndpointsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OpenSearchServerlessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListVpcEndpointsResponse> {
        public Builder nextToken(String var1);

        public Builder vpcEndpointSummaries(Collection<VpcEndpointSummary> var1);

        public Builder vpcEndpointSummaries(VpcEndpointSummary ... var1);

        public Builder vpcEndpointSummaries(Consumer<VpcEndpointSummary.Builder> ... var1);
    }
}

