/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.omics.model.ETagAlgorithmFamily;
import software.amazon.awssdk.services.omics.model.SseConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SequenceStoreDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SequenceStoreDetail> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(SequenceStoreDetail.getter(SequenceStoreDetail::arn)).setter(SequenceStoreDetail.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(SequenceStoreDetail.getter(SequenceStoreDetail::id)).setter(SequenceStoreDetail.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(SequenceStoreDetail.getter(SequenceStoreDetail::name)).setter(SequenceStoreDetail.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(SequenceStoreDetail.getter(SequenceStoreDetail::description)).setter(SequenceStoreDetail.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<SseConfig> SSE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sseConfig").getter(SequenceStoreDetail.getter(SequenceStoreDetail::sseConfig)).setter(SequenceStoreDetail.setter(Builder::sseConfig)).constructor(SseConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sseConfig").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(SequenceStoreDetail.getter(SequenceStoreDetail::creationTime)).setter(SequenceStoreDetail.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> FALLBACK_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fallbackLocation").getter(SequenceStoreDetail.getter(SequenceStoreDetail::fallbackLocation)).setter(SequenceStoreDetail.setter(Builder::fallbackLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fallbackLocation").build()}).build();
    private static final SdkField<String> E_TAG_ALGORITHM_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eTagAlgorithmFamily").getter(SequenceStoreDetail.getter(SequenceStoreDetail::eTagAlgorithmFamilyAsString)).setter(SequenceStoreDetail.setter(Builder::eTagAlgorithmFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eTagAlgorithmFamily").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, SSE_CONFIG_FIELD, CREATION_TIME_FIELD, FALLBACK_LOCATION_FIELD, E_TAG_ALGORITHM_FAMILY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("arn", ARN_FIELD);
            this.put("id", ID_FIELD);
            this.put("name", NAME_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("sseConfig", SSE_CONFIG_FIELD);
            this.put("creationTime", CREATION_TIME_FIELD);
            this.put("fallbackLocation", FALLBACK_LOCATION_FIELD);
            this.put("eTagAlgorithmFamily", E_TAG_ALGORITHM_FAMILY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String id;
    private final String name;
    private final String description;
    private final SseConfig sseConfig;
    private final Instant creationTime;
    private final String fallbackLocation;
    private final String eTagAlgorithmFamily;

    private SequenceStoreDetail(BuilderImpl builder) {
        this.arn = builder.arn;
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.sseConfig = builder.sseConfig;
        this.creationTime = builder.creationTime;
        this.fallbackLocation = builder.fallbackLocation;
        this.eTagAlgorithmFamily = builder.eTagAlgorithmFamily;
    }

    public final String arn() {
        return this.arn;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final SseConfig sseConfig() {
        return this.sseConfig;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String fallbackLocation() {
        return this.fallbackLocation;
    }

    public final ETagAlgorithmFamily eTagAlgorithmFamily() {
        return ETagAlgorithmFamily.fromValue(this.eTagAlgorithmFamily);
    }

    public final String eTagAlgorithmFamilyAsString() {
        return this.eTagAlgorithmFamily;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.fallbackLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTagAlgorithmFamilyAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SequenceStoreDetail)) {
            return false;
        }
        SequenceStoreDetail other = (SequenceStoreDetail)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.sseConfig(), other.sseConfig()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.fallbackLocation(), other.fallbackLocation()) && Objects.equals(this.eTagAlgorithmFamilyAsString(), other.eTagAlgorithmFamilyAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SequenceStoreDetail").add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("SseConfig", (Object)this.sseConfig()).add("CreationTime", (Object)this.creationTime()).add("FallbackLocation", (Object)this.fallbackLocation()).add("ETagAlgorithmFamily", (Object)this.eTagAlgorithmFamilyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "sseConfig": {
                return Optional.ofNullable(clazz.cast(this.sseConfig()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "fallbackLocation": {
                return Optional.ofNullable(clazz.cast(this.fallbackLocation()));
            }
            case "eTagAlgorithmFamily": {
                return Optional.ofNullable(clazz.cast(this.eTagAlgorithmFamilyAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SequenceStoreDetail, T> g) {
        return obj -> g.apply((SequenceStoreDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String id;
        private String name;
        private String description;
        private SseConfig sseConfig;
        private Instant creationTime;
        private String fallbackLocation;
        private String eTagAlgorithmFamily;

        private BuilderImpl() {
        }

        private BuilderImpl(SequenceStoreDetail model) {
            this.arn(model.arn);
            this.id(model.id);
            this.name(model.name);
            this.description(model.description);
            this.sseConfig(model.sseConfig);
            this.creationTime(model.creationTime);
            this.fallbackLocation(model.fallbackLocation);
            this.eTagAlgorithmFamily(model.eTagAlgorithmFamily);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final SseConfig.Builder getSseConfig() {
            return this.sseConfig != null ? this.sseConfig.toBuilder() : null;
        }

        public final void setSseConfig(SseConfig.BuilderImpl sseConfig) {
            this.sseConfig = sseConfig != null ? sseConfig.build() : null;
        }

        @Override
        public final Builder sseConfig(SseConfig sseConfig) {
            this.sseConfig = sseConfig;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getFallbackLocation() {
            return this.fallbackLocation;
        }

        public final void setFallbackLocation(String fallbackLocation) {
            this.fallbackLocation = fallbackLocation;
        }

        @Override
        public final Builder fallbackLocation(String fallbackLocation) {
            this.fallbackLocation = fallbackLocation;
            return this;
        }

        public final String getETagAlgorithmFamily() {
            return this.eTagAlgorithmFamily;
        }

        public final void setETagAlgorithmFamily(String eTagAlgorithmFamily) {
            this.eTagAlgorithmFamily = eTagAlgorithmFamily;
        }

        @Override
        public final Builder eTagAlgorithmFamily(String eTagAlgorithmFamily) {
            this.eTagAlgorithmFamily = eTagAlgorithmFamily;
            return this;
        }

        @Override
        public final Builder eTagAlgorithmFamily(ETagAlgorithmFamily eTagAlgorithmFamily) {
            this.eTagAlgorithmFamily(eTagAlgorithmFamily == null ? null : eTagAlgorithmFamily.toString());
            return this;
        }

        public SequenceStoreDetail build() {
            return new SequenceStoreDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SequenceStoreDetail> {
        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder sseConfig(SseConfig var1);

        default public Builder sseConfig(Consumer<SseConfig.Builder> sseConfig) {
            return this.sseConfig((SseConfig)((SseConfig.Builder)SseConfig.builder().applyMutation(sseConfig)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder fallbackLocation(String var1);

        public Builder eTagAlgorithmFamily(String var1);

        public Builder eTagAlgorithmFamily(ETagAlgorithmFamily var1);
    }
}

