/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.ChangeSetState;
import software.amazon.awssdk.services.networkmanager.model.CoreNetworkPolicyAlias;
import software.amazon.awssdk.services.networkmanager.model.CoreNetworkPolicyError;
import software.amazon.awssdk.services.networkmanager.model.CoreNetworkPolicyErrorListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CoreNetworkPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CoreNetworkPolicy> {
    private static final SdkField<String> CORE_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CoreNetworkId").getter(CoreNetworkPolicy.getter(CoreNetworkPolicy::coreNetworkId)).setter(CoreNetworkPolicy.setter(Builder::coreNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkId").build()}).build();
    private static final SdkField<Integer> POLICY_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PolicyVersionId").getter(CoreNetworkPolicy.getter(CoreNetworkPolicy::policyVersionId)).setter(CoreNetworkPolicy.setter(Builder::policyVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyVersionId").build()}).build();
    private static final SdkField<String> ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Alias").getter(CoreNetworkPolicy.getter(CoreNetworkPolicy::aliasAsString)).setter(CoreNetworkPolicy.setter(Builder::alias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CoreNetworkPolicy.getter(CoreNetworkPolicy::description)).setter(CoreNetworkPolicy.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(CoreNetworkPolicy.getter(CoreNetworkPolicy::createdAt)).setter(CoreNetworkPolicy.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<String> CHANGE_SET_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChangeSetState").getter(CoreNetworkPolicy.getter(CoreNetworkPolicy::changeSetStateAsString)).setter(CoreNetworkPolicy.setter(Builder::changeSetState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeSetState").build()}).build();
    private static final SdkField<List<CoreNetworkPolicyError>> POLICY_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PolicyErrors").getter(CoreNetworkPolicy.getter(CoreNetworkPolicy::policyErrors)).setter(CoreNetworkPolicy.setter(Builder::policyErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyErrors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CoreNetworkPolicyError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyDocument").getter(CoreNetworkPolicy.getter(CoreNetworkPolicy::policyDocument)).setter(CoreNetworkPolicy.setter(Builder::policyDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDocument").build(), JsonValueTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_NETWORK_ID_FIELD, POLICY_VERSION_ID_FIELD, ALIAS_FIELD, DESCRIPTION_FIELD, CREATED_AT_FIELD, CHANGE_SET_STATE_FIELD, POLICY_ERRORS_FIELD, POLICY_DOCUMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CoreNetworkId", CORE_NETWORK_ID_FIELD);
            this.put("PolicyVersionId", POLICY_VERSION_ID_FIELD);
            this.put("Alias", ALIAS_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("CreatedAt", CREATED_AT_FIELD);
            this.put("ChangeSetState", CHANGE_SET_STATE_FIELD);
            this.put("PolicyErrors", POLICY_ERRORS_FIELD);
            this.put("PolicyDocument", POLICY_DOCUMENT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String coreNetworkId;
    private final Integer policyVersionId;
    private final String alias;
    private final String description;
    private final Instant createdAt;
    private final String changeSetState;
    private final List<CoreNetworkPolicyError> policyErrors;
    private final String policyDocument;

    private CoreNetworkPolicy(BuilderImpl builder) {
        this.coreNetworkId = builder.coreNetworkId;
        this.policyVersionId = builder.policyVersionId;
        this.alias = builder.alias;
        this.description = builder.description;
        this.createdAt = builder.createdAt;
        this.changeSetState = builder.changeSetState;
        this.policyErrors = builder.policyErrors;
        this.policyDocument = builder.policyDocument;
    }

    public final String coreNetworkId() {
        return this.coreNetworkId;
    }

    public final Integer policyVersionId() {
        return this.policyVersionId;
    }

    public final CoreNetworkPolicyAlias alias() {
        return CoreNetworkPolicyAlias.fromValue(this.alias);
    }

    public final String aliasAsString() {
        return this.alias;
    }

    public final String description() {
        return this.description;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final ChangeSetState changeSetState() {
        return ChangeSetState.fromValue(this.changeSetState);
    }

    public final String changeSetStateAsString() {
        return this.changeSetState;
    }

    public final boolean hasPolicyErrors() {
        return this.policyErrors != null && !(this.policyErrors instanceof SdkAutoConstructList);
    }

    public final List<CoreNetworkPolicyError> policyErrors() {
        return this.policyErrors;
    }

    public final String policyDocument() {
        return this.policyDocument;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.coreNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.aliasAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeSetStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicyErrors() ? this.policyErrors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDocument());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoreNetworkPolicy)) {
            return false;
        }
        CoreNetworkPolicy other = (CoreNetworkPolicy)obj;
        return Objects.equals(this.coreNetworkId(), other.coreNetworkId()) && Objects.equals(this.policyVersionId(), other.policyVersionId()) && Objects.equals(this.aliasAsString(), other.aliasAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.changeSetStateAsString(), other.changeSetStateAsString()) && this.hasPolicyErrors() == other.hasPolicyErrors() && Objects.equals(this.policyErrors(), other.policyErrors()) && Objects.equals(this.policyDocument(), other.policyDocument());
    }

    public final String toString() {
        return ToString.builder((String)"CoreNetworkPolicy").add("CoreNetworkId", (Object)this.coreNetworkId()).add("PolicyVersionId", (Object)this.policyVersionId()).add("Alias", (Object)this.aliasAsString()).add("Description", (Object)this.description()).add("CreatedAt", (Object)this.createdAt()).add("ChangeSetState", (Object)this.changeSetStateAsString()).add("PolicyErrors", this.hasPolicyErrors() ? this.policyErrors() : null).add("PolicyDocument", (Object)this.policyDocument()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CoreNetworkId": {
                return Optional.ofNullable(clazz.cast(this.coreNetworkId()));
            }
            case "PolicyVersionId": {
                return Optional.ofNullable(clazz.cast(this.policyVersionId()));
            }
            case "Alias": {
                return Optional.ofNullable(clazz.cast(this.aliasAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "ChangeSetState": {
                return Optional.ofNullable(clazz.cast(this.changeSetStateAsString()));
            }
            case "PolicyErrors": {
                return Optional.ofNullable(clazz.cast(this.policyErrors()));
            }
            case "PolicyDocument": {
                return Optional.ofNullable(clazz.cast(this.policyDocument()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CoreNetworkPolicy, T> g) {
        return obj -> g.apply((CoreNetworkPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String coreNetworkId;
        private Integer policyVersionId;
        private String alias;
        private String description;
        private Instant createdAt;
        private String changeSetState;
        private List<CoreNetworkPolicyError> policyErrors = DefaultSdkAutoConstructList.getInstance();
        private String policyDocument;

        private BuilderImpl() {
        }

        private BuilderImpl(CoreNetworkPolicy model) {
            this.coreNetworkId(model.coreNetworkId);
            this.policyVersionId(model.policyVersionId);
            this.alias(model.alias);
            this.description(model.description);
            this.createdAt(model.createdAt);
            this.changeSetState(model.changeSetState);
            this.policyErrors(model.policyErrors);
            this.policyDocument(model.policyDocument);
        }

        public final String getCoreNetworkId() {
            return this.coreNetworkId;
        }

        public final void setCoreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
        }

        @Override
        public final Builder coreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
            return this;
        }

        public final Integer getPolicyVersionId() {
            return this.policyVersionId;
        }

        public final void setPolicyVersionId(Integer policyVersionId) {
            this.policyVersionId = policyVersionId;
        }

        @Override
        public final Builder policyVersionId(Integer policyVersionId) {
            this.policyVersionId = policyVersionId;
            return this;
        }

        public final String getAlias() {
            return this.alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        @Override
        public final Builder alias(CoreNetworkPolicyAlias alias) {
            this.alias(alias == null ? null : alias.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getChangeSetState() {
            return this.changeSetState;
        }

        public final void setChangeSetState(String changeSetState) {
            this.changeSetState = changeSetState;
        }

        @Override
        public final Builder changeSetState(String changeSetState) {
            this.changeSetState = changeSetState;
            return this;
        }

        @Override
        public final Builder changeSetState(ChangeSetState changeSetState) {
            this.changeSetState(changeSetState == null ? null : changeSetState.toString());
            return this;
        }

        public final List<CoreNetworkPolicyError.Builder> getPolicyErrors() {
            List<CoreNetworkPolicyError.Builder> result = CoreNetworkPolicyErrorListCopier.copyToBuilder(this.policyErrors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicyErrors(Collection<CoreNetworkPolicyError.BuilderImpl> policyErrors) {
            this.policyErrors = CoreNetworkPolicyErrorListCopier.copyFromBuilder(policyErrors);
        }

        @Override
        public final Builder policyErrors(Collection<CoreNetworkPolicyError> policyErrors) {
            this.policyErrors = CoreNetworkPolicyErrorListCopier.copy(policyErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyErrors(CoreNetworkPolicyError ... policyErrors) {
            this.policyErrors(Arrays.asList(policyErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyErrors(Consumer<CoreNetworkPolicyError.Builder> ... policyErrors) {
            this.policyErrors(Stream.of(policyErrors).map(c -> (CoreNetworkPolicyError)((CoreNetworkPolicyError.Builder)CoreNetworkPolicyError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPolicyDocument() {
            return this.policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public CoreNetworkPolicy build() {
            return new CoreNetworkPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CoreNetworkPolicy> {
        public Builder coreNetworkId(String var1);

        public Builder policyVersionId(Integer var1);

        public Builder alias(String var1);

        public Builder alias(CoreNetworkPolicyAlias var1);

        public Builder description(String var1);

        public Builder createdAt(Instant var1);

        public Builder changeSetState(String var1);

        public Builder changeSetState(ChangeSetState var1);

        public Builder policyErrors(Collection<CoreNetworkPolicyError> var1);

        public Builder policyErrors(CoreNetworkPolicyError ... var1);

        public Builder policyErrors(Consumer<CoreNetworkPolicyError.Builder> ... var1);

        public Builder policyDocument(String var1);
    }
}

