/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.EncryptionConfiguration;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallRequest;
import software.amazon.awssdk.services.networkfirewall.model.SubnetMapping;
import software.amazon.awssdk.services.networkfirewall.model.SubnetMappingsCopier;
import software.amazon.awssdk.services.networkfirewall.model.Tag;
import software.amazon.awssdk.services.networkfirewall.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFirewallRequest
extends NetworkFirewallRequest
implements ToCopyableBuilder<Builder, CreateFirewallRequest> {
    private static final SdkField<String> FIREWALL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallName").getter(CreateFirewallRequest.getter(CreateFirewallRequest::firewallName)).setter(CreateFirewallRequest.setter(Builder::firewallName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallName").build()}).build();
    private static final SdkField<String> FIREWALL_POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallPolicyArn").getter(CreateFirewallRequest.getter(CreateFirewallRequest::firewallPolicyArn)).setter(CreateFirewallRequest.setter(Builder::firewallPolicyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallPolicyArn").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(CreateFirewallRequest.getter(CreateFirewallRequest::vpcId)).setter(CreateFirewallRequest.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<List<SubnetMapping>> SUBNET_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetMappings").getter(CreateFirewallRequest.getter(CreateFirewallRequest::subnetMappings)).setter(CreateFirewallRequest.setter(Builder::subnetMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SubnetMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DELETE_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeleteProtection").getter(CreateFirewallRequest.getter(CreateFirewallRequest::deleteProtection)).setter(CreateFirewallRequest.setter(Builder::deleteProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteProtection").build()}).build();
    private static final SdkField<Boolean> SUBNET_CHANGE_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SubnetChangeProtection").getter(CreateFirewallRequest.getter(CreateFirewallRequest::subnetChangeProtection)).setter(CreateFirewallRequest.setter(Builder::subnetChangeProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetChangeProtection").build()}).build();
    private static final SdkField<Boolean> FIREWALL_POLICY_CHANGE_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("FirewallPolicyChangeProtection").getter(CreateFirewallRequest.getter(CreateFirewallRequest::firewallPolicyChangeProtection)).setter(CreateFirewallRequest.setter(Builder::firewallPolicyChangeProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallPolicyChangeProtection").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateFirewallRequest.getter(CreateFirewallRequest::description)).setter(CreateFirewallRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateFirewallRequest.getter(CreateFirewallRequest::tags)).setter(CreateFirewallRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionConfiguration").getter(CreateFirewallRequest.getter(CreateFirewallRequest::encryptionConfiguration)).setter(CreateFirewallRequest.setter(Builder::encryptionConfiguration)).constructor(EncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_NAME_FIELD, FIREWALL_POLICY_ARN_FIELD, VPC_ID_FIELD, SUBNET_MAPPINGS_FIELD, DELETE_PROTECTION_FIELD, SUBNET_CHANGE_PROTECTION_FIELD, FIREWALL_POLICY_CHANGE_PROTECTION_FIELD, DESCRIPTION_FIELD, TAGS_FIELD, ENCRYPTION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("FirewallName", FIREWALL_NAME_FIELD);
            this.put("FirewallPolicyArn", FIREWALL_POLICY_ARN_FIELD);
            this.put("VpcId", VPC_ID_FIELD);
            this.put("SubnetMappings", SUBNET_MAPPINGS_FIELD);
            this.put("DeleteProtection", DELETE_PROTECTION_FIELD);
            this.put("SubnetChangeProtection", SUBNET_CHANGE_PROTECTION_FIELD);
            this.put("FirewallPolicyChangeProtection", FIREWALL_POLICY_CHANGE_PROTECTION_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("Tags", TAGS_FIELD);
            this.put("EncryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        }
    });
    private final String firewallName;
    private final String firewallPolicyArn;
    private final String vpcId;
    private final List<SubnetMapping> subnetMappings;
    private final Boolean deleteProtection;
    private final Boolean subnetChangeProtection;
    private final Boolean firewallPolicyChangeProtection;
    private final String description;
    private final List<Tag> tags;
    private final EncryptionConfiguration encryptionConfiguration;

    private CreateFirewallRequest(BuilderImpl builder) {
        super(builder);
        this.firewallName = builder.firewallName;
        this.firewallPolicyArn = builder.firewallPolicyArn;
        this.vpcId = builder.vpcId;
        this.subnetMappings = builder.subnetMappings;
        this.deleteProtection = builder.deleteProtection;
        this.subnetChangeProtection = builder.subnetChangeProtection;
        this.firewallPolicyChangeProtection = builder.firewallPolicyChangeProtection;
        this.description = builder.description;
        this.tags = builder.tags;
        this.encryptionConfiguration = builder.encryptionConfiguration;
    }

    public final String firewallName() {
        return this.firewallName;
    }

    public final String firewallPolicyArn() {
        return this.firewallPolicyArn;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final boolean hasSubnetMappings() {
        return this.subnetMappings != null && !(this.subnetMappings instanceof SdkAutoConstructList);
    }

    public final List<SubnetMapping> subnetMappings() {
        return this.subnetMappings;
    }

    public final Boolean deleteProtection() {
        return this.deleteProtection;
    }

    public final Boolean subnetChangeProtection() {
        return this.subnetChangeProtection;
    }

    public final Boolean firewallPolicyChangeProtection() {
        return this.firewallPolicyChangeProtection;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final EncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallName());
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallPolicyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetMappings() ? this.subnetMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteProtection());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetChangeProtection());
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallPolicyChangeProtection());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFirewallRequest)) {
            return false;
        }
        CreateFirewallRequest other = (CreateFirewallRequest)((Object)obj);
        return Objects.equals(this.firewallName(), other.firewallName()) && Objects.equals(this.firewallPolicyArn(), other.firewallPolicyArn()) && Objects.equals(this.vpcId(), other.vpcId()) && this.hasSubnetMappings() == other.hasSubnetMappings() && Objects.equals(this.subnetMappings(), other.subnetMappings()) && Objects.equals(this.deleteProtection(), other.deleteProtection()) && Objects.equals(this.subnetChangeProtection(), other.subnetChangeProtection()) && Objects.equals(this.firewallPolicyChangeProtection(), other.firewallPolicyChangeProtection()) && Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"CreateFirewallRequest").add("FirewallName", (Object)this.firewallName()).add("FirewallPolicyArn", (Object)this.firewallPolicyArn()).add("VpcId", (Object)this.vpcId()).add("SubnetMappings", this.hasSubnetMappings() ? this.subnetMappings() : null).add("DeleteProtection", (Object)this.deleteProtection()).add("SubnetChangeProtection", (Object)this.subnetChangeProtection()).add("FirewallPolicyChangeProtection", (Object)this.firewallPolicyChangeProtection()).add("Description", (Object)this.description()).add("Tags", this.hasTags() ? this.tags() : null).add("EncryptionConfiguration", (Object)this.encryptionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FirewallName": {
                return Optional.ofNullable(clazz.cast(this.firewallName()));
            }
            case "FirewallPolicyArn": {
                return Optional.ofNullable(clazz.cast(this.firewallPolicyArn()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "SubnetMappings": {
                return Optional.ofNullable(clazz.cast(this.subnetMappings()));
            }
            case "DeleteProtection": {
                return Optional.ofNullable(clazz.cast(this.deleteProtection()));
            }
            case "SubnetChangeProtection": {
                return Optional.ofNullable(clazz.cast(this.subnetChangeProtection()));
            }
            case "FirewallPolicyChangeProtection": {
                return Optional.ofNullable(clazz.cast(this.firewallPolicyChangeProtection()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "EncryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateFirewallRequest, T> g) {
        return obj -> g.apply((CreateFirewallRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallRequest.BuilderImpl
    implements Builder {
        private String firewallName;
        private String firewallPolicyArn;
        private String vpcId;
        private List<SubnetMapping> subnetMappings = DefaultSdkAutoConstructList.getInstance();
        private Boolean deleteProtection;
        private Boolean subnetChangeProtection;
        private Boolean firewallPolicyChangeProtection;
        private String description;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private EncryptionConfiguration encryptionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFirewallRequest model) {
            super(model);
            this.firewallName(model.firewallName);
            this.firewallPolicyArn(model.firewallPolicyArn);
            this.vpcId(model.vpcId);
            this.subnetMappings(model.subnetMappings);
            this.deleteProtection(model.deleteProtection);
            this.subnetChangeProtection(model.subnetChangeProtection);
            this.firewallPolicyChangeProtection(model.firewallPolicyChangeProtection);
            this.description(model.description);
            this.tags(model.tags);
            this.encryptionConfiguration(model.encryptionConfiguration);
        }

        public final String getFirewallName() {
            return this.firewallName;
        }

        public final void setFirewallName(String firewallName) {
            this.firewallName = firewallName;
        }

        @Override
        public final Builder firewallName(String firewallName) {
            this.firewallName = firewallName;
            return this;
        }

        public final String getFirewallPolicyArn() {
            return this.firewallPolicyArn;
        }

        public final void setFirewallPolicyArn(String firewallPolicyArn) {
            this.firewallPolicyArn = firewallPolicyArn;
        }

        @Override
        public final Builder firewallPolicyArn(String firewallPolicyArn) {
            this.firewallPolicyArn = firewallPolicyArn;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final List<SubnetMapping.Builder> getSubnetMappings() {
            List<SubnetMapping.Builder> result = SubnetMappingsCopier.copyToBuilder(this.subnetMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubnetMappings(Collection<SubnetMapping.BuilderImpl> subnetMappings) {
            this.subnetMappings = SubnetMappingsCopier.copyFromBuilder(subnetMappings);
        }

        @Override
        public final Builder subnetMappings(Collection<SubnetMapping> subnetMappings) {
            this.subnetMappings = SubnetMappingsCopier.copy(subnetMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetMappings(SubnetMapping ... subnetMappings) {
            this.subnetMappings(Arrays.asList(subnetMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetMappings(Consumer<SubnetMapping.Builder> ... subnetMappings) {
            this.subnetMappings(Stream.of(subnetMappings).map(c -> (SubnetMapping)((SubnetMapping.Builder)SubnetMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getDeleteProtection() {
            return this.deleteProtection;
        }

        public final void setDeleteProtection(Boolean deleteProtection) {
            this.deleteProtection = deleteProtection;
        }

        @Override
        public final Builder deleteProtection(Boolean deleteProtection) {
            this.deleteProtection = deleteProtection;
            return this;
        }

        public final Boolean getSubnetChangeProtection() {
            return this.subnetChangeProtection;
        }

        public final void setSubnetChangeProtection(Boolean subnetChangeProtection) {
            this.subnetChangeProtection = subnetChangeProtection;
        }

        @Override
        public final Builder subnetChangeProtection(Boolean subnetChangeProtection) {
            this.subnetChangeProtection = subnetChangeProtection;
            return this;
        }

        public final Boolean getFirewallPolicyChangeProtection() {
            return this.firewallPolicyChangeProtection;
        }

        public final void setFirewallPolicyChangeProtection(Boolean firewallPolicyChangeProtection) {
            this.firewallPolicyChangeProtection = firewallPolicyChangeProtection;
        }

        @Override
        public final Builder firewallPolicyChangeProtection(Boolean firewallPolicyChangeProtection) {
            this.firewallPolicyChangeProtection = firewallPolicyChangeProtection;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFirewallRequest build() {
            return new CreateFirewallRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NetworkFirewallRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateFirewallRequest> {
        public Builder firewallName(String var1);

        public Builder firewallPolicyArn(String var1);

        public Builder vpcId(String var1);

        public Builder subnetMappings(Collection<SubnetMapping> var1);

        public Builder subnetMappings(SubnetMapping ... var1);

        public Builder subnetMappings(Consumer<SubnetMapping.Builder> ... var1);

        public Builder deleteProtection(Boolean var1);

        public Builder subnetChangeProtection(Boolean var1);

        public Builder firewallPolicyChangeProtection(Boolean var1);

        public Builder description(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder encryptionConfiguration(EncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((EncryptionConfiguration)((EncryptionConfiguration.Builder)EncryptionConfiguration.builder().applyMutation(encryptionConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

