/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.neptunedata.model.Format;
import software.amazon.awssdk.services.neptunedata.model.Mode;
import software.amazon.awssdk.services.neptunedata.model.NeptunedataRequest;
import software.amazon.awssdk.services.neptunedata.model.Parallelism;
import software.amazon.awssdk.services.neptunedata.model.S3BucketRegion;
import software.amazon.awssdk.services.neptunedata.model.StringListCopier;
import software.amazon.awssdk.services.neptunedata.model.StringValuedMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartLoaderJobRequest
extends NeptunedataRequest
implements ToCopyableBuilder<Builder, StartLoaderJobRequest> {
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("source").getter(StartLoaderJobRequest.getter(StartLoaderJobRequest::source)).setter(StartLoaderJobRequest.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("format").getter(StartLoaderJobRequest.getter(StartLoaderJobRequest::formatAsString)).setter(StartLoaderJobRequest.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()}).build();
    private static final SdkField<String> S3_BUCKET_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3BucketRegion").getter(StartLoaderJobRequest.getter(StartLoaderJobRequest::s3BucketRegionAsString)).setter(StartLoaderJobRequest.setter(Builder::s3BucketRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("iamRoleArn").getter(StartLoaderJobRequest.getter(StartLoaderJobRequest::iamRoleArn)).setter(StartLoaderJobRequest.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamRoleArn").build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mode").getter(StartLoaderJobRequest.getter(StartLoaderJobRequest::modeAsString)).setter(StartLoaderJobRequest.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build()}).build();
    private static final SdkField<Boolean> FAIL_ON_ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("failOnError").getter(StartLoaderJobRequest.getter(StartLoaderJobRequest::failOnError)).setter(StartLoaderJobRequest.setter(Builder::failOnError)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failOnError").build()}).build();
    private static final SdkField<String> PARALLELISM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parallelism").getter(StartLoaderJobRequest.getter(StartLoaderJobRequest::parallelismAsString)).setter(StartLoaderJobRequest.setter(Builder::parallelism)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parallelism").build()}).build();
    private static final SdkField<Map<String, String>> PARSER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("parserConfiguration").getter(StartLoaderJobRequest.getter(StartLoaderJobRequest::parserConfiguration)).setter(StartLoaderJobRequest.setter(Builder::parserConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parserConfiguration").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Boolean> UPDATE_SINGLE_CARDINALITY_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("updateSingleCardinalityProperties").getter(StartLoaderJobRequest.getter(StartLoaderJobRequest::updateSingleCardinalityProperties)).setter(StartLoaderJobRequest.setter(Builder::updateSingleCardinalityProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateSingleCardinalityProperties").build()}).build();
    private static final SdkField<Boolean> QUEUE_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("queueRequest").getter(StartLoaderJobRequest.getter(StartLoaderJobRequest::queueRequest)).setter(StartLoaderJobRequest.setter(Builder::queueRequest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueRequest").build()}).build();
    private static final SdkField<List<String>> DEPENDENCIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dependencies").getter(StartLoaderJobRequest.getter(StartLoaderJobRequest::dependencies)).setter(StartLoaderJobRequest.setter(Builder::dependencies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dependencies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> USER_PROVIDED_EDGE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("userProvidedEdgeIds").getter(StartLoaderJobRequest.getter(StartLoaderJobRequest::userProvidedEdgeIds)).setter(StartLoaderJobRequest.setter(Builder::userProvidedEdgeIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userProvidedEdgeIds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD, FORMAT_FIELD, S3_BUCKET_REGION_FIELD, IAM_ROLE_ARN_FIELD, MODE_FIELD, FAIL_ON_ERROR_FIELD, PARALLELISM_FIELD, PARSER_CONFIGURATION_FIELD, UPDATE_SINGLE_CARDINALITY_PROPERTIES_FIELD, QUEUE_REQUEST_FIELD, DEPENDENCIES_FIELD, USER_PROVIDED_EDGE_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("source", SOURCE_FIELD);
            this.put("format", FORMAT_FIELD);
            this.put("region", S3_BUCKET_REGION_FIELD);
            this.put("iamRoleArn", IAM_ROLE_ARN_FIELD);
            this.put("mode", MODE_FIELD);
            this.put("failOnError", FAIL_ON_ERROR_FIELD);
            this.put("parallelism", PARALLELISM_FIELD);
            this.put("parserConfiguration", PARSER_CONFIGURATION_FIELD);
            this.put("updateSingleCardinalityProperties", UPDATE_SINGLE_CARDINALITY_PROPERTIES_FIELD);
            this.put("queueRequest", QUEUE_REQUEST_FIELD);
            this.put("dependencies", DEPENDENCIES_FIELD);
            this.put("userProvidedEdgeIds", USER_PROVIDED_EDGE_IDS_FIELD);
        }
    });
    private final String source;
    private final String format;
    private final String s3BucketRegion;
    private final String iamRoleArn;
    private final String mode;
    private final Boolean failOnError;
    private final String parallelism;
    private final Map<String, String> parserConfiguration;
    private final Boolean updateSingleCardinalityProperties;
    private final Boolean queueRequest;
    private final List<String> dependencies;
    private final Boolean userProvidedEdgeIds;

    private StartLoaderJobRequest(BuilderImpl builder) {
        super(builder);
        this.source = builder.source;
        this.format = builder.format;
        this.s3BucketRegion = builder.s3BucketRegion;
        this.iamRoleArn = builder.iamRoleArn;
        this.mode = builder.mode;
        this.failOnError = builder.failOnError;
        this.parallelism = builder.parallelism;
        this.parserConfiguration = builder.parserConfiguration;
        this.updateSingleCardinalityProperties = builder.updateSingleCardinalityProperties;
        this.queueRequest = builder.queueRequest;
        this.dependencies = builder.dependencies;
        this.userProvidedEdgeIds = builder.userProvidedEdgeIds;
    }

    public final String source() {
        return this.source;
    }

    public final Format format() {
        return Format.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final S3BucketRegion s3BucketRegion() {
        return S3BucketRegion.fromValue(this.s3BucketRegion);
    }

    public final String s3BucketRegionAsString() {
        return this.s3BucketRegion;
    }

    public final String iamRoleArn() {
        return this.iamRoleArn;
    }

    public final Mode mode() {
        return Mode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public final Boolean failOnError() {
        return this.failOnError;
    }

    public final Parallelism parallelism() {
        return Parallelism.fromValue(this.parallelism);
    }

    public final String parallelismAsString() {
        return this.parallelism;
    }

    public final boolean hasParserConfiguration() {
        return this.parserConfiguration != null && !(this.parserConfiguration instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> parserConfiguration() {
        return this.parserConfiguration;
    }

    public final Boolean updateSingleCardinalityProperties() {
        return this.updateSingleCardinalityProperties;
    }

    public final Boolean queueRequest() {
        return this.queueRequest;
    }

    public final boolean hasDependencies() {
        return this.dependencies != null && !(this.dependencies instanceof SdkAutoConstructList);
    }

    public final List<String> dependencies() {
        return this.dependencies;
    }

    public final Boolean userProvidedEdgeIds() {
        return this.userProvidedEdgeIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketRegionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failOnError());
        hashCode = 31 * hashCode + Objects.hashCode(this.parallelismAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParserConfiguration() ? this.parserConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.updateSingleCardinalityProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueRequest());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDependencies() ? this.dependencies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.userProvidedEdgeIds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartLoaderJobRequest)) {
            return false;
        }
        StartLoaderJobRequest other = (StartLoaderJobRequest)((Object)obj);
        return Objects.equals(this.source(), other.source()) && Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.s3BucketRegionAsString(), other.s3BucketRegionAsString()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.failOnError(), other.failOnError()) && Objects.equals(this.parallelismAsString(), other.parallelismAsString()) && this.hasParserConfiguration() == other.hasParserConfiguration() && Objects.equals(this.parserConfiguration(), other.parserConfiguration()) && Objects.equals(this.updateSingleCardinalityProperties(), other.updateSingleCardinalityProperties()) && Objects.equals(this.queueRequest(), other.queueRequest()) && this.hasDependencies() == other.hasDependencies() && Objects.equals(this.dependencies(), other.dependencies()) && Objects.equals(this.userProvidedEdgeIds(), other.userProvidedEdgeIds());
    }

    public final String toString() {
        return ToString.builder((String)"StartLoaderJobRequest").add("Source", (Object)this.source()).add("Format", (Object)this.formatAsString()).add("S3BucketRegion", (Object)this.s3BucketRegionAsString()).add("IamRoleArn", (Object)this.iamRoleArn()).add("Mode", (Object)this.modeAsString()).add("FailOnError", (Object)this.failOnError()).add("Parallelism", (Object)this.parallelismAsString()).add("ParserConfiguration", this.hasParserConfiguration() ? this.parserConfiguration() : null).add("UpdateSingleCardinalityProperties", (Object)this.updateSingleCardinalityProperties()).add("QueueRequest", (Object)this.queueRequest()).add("Dependencies", this.hasDependencies() ? this.dependencies() : null).add("UserProvidedEdgeIds", (Object)this.userProvidedEdgeIds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "s3BucketRegion": {
                return Optional.ofNullable(clazz.cast(this.s3BucketRegionAsString()));
            }
            case "iamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
            case "mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "failOnError": {
                return Optional.ofNullable(clazz.cast(this.failOnError()));
            }
            case "parallelism": {
                return Optional.ofNullable(clazz.cast(this.parallelismAsString()));
            }
            case "parserConfiguration": {
                return Optional.ofNullable(clazz.cast(this.parserConfiguration()));
            }
            case "updateSingleCardinalityProperties": {
                return Optional.ofNullable(clazz.cast(this.updateSingleCardinalityProperties()));
            }
            case "queueRequest": {
                return Optional.ofNullable(clazz.cast(this.queueRequest()));
            }
            case "dependencies": {
                return Optional.ofNullable(clazz.cast(this.dependencies()));
            }
            case "userProvidedEdgeIds": {
                return Optional.ofNullable(clazz.cast(this.userProvidedEdgeIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartLoaderJobRequest, T> g) {
        return obj -> g.apply((StartLoaderJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptunedataRequest.BuilderImpl
    implements Builder {
        private String source;
        private String format;
        private String s3BucketRegion;
        private String iamRoleArn;
        private String mode;
        private Boolean failOnError;
        private String parallelism;
        private Map<String, String> parserConfiguration = DefaultSdkAutoConstructMap.getInstance();
        private Boolean updateSingleCardinalityProperties;
        private Boolean queueRequest;
        private List<String> dependencies = DefaultSdkAutoConstructList.getInstance();
        private Boolean userProvidedEdgeIds;

        private BuilderImpl() {
        }

        private BuilderImpl(StartLoaderJobRequest model) {
            super(model);
            this.source(model.source);
            this.format(model.format);
            this.s3BucketRegion(model.s3BucketRegion);
            this.iamRoleArn(model.iamRoleArn);
            this.mode(model.mode);
            this.failOnError(model.failOnError);
            this.parallelism(model.parallelism);
            this.parserConfiguration(model.parserConfiguration);
            this.updateSingleCardinalityProperties(model.updateSingleCardinalityProperties);
            this.queueRequest(model.queueRequest);
            this.dependencies(model.dependencies);
            this.userProvidedEdgeIds(model.userProvidedEdgeIds);
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(Format format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getS3BucketRegion() {
            return this.s3BucketRegion;
        }

        public final void setS3BucketRegion(String s3BucketRegion) {
            this.s3BucketRegion = s3BucketRegion;
        }

        @Override
        public final Builder s3BucketRegion(String s3BucketRegion) {
            this.s3BucketRegion = s3BucketRegion;
            return this;
        }

        @Override
        public final Builder s3BucketRegion(S3BucketRegion s3BucketRegion) {
            this.s3BucketRegion(s3BucketRegion == null ? null : s3BucketRegion.toString());
            return this;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(Mode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final Boolean getFailOnError() {
            return this.failOnError;
        }

        public final void setFailOnError(Boolean failOnError) {
            this.failOnError = failOnError;
        }

        @Override
        public final Builder failOnError(Boolean failOnError) {
            this.failOnError = failOnError;
            return this;
        }

        public final String getParallelism() {
            return this.parallelism;
        }

        public final void setParallelism(String parallelism) {
            this.parallelism = parallelism;
        }

        @Override
        public final Builder parallelism(String parallelism) {
            this.parallelism = parallelism;
            return this;
        }

        @Override
        public final Builder parallelism(Parallelism parallelism) {
            this.parallelism(parallelism == null ? null : parallelism.toString());
            return this;
        }

        public final Map<String, String> getParserConfiguration() {
            if (this.parserConfiguration instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.parserConfiguration;
        }

        public final void setParserConfiguration(Map<String, String> parserConfiguration) {
            this.parserConfiguration = StringValuedMapCopier.copy(parserConfiguration);
        }

        @Override
        public final Builder parserConfiguration(Map<String, String> parserConfiguration) {
            this.parserConfiguration = StringValuedMapCopier.copy(parserConfiguration);
            return this;
        }

        public final Boolean getUpdateSingleCardinalityProperties() {
            return this.updateSingleCardinalityProperties;
        }

        public final void setUpdateSingleCardinalityProperties(Boolean updateSingleCardinalityProperties) {
            this.updateSingleCardinalityProperties = updateSingleCardinalityProperties;
        }

        @Override
        public final Builder updateSingleCardinalityProperties(Boolean updateSingleCardinalityProperties) {
            this.updateSingleCardinalityProperties = updateSingleCardinalityProperties;
            return this;
        }

        public final Boolean getQueueRequest() {
            return this.queueRequest;
        }

        public final void setQueueRequest(Boolean queueRequest) {
            this.queueRequest = queueRequest;
        }

        @Override
        public final Builder queueRequest(Boolean queueRequest) {
            this.queueRequest = queueRequest;
            return this;
        }

        public final Collection<String> getDependencies() {
            if (this.dependencies instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dependencies;
        }

        public final void setDependencies(Collection<String> dependencies) {
            this.dependencies = StringListCopier.copy(dependencies);
        }

        @Override
        public final Builder dependencies(Collection<String> dependencies) {
            this.dependencies = StringListCopier.copy(dependencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependencies(String ... dependencies) {
            this.dependencies(Arrays.asList(dependencies));
            return this;
        }

        public final Boolean getUserProvidedEdgeIds() {
            return this.userProvidedEdgeIds;
        }

        public final void setUserProvidedEdgeIds(Boolean userProvidedEdgeIds) {
            this.userProvidedEdgeIds = userProvidedEdgeIds;
        }

        @Override
        public final Builder userProvidedEdgeIds(Boolean userProvidedEdgeIds) {
            this.userProvidedEdgeIds = userProvidedEdgeIds;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartLoaderJobRequest build() {
            return new StartLoaderJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NeptunedataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartLoaderJobRequest> {
        public Builder source(String var1);

        public Builder format(String var1);

        public Builder format(Format var1);

        public Builder s3BucketRegion(String var1);

        public Builder s3BucketRegion(S3BucketRegion var1);

        public Builder iamRoleArn(String var1);

        public Builder mode(String var1);

        public Builder mode(Mode var1);

        public Builder failOnError(Boolean var1);

        public Builder parallelism(String var1);

        public Builder parallelism(Parallelism var1);

        public Builder parserConfiguration(Map<String, String> var1);

        public Builder updateSingleCardinalityProperties(Boolean var1);

        public Builder queueRequest(Boolean var1);

        public Builder dependencies(Collection<String> var1);

        public Builder dependencies(String ... var1);

        public Builder userProvidedEdgeIds(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

