/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptune.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.neptune.model.Parameter;
import software.amazon.awssdk.services.neptune.model.ParametersListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EngineDefaults
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EngineDefaults> {
    private static final SdkField<String> DB_PARAMETER_GROUP_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBParameterGroupFamily").getter(EngineDefaults.getter(EngineDefaults::dbParameterGroupFamily)).setter(EngineDefaults.setter(Builder::dbParameterGroupFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBParameterGroupFamily").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(EngineDefaults.getter(EngineDefaults::marker)).setter(EngineDefaults.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<Parameter>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Parameters").getter(EngineDefaults.getter(EngineDefaults::parameters)).setter(EngineDefaults.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), ListTrait.builder().memberLocationName("Parameter").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Parameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameter").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_PARAMETER_GROUP_FAMILY_FIELD, MARKER_FIELD, PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DBParameterGroupFamily", DB_PARAMETER_GROUP_FAMILY_FIELD);
            this.put("Marker", MARKER_FIELD);
            this.put("Parameters", PARAMETERS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String dbParameterGroupFamily;
    private final String marker;
    private final List<Parameter> parameters;

    private EngineDefaults(BuilderImpl builder) {
        this.dbParameterGroupFamily = builder.dbParameterGroupFamily;
        this.marker = builder.marker;
        this.parameters = builder.parameters;
    }

    public final String dbParameterGroupFamily() {
        return this.dbParameterGroupFamily;
    }

    public final String marker() {
        return this.marker;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructList);
    }

    public final List<Parameter> parameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbParameterGroupFamily());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EngineDefaults)) {
            return false;
        }
        EngineDefaults other = (EngineDefaults)obj;
        return Objects.equals(this.dbParameterGroupFamily(), other.dbParameterGroupFamily()) && Objects.equals(this.marker(), other.marker()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters());
    }

    public final String toString() {
        return ToString.builder((String)"EngineDefaults").add("DBParameterGroupFamily", (Object)this.dbParameterGroupFamily()).add("Marker", (Object)this.marker()).add("Parameters", this.hasParameters() ? this.parameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBParameterGroupFamily": {
                return Optional.ofNullable(clazz.cast(this.dbParameterGroupFamily()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EngineDefaults, T> g) {
        return obj -> g.apply((EngineDefaults)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dbParameterGroupFamily;
        private String marker;
        private List<Parameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EngineDefaults model) {
            this.dbParameterGroupFamily(model.dbParameterGroupFamily);
            this.marker(model.marker);
            this.parameters(model.parameters);
        }

        public final String getDbParameterGroupFamily() {
            return this.dbParameterGroupFamily;
        }

        public final void setDbParameterGroupFamily(String dbParameterGroupFamily) {
            this.dbParameterGroupFamily = dbParameterGroupFamily;
        }

        @Override
        public final Builder dbParameterGroupFamily(String dbParameterGroupFamily) {
            this.dbParameterGroupFamily = dbParameterGroupFamily;
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<Parameter.Builder> getParameters() {
            List<Parameter.Builder> result = ParametersListCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<Parameter.BuilderImpl> parameters) {
            this.parameters = ParametersListCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<Parameter.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (Parameter)((Parameter.Builder)Parameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public EngineDefaults build() {
            return new EngineDefaults(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EngineDefaults> {
        public Builder dbParameterGroupFamily(String var1);

        public Builder marker(String var1);

        public Builder parameters(Collection<Parameter> var1);

        public Builder parameters(Parameter ... var1);

        public Builder parameters(Consumer<Parameter.Builder> ... var1);
    }
}

