/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mq.model.AuthenticationStrategy;
import software.amazon.awssdk.services.mq.model.ConfigurationId;
import software.amazon.awssdk.services.mq.model.DataReplicationMode;
import software.amazon.awssdk.services.mq.model.LdapServerMetadataInput;
import software.amazon.awssdk.services.mq.model.Logs;
import software.amazon.awssdk.services.mq.model.MqRequest;
import software.amazon.awssdk.services.mq.model.WeeklyStartTime;
import software.amazon.awssdk.services.mq.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateBrokerRequest
extends MqRequest
implements ToCopyableBuilder<Builder, UpdateBrokerRequest> {
    private static final SdkField<String> AUTHENTICATION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthenticationStrategy").getter(UpdateBrokerRequest.getter(UpdateBrokerRequest::authenticationStrategyAsString)).setter(UpdateBrokerRequest.setter(Builder::authenticationStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationStrategy").build()}).build();
    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoMinorVersionUpgrade").getter(UpdateBrokerRequest.getter(UpdateBrokerRequest::autoMinorVersionUpgrade)).setter(UpdateBrokerRequest.setter(Builder::autoMinorVersionUpgrade)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoMinorVersionUpgrade").build()}).build();
    private static final SdkField<String> BROKER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BrokerId").getter(UpdateBrokerRequest.getter(UpdateBrokerRequest::brokerId)).setter(UpdateBrokerRequest.setter(Builder::brokerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("broker-id").build()}).build();
    private static final SdkField<ConfigurationId> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Configuration").getter(UpdateBrokerRequest.getter(UpdateBrokerRequest::configuration)).setter(UpdateBrokerRequest.setter(Builder::configuration)).constructor(ConfigurationId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(UpdateBrokerRequest.getter(UpdateBrokerRequest::engineVersion)).setter(UpdateBrokerRequest.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineVersion").build()}).build();
    private static final SdkField<String> HOST_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostInstanceType").getter(UpdateBrokerRequest.getter(UpdateBrokerRequest::hostInstanceType)).setter(UpdateBrokerRequest.setter(Builder::hostInstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostInstanceType").build()}).build();
    private static final SdkField<LdapServerMetadataInput> LDAP_SERVER_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LdapServerMetadata").getter(UpdateBrokerRequest.getter(UpdateBrokerRequest::ldapServerMetadata)).setter(UpdateBrokerRequest.setter(Builder::ldapServerMetadata)).constructor(LdapServerMetadataInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ldapServerMetadata").build()}).build();
    private static final SdkField<Logs> LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Logs").getter(UpdateBrokerRequest.getter(UpdateBrokerRequest::logs)).setter(UpdateBrokerRequest.setter(Builder::logs)).constructor(Logs::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logs").build()}).build();
    private static final SdkField<WeeklyStartTime> MAINTENANCE_WINDOW_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MaintenanceWindowStartTime").getter(UpdateBrokerRequest.getter(UpdateBrokerRequest::maintenanceWindowStartTime)).setter(UpdateBrokerRequest.setter(Builder::maintenanceWindowStartTime)).constructor(WeeklyStartTime::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceWindowStartTime").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroups").getter(UpdateBrokerRequest.getter(UpdateBrokerRequest::securityGroups)).setter(UpdateBrokerRequest.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DATA_REPLICATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataReplicationMode").getter(UpdateBrokerRequest.getter(UpdateBrokerRequest::dataReplicationModeAsString)).setter(UpdateBrokerRequest.setter(Builder::dataReplicationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataReplicationMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_STRATEGY_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD, BROKER_ID_FIELD, CONFIGURATION_FIELD, ENGINE_VERSION_FIELD, HOST_INSTANCE_TYPE_FIELD, LDAP_SERVER_METADATA_FIELD, LOGS_FIELD, MAINTENANCE_WINDOW_START_TIME_FIELD, SECURITY_GROUPS_FIELD, DATA_REPLICATION_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("authenticationStrategy", AUTHENTICATION_STRATEGY_FIELD);
            this.put("autoMinorVersionUpgrade", AUTO_MINOR_VERSION_UPGRADE_FIELD);
            this.put("broker-id", BROKER_ID_FIELD);
            this.put("configuration", CONFIGURATION_FIELD);
            this.put("engineVersion", ENGINE_VERSION_FIELD);
            this.put("hostInstanceType", HOST_INSTANCE_TYPE_FIELD);
            this.put("ldapServerMetadata", LDAP_SERVER_METADATA_FIELD);
            this.put("logs", LOGS_FIELD);
            this.put("maintenanceWindowStartTime", MAINTENANCE_WINDOW_START_TIME_FIELD);
            this.put("securityGroups", SECURITY_GROUPS_FIELD);
            this.put("dataReplicationMode", DATA_REPLICATION_MODE_FIELD);
        }
    });
    private final String authenticationStrategy;
    private final Boolean autoMinorVersionUpgrade;
    private final String brokerId;
    private final ConfigurationId configuration;
    private final String engineVersion;
    private final String hostInstanceType;
    private final LdapServerMetadataInput ldapServerMetadata;
    private final Logs logs;
    private final WeeklyStartTime maintenanceWindowStartTime;
    private final List<String> securityGroups;
    private final String dataReplicationMode;

    private UpdateBrokerRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationStrategy = builder.authenticationStrategy;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.brokerId = builder.brokerId;
        this.configuration = builder.configuration;
        this.engineVersion = builder.engineVersion;
        this.hostInstanceType = builder.hostInstanceType;
        this.ldapServerMetadata = builder.ldapServerMetadata;
        this.logs = builder.logs;
        this.maintenanceWindowStartTime = builder.maintenanceWindowStartTime;
        this.securityGroups = builder.securityGroups;
        this.dataReplicationMode = builder.dataReplicationMode;
    }

    public final AuthenticationStrategy authenticationStrategy() {
        return AuthenticationStrategy.fromValue(this.authenticationStrategy);
    }

    public final String authenticationStrategyAsString() {
        return this.authenticationStrategy;
    }

    public final Boolean autoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public final String brokerId() {
        return this.brokerId;
    }

    public final ConfigurationId configuration() {
        return this.configuration;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final String hostInstanceType() {
        return this.hostInstanceType;
    }

    public final LdapServerMetadataInput ldapServerMetadata() {
        return this.ldapServerMetadata;
    }

    public final Logs logs() {
        return this.logs;
    }

    public final WeeklyStartTime maintenanceWindowStartTime() {
        return this.maintenanceWindowStartTime;
    }

    public final boolean hasSecurityGroups() {
        return this.securityGroups != null && !(this.securityGroups instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroups() {
        return this.securityGroups;
    }

    public final DataReplicationMode dataReplicationMode() {
        return DataReplicationMode.fromValue(this.dataReplicationMode);
    }

    public final String dataReplicationModeAsString() {
        return this.dataReplicationMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.brokerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.ldapServerMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.logs());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceWindowStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroups() ? this.securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dataReplicationModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBrokerRequest)) {
            return false;
        }
        UpdateBrokerRequest other = (UpdateBrokerRequest)((Object)obj);
        return Objects.equals(this.authenticationStrategyAsString(), other.authenticationStrategyAsString()) && Objects.equals(this.autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade()) && Objects.equals(this.brokerId(), other.brokerId()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.hostInstanceType(), other.hostInstanceType()) && Objects.equals(this.ldapServerMetadata(), other.ldapServerMetadata()) && Objects.equals(this.logs(), other.logs()) && Objects.equals(this.maintenanceWindowStartTime(), other.maintenanceWindowStartTime()) && this.hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.dataReplicationModeAsString(), other.dataReplicationModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateBrokerRequest").add("AuthenticationStrategy", (Object)this.authenticationStrategyAsString()).add("AutoMinorVersionUpgrade", (Object)this.autoMinorVersionUpgrade()).add("BrokerId", (Object)this.brokerId()).add("Configuration", (Object)this.configuration()).add("EngineVersion", (Object)this.engineVersion()).add("HostInstanceType", (Object)this.hostInstanceType()).add("LdapServerMetadata", (Object)this.ldapServerMetadata()).add("Logs", (Object)this.logs()).add("MaintenanceWindowStartTime", (Object)this.maintenanceWindowStartTime()).add("SecurityGroups", this.hasSecurityGroups() ? this.securityGroups() : null).add("DataReplicationMode", (Object)this.dataReplicationModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationStrategy": {
                return Optional.ofNullable(clazz.cast(this.authenticationStrategyAsString()));
            }
            case "AutoMinorVersionUpgrade": {
                return Optional.ofNullable(clazz.cast(this.autoMinorVersionUpgrade()));
            }
            case "BrokerId": {
                return Optional.ofNullable(clazz.cast(this.brokerId()));
            }
            case "Configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "HostInstanceType": {
                return Optional.ofNullable(clazz.cast(this.hostInstanceType()));
            }
            case "LdapServerMetadata": {
                return Optional.ofNullable(clazz.cast(this.ldapServerMetadata()));
            }
            case "Logs": {
                return Optional.ofNullable(clazz.cast(this.logs()));
            }
            case "MaintenanceWindowStartTime": {
                return Optional.ofNullable(clazz.cast(this.maintenanceWindowStartTime()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "DataReplicationMode": {
                return Optional.ofNullable(clazz.cast(this.dataReplicationModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBrokerRequest, T> g) {
        return obj -> g.apply((UpdateBrokerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MqRequest.BuilderImpl
    implements Builder {
        private String authenticationStrategy;
        private Boolean autoMinorVersionUpgrade;
        private String brokerId;
        private ConfigurationId configuration;
        private String engineVersion;
        private String hostInstanceType;
        private LdapServerMetadataInput ldapServerMetadata;
        private Logs logs;
        private WeeklyStartTime maintenanceWindowStartTime;
        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private String dataReplicationMode;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBrokerRequest model) {
            super(model);
            this.authenticationStrategy(model.authenticationStrategy);
            this.autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            this.brokerId(model.brokerId);
            this.configuration(model.configuration);
            this.engineVersion(model.engineVersion);
            this.hostInstanceType(model.hostInstanceType);
            this.ldapServerMetadata(model.ldapServerMetadata);
            this.logs(model.logs);
            this.maintenanceWindowStartTime(model.maintenanceWindowStartTime);
            this.securityGroups(model.securityGroups);
            this.dataReplicationMode(model.dataReplicationMode);
        }

        public final String getAuthenticationStrategy() {
            return this.authenticationStrategy;
        }

        public final void setAuthenticationStrategy(String authenticationStrategy) {
            this.authenticationStrategy = authenticationStrategy;
        }

        @Override
        public final Builder authenticationStrategy(String authenticationStrategy) {
            this.authenticationStrategy = authenticationStrategy;
            return this;
        }

        @Override
        public final Builder authenticationStrategy(AuthenticationStrategy authenticationStrategy) {
            this.authenticationStrategy(authenticationStrategy == null ? null : authenticationStrategy.toString());
            return this;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final String getBrokerId() {
            return this.brokerId;
        }

        public final void setBrokerId(String brokerId) {
            this.brokerId = brokerId;
        }

        @Override
        public final Builder brokerId(String brokerId) {
            this.brokerId = brokerId;
            return this;
        }

        public final ConfigurationId.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(ConfigurationId.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(ConfigurationId configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getHostInstanceType() {
            return this.hostInstanceType;
        }

        public final void setHostInstanceType(String hostInstanceType) {
            this.hostInstanceType = hostInstanceType;
        }

        @Override
        public final Builder hostInstanceType(String hostInstanceType) {
            this.hostInstanceType = hostInstanceType;
            return this;
        }

        public final LdapServerMetadataInput.Builder getLdapServerMetadata() {
            return this.ldapServerMetadata != null ? this.ldapServerMetadata.toBuilder() : null;
        }

        public final void setLdapServerMetadata(LdapServerMetadataInput.BuilderImpl ldapServerMetadata) {
            this.ldapServerMetadata = ldapServerMetadata != null ? ldapServerMetadata.build() : null;
        }

        @Override
        public final Builder ldapServerMetadata(LdapServerMetadataInput ldapServerMetadata) {
            this.ldapServerMetadata = ldapServerMetadata;
            return this;
        }

        public final Logs.Builder getLogs() {
            return this.logs != null ? this.logs.toBuilder() : null;
        }

        public final void setLogs(Logs.BuilderImpl logs) {
            this.logs = logs != null ? logs.build() : null;
        }

        @Override
        public final Builder logs(Logs logs) {
            this.logs = logs;
            return this;
        }

        public final WeeklyStartTime.Builder getMaintenanceWindowStartTime() {
            return this.maintenanceWindowStartTime != null ? this.maintenanceWindowStartTime.toBuilder() : null;
        }

        public final void setMaintenanceWindowStartTime(WeeklyStartTime.BuilderImpl maintenanceWindowStartTime) {
            this.maintenanceWindowStartTime = maintenanceWindowStartTime != null ? maintenanceWindowStartTime.build() : null;
        }

        @Override
        public final Builder maintenanceWindowStartTime(WeeklyStartTime maintenanceWindowStartTime) {
            this.maintenanceWindowStartTime = maintenanceWindowStartTime;
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (this.securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = ___listOf__stringCopier.copy(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = ___listOf__stringCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final String getDataReplicationMode() {
            return this.dataReplicationMode;
        }

        public final void setDataReplicationMode(String dataReplicationMode) {
            this.dataReplicationMode = dataReplicationMode;
        }

        @Override
        public final Builder dataReplicationMode(String dataReplicationMode) {
            this.dataReplicationMode = dataReplicationMode;
            return this;
        }

        @Override
        public final Builder dataReplicationMode(DataReplicationMode dataReplicationMode) {
            this.dataReplicationMode(dataReplicationMode == null ? null : dataReplicationMode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBrokerRequest build() {
            return new UpdateBrokerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MqRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateBrokerRequest> {
        public Builder authenticationStrategy(String var1);

        public Builder authenticationStrategy(AuthenticationStrategy var1);

        public Builder autoMinorVersionUpgrade(Boolean var1);

        public Builder brokerId(String var1);

        public Builder configuration(ConfigurationId var1);

        default public Builder configuration(Consumer<ConfigurationId.Builder> configuration) {
            return this.configuration((ConfigurationId)((ConfigurationId.Builder)ConfigurationId.builder().applyMutation(configuration)).build());
        }

        public Builder engineVersion(String var1);

        public Builder hostInstanceType(String var1);

        public Builder ldapServerMetadata(LdapServerMetadataInput var1);

        default public Builder ldapServerMetadata(Consumer<LdapServerMetadataInput.Builder> ldapServerMetadata) {
            return this.ldapServerMetadata((LdapServerMetadataInput)((LdapServerMetadataInput.Builder)LdapServerMetadataInput.builder().applyMutation(ldapServerMetadata)).build());
        }

        public Builder logs(Logs var1);

        default public Builder logs(Consumer<Logs.Builder> logs) {
            return this.logs((Logs)((Logs.Builder)Logs.builder().applyMutation(logs)).build());
        }

        public Builder maintenanceWindowStartTime(WeeklyStartTime var1);

        default public Builder maintenanceWindowStartTime(Consumer<WeeklyStartTime.Builder> maintenanceWindowStartTime) {
            return this.maintenanceWindowStartTime((WeeklyStartTime)((WeeklyStartTime.Builder)WeeklyStartTime.builder().applyMutation(maintenanceWindowStartTime)).build());
        }

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder dataReplicationMode(String var1);

        public Builder dataReplicationMode(DataReplicationMode var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

