/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Strategy {
    REHOST("Rehost"),
    RETIREMENT("Retirement"),
    REFACTOR("Refactor"),
    REPLATFORM("Replatform"),
    RETAIN("Retain"),
    RELOCATE("Relocate"),
    REPURCHASE("Repurchase"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Strategy> VALUE_MAP;
    private final String value;

    private Strategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Strategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Strategy> knownValues() {
        EnumSet<Strategy> knownValues = EnumSet.allOf(Strategy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Strategy.class, Strategy::toString);
    }
}

