/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mgn.MgnAsyncClient;
import software.amazon.awssdk.services.mgn.internal.UserAgentUtils;
import software.amazon.awssdk.services.mgn.model.ImportTask;
import software.amazon.awssdk.services.mgn.model.ListImportsRequest;
import software.amazon.awssdk.services.mgn.model.ListImportsResponse;

public class ListImportsPublisher
implements SdkPublisher<ListImportsResponse> {
    private final MgnAsyncClient client;
    private final ListImportsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListImportsPublisher(MgnAsyncClient client, ListImportsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListImportsPublisher(MgnAsyncClient client, ListImportsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListImportsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListImportsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ImportTask> items() {
        Function<ListImportsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListImportsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListImportsResponseFetcher
    implements AsyncPageFetcher<ListImportsResponse> {
        private ListImportsResponseFetcher() {
        }

        public boolean hasNextPage(ListImportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListImportsResponse> nextPage(ListImportsResponse previousPage) {
            if (previousPage == null) {
                return ListImportsPublisher.this.client.listImports(ListImportsPublisher.this.firstRequest);
            }
            return ListImportsPublisher.this.client.listImports((ListImportsRequest)((Object)ListImportsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

