/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ReplicationType {
    AGENT_BASED("AGENT_BASED"),
    SNAPSHOT_SHIPPING("SNAPSHOT_SHIPPING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ReplicationType> VALUE_MAP;
    private final String value;

    private ReplicationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ReplicationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ReplicationType> knownValues() {
        EnumSet<ReplicationType> knownValues = EnumSet.allOf(ReplicationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ReplicationType.class, ReplicationType::toString);
    }
}

