/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medicalimaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medicalimaging.model.CopyDestinationImageSetProperties;
import software.amazon.awssdk.services.medicalimaging.model.CopySourceImageSetProperties;
import software.amazon.awssdk.services.medicalimaging.model.MedicalImagingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CopyImageSetResponse
extends MedicalImagingResponse
implements ToCopyableBuilder<Builder, CopyImageSetResponse> {
    private static final SdkField<String> DATASTORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datastoreId").getter(CopyImageSetResponse.getter(CopyImageSetResponse::datastoreId)).setter(CopyImageSetResponse.setter(Builder::datastoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datastoreId").build()}).build();
    private static final SdkField<CopySourceImageSetProperties> SOURCE_IMAGE_SET_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sourceImageSetProperties").getter(CopyImageSetResponse.getter(CopyImageSetResponse::sourceImageSetProperties)).setter(CopyImageSetResponse.setter(Builder::sourceImageSetProperties)).constructor(CopySourceImageSetProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceImageSetProperties").build()}).build();
    private static final SdkField<CopyDestinationImageSetProperties> DESTINATION_IMAGE_SET_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("destinationImageSetProperties").getter(CopyImageSetResponse.getter(CopyImageSetResponse::destinationImageSetProperties)).setter(CopyImageSetResponse.setter(Builder::destinationImageSetProperties)).constructor(CopyDestinationImageSetProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationImageSetProperties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASTORE_ID_FIELD, SOURCE_IMAGE_SET_PROPERTIES_FIELD, DESTINATION_IMAGE_SET_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("datastoreId", DATASTORE_ID_FIELD);
            this.put("sourceImageSetProperties", SOURCE_IMAGE_SET_PROPERTIES_FIELD);
            this.put("destinationImageSetProperties", DESTINATION_IMAGE_SET_PROPERTIES_FIELD);
        }
    });
    private final String datastoreId;
    private final CopySourceImageSetProperties sourceImageSetProperties;
    private final CopyDestinationImageSetProperties destinationImageSetProperties;

    private CopyImageSetResponse(BuilderImpl builder) {
        super(builder);
        this.datastoreId = builder.datastoreId;
        this.sourceImageSetProperties = builder.sourceImageSetProperties;
        this.destinationImageSetProperties = builder.destinationImageSetProperties;
    }

    public final String datastoreId() {
        return this.datastoreId;
    }

    public final CopySourceImageSetProperties sourceImageSetProperties() {
        return this.sourceImageSetProperties;
    }

    public final CopyDestinationImageSetProperties destinationImageSetProperties() {
        return this.destinationImageSetProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.datastoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceImageSetProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationImageSetProperties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyImageSetResponse)) {
            return false;
        }
        CopyImageSetResponse other = (CopyImageSetResponse)((Object)obj);
        return Objects.equals(this.datastoreId(), other.datastoreId()) && Objects.equals(this.sourceImageSetProperties(), other.sourceImageSetProperties()) && Objects.equals(this.destinationImageSetProperties(), other.destinationImageSetProperties());
    }

    public final String toString() {
        return ToString.builder((String)"CopyImageSetResponse").add("DatastoreId", (Object)this.datastoreId()).add("SourceImageSetProperties", (Object)this.sourceImageSetProperties()).add("DestinationImageSetProperties", (Object)this.destinationImageSetProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "datastoreId": {
                return Optional.ofNullable(clazz.cast(this.datastoreId()));
            }
            case "sourceImageSetProperties": {
                return Optional.ofNullable(clazz.cast(this.sourceImageSetProperties()));
            }
            case "destinationImageSetProperties": {
                return Optional.ofNullable(clazz.cast(this.destinationImageSetProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CopyImageSetResponse, T> g) {
        return obj -> g.apply((CopyImageSetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MedicalImagingResponse.BuilderImpl
    implements Builder {
        private String datastoreId;
        private CopySourceImageSetProperties sourceImageSetProperties;
        private CopyDestinationImageSetProperties destinationImageSetProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyImageSetResponse model) {
            super(model);
            this.datastoreId(model.datastoreId);
            this.sourceImageSetProperties(model.sourceImageSetProperties);
            this.destinationImageSetProperties(model.destinationImageSetProperties);
        }

        public final String getDatastoreId() {
            return this.datastoreId;
        }

        public final void setDatastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
        }

        @Override
        public final Builder datastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
            return this;
        }

        public final CopySourceImageSetProperties.Builder getSourceImageSetProperties() {
            return this.sourceImageSetProperties != null ? this.sourceImageSetProperties.toBuilder() : null;
        }

        public final void setSourceImageSetProperties(CopySourceImageSetProperties.BuilderImpl sourceImageSetProperties) {
            this.sourceImageSetProperties = sourceImageSetProperties != null ? sourceImageSetProperties.build() : null;
        }

        @Override
        public final Builder sourceImageSetProperties(CopySourceImageSetProperties sourceImageSetProperties) {
            this.sourceImageSetProperties = sourceImageSetProperties;
            return this;
        }

        public final CopyDestinationImageSetProperties.Builder getDestinationImageSetProperties() {
            return this.destinationImageSetProperties != null ? this.destinationImageSetProperties.toBuilder() : null;
        }

        public final void setDestinationImageSetProperties(CopyDestinationImageSetProperties.BuilderImpl destinationImageSetProperties) {
            this.destinationImageSetProperties = destinationImageSetProperties != null ? destinationImageSetProperties.build() : null;
        }

        @Override
        public final Builder destinationImageSetProperties(CopyDestinationImageSetProperties destinationImageSetProperties) {
            this.destinationImageSetProperties = destinationImageSetProperties;
            return this;
        }

        @Override
        public CopyImageSetResponse build() {
            return new CopyImageSetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MedicalImagingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CopyImageSetResponse> {
        public Builder datastoreId(String var1);

        public Builder sourceImageSetProperties(CopySourceImageSetProperties var1);

        default public Builder sourceImageSetProperties(Consumer<CopySourceImageSetProperties.Builder> sourceImageSetProperties) {
            return this.sourceImageSetProperties((CopySourceImageSetProperties)((CopySourceImageSetProperties.Builder)CopySourceImageSetProperties.builder().applyMutation(sourceImageSetProperties)).build());
        }

        public Builder destinationImageSetProperties(CopyDestinationImageSetProperties var1);

        default public Builder destinationImageSetProperties(Consumer<CopyDestinationImageSetProperties.Builder> destinationImageSetProperties) {
            return this.destinationImageSetProperties((CopyDestinationImageSetProperties)((CopyDestinationImageSetProperties.Builder)CopyDestinationImageSetProperties.builder().applyMutation(destinationImageSetProperties)).build());
        }
    }
}

