/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediatailor.model.MediaTailorResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigureLogsForPlaybackConfigurationResponse
extends MediaTailorResponse
implements ToCopyableBuilder<Builder, ConfigureLogsForPlaybackConfigurationResponse> {
    private static final SdkField<Integer> PERCENT_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PercentEnabled").getter(ConfigureLogsForPlaybackConfigurationResponse.getter(ConfigureLogsForPlaybackConfigurationResponse::percentEnabled)).setter(ConfigureLogsForPlaybackConfigurationResponse.setter(Builder::percentEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentEnabled").build()}).build();
    private static final SdkField<String> PLAYBACK_CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlaybackConfigurationName").getter(ConfigureLogsForPlaybackConfigurationResponse.getter(ConfigureLogsForPlaybackConfigurationResponse::playbackConfigurationName)).setter(ConfigureLogsForPlaybackConfigurationResponse.setter(Builder::playbackConfigurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlaybackConfigurationName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERCENT_ENABLED_FIELD, PLAYBACK_CONFIGURATION_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("PercentEnabled", PERCENT_ENABLED_FIELD);
            this.put("PlaybackConfigurationName", PLAYBACK_CONFIGURATION_NAME_FIELD);
        }
    });
    private final Integer percentEnabled;
    private final String playbackConfigurationName;

    private ConfigureLogsForPlaybackConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.percentEnabled = builder.percentEnabled;
        this.playbackConfigurationName = builder.playbackConfigurationName;
    }

    public final Integer percentEnabled() {
        return this.percentEnabled;
    }

    public final String playbackConfigurationName() {
        return this.playbackConfigurationName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.percentEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.playbackConfigurationName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigureLogsForPlaybackConfigurationResponse)) {
            return false;
        }
        ConfigureLogsForPlaybackConfigurationResponse other = (ConfigureLogsForPlaybackConfigurationResponse)((Object)obj);
        return Objects.equals(this.percentEnabled(), other.percentEnabled()) && Objects.equals(this.playbackConfigurationName(), other.playbackConfigurationName());
    }

    public final String toString() {
        return ToString.builder((String)"ConfigureLogsForPlaybackConfigurationResponse").add("PercentEnabled", (Object)this.percentEnabled()).add("PlaybackConfigurationName", (Object)this.playbackConfigurationName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PercentEnabled": {
                return Optional.ofNullable(clazz.cast(this.percentEnabled()));
            }
            case "PlaybackConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.playbackConfigurationName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ConfigureLogsForPlaybackConfigurationResponse, T> g) {
        return obj -> g.apply((ConfigureLogsForPlaybackConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaTailorResponse.BuilderImpl
    implements Builder {
        private Integer percentEnabled;
        private String playbackConfigurationName;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigureLogsForPlaybackConfigurationResponse model) {
            super(model);
            this.percentEnabled(model.percentEnabled);
            this.playbackConfigurationName(model.playbackConfigurationName);
        }

        public final Integer getPercentEnabled() {
            return this.percentEnabled;
        }

        public final void setPercentEnabled(Integer percentEnabled) {
            this.percentEnabled = percentEnabled;
        }

        @Override
        public final Builder percentEnabled(Integer percentEnabled) {
            this.percentEnabled = percentEnabled;
            return this;
        }

        public final String getPlaybackConfigurationName() {
            return this.playbackConfigurationName;
        }

        public final void setPlaybackConfigurationName(String playbackConfigurationName) {
            this.playbackConfigurationName = playbackConfigurationName;
        }

        @Override
        public final Builder playbackConfigurationName(String playbackConfigurationName) {
            this.playbackConfigurationName = playbackConfigurationName;
            return this;
        }

        @Override
        public ConfigureLogsForPlaybackConfigurationResponse build() {
            return new ConfigureLogsForPlaybackConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MediaTailorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ConfigureLogsForPlaybackConfigurationResponse> {
        public Builder percentEnabled(Integer var1);

        public Builder playbackConfigurationName(String var1);
    }
}

