/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.MediaLiveRequest;
import software.amazon.awssdk.services.medialive.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateChannelPlacementGroupRequest
extends MediaLiveRequest
implements ToCopyableBuilder<Builder, UpdateChannelPlacementGroupRequest> {
    private static final SdkField<String> CHANNEL_PLACEMENT_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelPlacementGroupId").getter(UpdateChannelPlacementGroupRequest.getter(UpdateChannelPlacementGroupRequest::channelPlacementGroupId)).setter(UpdateChannelPlacementGroupRequest.setter(Builder::channelPlacementGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("channelPlacementGroupId").build()}).build();
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterId").getter(UpdateChannelPlacementGroupRequest.getter(UpdateChannelPlacementGroupRequest::clusterId)).setter(UpdateChannelPlacementGroupRequest.setter(Builder::clusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("clusterId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateChannelPlacementGroupRequest.getter(UpdateChannelPlacementGroupRequest::name)).setter(UpdateChannelPlacementGroupRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<String>> NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Nodes").getter(UpdateChannelPlacementGroupRequest.getter(UpdateChannelPlacementGroupRequest::nodes)).setter(UpdateChannelPlacementGroupRequest.setter(Builder::nodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_PLACEMENT_GROUP_ID_FIELD, CLUSTER_ID_FIELD, NAME_FIELD, NODES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("channelPlacementGroupId", CHANNEL_PLACEMENT_GROUP_ID_FIELD);
            this.put("clusterId", CLUSTER_ID_FIELD);
            this.put("name", NAME_FIELD);
            this.put("nodes", NODES_FIELD);
        }
    });
    private final String channelPlacementGroupId;
    private final String clusterId;
    private final String name;
    private final List<String> nodes;

    private UpdateChannelPlacementGroupRequest(BuilderImpl builder) {
        super(builder);
        this.channelPlacementGroupId = builder.channelPlacementGroupId;
        this.clusterId = builder.clusterId;
        this.name = builder.name;
        this.nodes = builder.nodes;
    }

    public final String channelPlacementGroupId() {
        return this.channelPlacementGroupId;
    }

    public final String clusterId() {
        return this.clusterId;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasNodes() {
        return this.nodes != null && !(this.nodes instanceof SdkAutoConstructList);
    }

    public final List<String> nodes() {
        return this.nodes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelPlacementGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNodes() ? this.nodes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateChannelPlacementGroupRequest)) {
            return false;
        }
        UpdateChannelPlacementGroupRequest other = (UpdateChannelPlacementGroupRequest)((Object)obj);
        return Objects.equals(this.channelPlacementGroupId(), other.channelPlacementGroupId()) && Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.name(), other.name()) && this.hasNodes() == other.hasNodes() && Objects.equals(this.nodes(), other.nodes());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateChannelPlacementGroupRequest").add("ChannelPlacementGroupId", (Object)this.channelPlacementGroupId()).add("ClusterId", (Object)this.clusterId()).add("Name", (Object)this.name()).add("Nodes", this.hasNodes() ? this.nodes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelPlacementGroupId": {
                return Optional.ofNullable(clazz.cast(this.channelPlacementGroupId()));
            }
            case "ClusterId": {
                return Optional.ofNullable(clazz.cast(this.clusterId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Nodes": {
                return Optional.ofNullable(clazz.cast(this.nodes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateChannelPlacementGroupRequest, T> g) {
        return obj -> g.apply((UpdateChannelPlacementGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveRequest.BuilderImpl
    implements Builder {
        private String channelPlacementGroupId;
        private String clusterId;
        private String name;
        private List<String> nodes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateChannelPlacementGroupRequest model) {
            super(model);
            this.channelPlacementGroupId(model.channelPlacementGroupId);
            this.clusterId(model.clusterId);
            this.name(model.name);
            this.nodes(model.nodes);
        }

        public final String getChannelPlacementGroupId() {
            return this.channelPlacementGroupId;
        }

        public final void setChannelPlacementGroupId(String channelPlacementGroupId) {
            this.channelPlacementGroupId = channelPlacementGroupId;
        }

        @Override
        public final Builder channelPlacementGroupId(String channelPlacementGroupId) {
            this.channelPlacementGroupId = channelPlacementGroupId;
            return this;
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getNodes() {
            if (this.nodes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.nodes;
        }

        public final void setNodes(Collection<String> nodes) {
            this.nodes = ___listOf__stringCopier.copy(nodes);
        }

        @Override
        public final Builder nodes(Collection<String> nodes) {
            this.nodes = ___listOf__stringCopier.copy(nodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodes(String ... nodes) {
            this.nodes(Arrays.asList(nodes));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateChannelPlacementGroupRequest build() {
            return new UpdateChannelPlacementGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MediaLiveRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateChannelPlacementGroupRequest> {
        public Builder channelPlacementGroupId(String var1);

        public Builder clusterId(String var1);

        public Builder name(String var1);

        public Builder nodes(Collection<String> var1);

        public Builder nodes(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

