/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InputPolicy {
    ALLOWED("ALLOWED"),
    DISALLOWED("DISALLOWED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InputPolicy> VALUE_MAP;
    private final String value;

    private InputPolicy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InputPolicy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InputPolicy> knownValues() {
        EnumSet<InputPolicy> knownValues = EnumSet.allOf(InputPolicy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InputPolicy.class, InputPolicy::toString);
    }
}

