/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum HlsDirectoryStructure {
    SINGLE_DIRECTORY("SINGLE_DIRECTORY"),
    SUBDIRECTORY_PER_STREAM("SUBDIRECTORY_PER_STREAM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HlsDirectoryStructure> VALUE_MAP;
    private final String value;

    private HlsDirectoryStructure(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HlsDirectoryStructure fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HlsDirectoryStructure> knownValues() {
        EnumSet<HlsDirectoryStructure> knownValues = EnumSet.allOf(HlsDirectoryStructure.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(HlsDirectoryStructure.class, HlsDirectoryStructure::toString);
    }
}

