/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.ColorSpace;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ColorConversion3DLUTSetting
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ColorConversion3DLUTSetting> {
    private static final SdkField<String> FILE_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileInput").getter(ColorConversion3DLUTSetting.getter(ColorConversion3DLUTSetting::fileInput)).setter(ColorConversion3DLUTSetting.setter(Builder::fileInput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileInput").build()}).build();
    private static final SdkField<String> INPUT_COLOR_SPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputColorSpace").getter(ColorConversion3DLUTSetting.getter(ColorConversion3DLUTSetting::inputColorSpaceAsString)).setter(ColorConversion3DLUTSetting.setter(Builder::inputColorSpace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputColorSpace").build()}).build();
    private static final SdkField<Integer> INPUT_MASTERING_LUMINANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InputMasteringLuminance").getter(ColorConversion3DLUTSetting.getter(ColorConversion3DLUTSetting::inputMasteringLuminance)).setter(ColorConversion3DLUTSetting.setter(Builder::inputMasteringLuminance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputMasteringLuminance").build()}).build();
    private static final SdkField<String> OUTPUT_COLOR_SPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputColorSpace").getter(ColorConversion3DLUTSetting.getter(ColorConversion3DLUTSetting::outputColorSpaceAsString)).setter(ColorConversion3DLUTSetting.setter(Builder::outputColorSpace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputColorSpace").build()}).build();
    private static final SdkField<Integer> OUTPUT_MASTERING_LUMINANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("OutputMasteringLuminance").getter(ColorConversion3DLUTSetting.getter(ColorConversion3DLUTSetting::outputMasteringLuminance)).setter(ColorConversion3DLUTSetting.setter(Builder::outputMasteringLuminance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputMasteringLuminance").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_INPUT_FIELD, INPUT_COLOR_SPACE_FIELD, INPUT_MASTERING_LUMINANCE_FIELD, OUTPUT_COLOR_SPACE_FIELD, OUTPUT_MASTERING_LUMINANCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("fileInput", FILE_INPUT_FIELD);
            this.put("inputColorSpace", INPUT_COLOR_SPACE_FIELD);
            this.put("inputMasteringLuminance", INPUT_MASTERING_LUMINANCE_FIELD);
            this.put("outputColorSpace", OUTPUT_COLOR_SPACE_FIELD);
            this.put("outputMasteringLuminance", OUTPUT_MASTERING_LUMINANCE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String fileInput;
    private final String inputColorSpace;
    private final Integer inputMasteringLuminance;
    private final String outputColorSpace;
    private final Integer outputMasteringLuminance;

    private ColorConversion3DLUTSetting(BuilderImpl builder) {
        this.fileInput = builder.fileInput;
        this.inputColorSpace = builder.inputColorSpace;
        this.inputMasteringLuminance = builder.inputMasteringLuminance;
        this.outputColorSpace = builder.outputColorSpace;
        this.outputMasteringLuminance = builder.outputMasteringLuminance;
    }

    public final String fileInput() {
        return this.fileInput;
    }

    public final ColorSpace inputColorSpace() {
        return ColorSpace.fromValue(this.inputColorSpace);
    }

    public final String inputColorSpaceAsString() {
        return this.inputColorSpace;
    }

    public final Integer inputMasteringLuminance() {
        return this.inputMasteringLuminance;
    }

    public final ColorSpace outputColorSpace() {
        return ColorSpace.fromValue(this.outputColorSpace);
    }

    public final String outputColorSpaceAsString() {
        return this.outputColorSpace;
    }

    public final Integer outputMasteringLuminance() {
        return this.outputMasteringLuminance;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fileInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputColorSpaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputMasteringLuminance());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputColorSpaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputMasteringLuminance());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColorConversion3DLUTSetting)) {
            return false;
        }
        ColorConversion3DLUTSetting other = (ColorConversion3DLUTSetting)obj;
        return Objects.equals(this.fileInput(), other.fileInput()) && Objects.equals(this.inputColorSpaceAsString(), other.inputColorSpaceAsString()) && Objects.equals(this.inputMasteringLuminance(), other.inputMasteringLuminance()) && Objects.equals(this.outputColorSpaceAsString(), other.outputColorSpaceAsString()) && Objects.equals(this.outputMasteringLuminance(), other.outputMasteringLuminance());
    }

    public final String toString() {
        return ToString.builder((String)"ColorConversion3DLUTSetting").add("FileInput", (Object)this.fileInput()).add("InputColorSpace", (Object)this.inputColorSpaceAsString()).add("InputMasteringLuminance", (Object)this.inputMasteringLuminance()).add("OutputColorSpace", (Object)this.outputColorSpaceAsString()).add("OutputMasteringLuminance", (Object)this.outputMasteringLuminance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileInput": {
                return Optional.ofNullable(clazz.cast(this.fileInput()));
            }
            case "InputColorSpace": {
                return Optional.ofNullable(clazz.cast(this.inputColorSpaceAsString()));
            }
            case "InputMasteringLuminance": {
                return Optional.ofNullable(clazz.cast(this.inputMasteringLuminance()));
            }
            case "OutputColorSpace": {
                return Optional.ofNullable(clazz.cast(this.outputColorSpaceAsString()));
            }
            case "OutputMasteringLuminance": {
                return Optional.ofNullable(clazz.cast(this.outputMasteringLuminance()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ColorConversion3DLUTSetting, T> g) {
        return obj -> g.apply((ColorConversion3DLUTSetting)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fileInput;
        private String inputColorSpace;
        private Integer inputMasteringLuminance;
        private String outputColorSpace;
        private Integer outputMasteringLuminance;

        private BuilderImpl() {
        }

        private BuilderImpl(ColorConversion3DLUTSetting model) {
            this.fileInput(model.fileInput);
            this.inputColorSpace(model.inputColorSpace);
            this.inputMasteringLuminance(model.inputMasteringLuminance);
            this.outputColorSpace(model.outputColorSpace);
            this.outputMasteringLuminance(model.outputMasteringLuminance);
        }

        public final String getFileInput() {
            return this.fileInput;
        }

        public final void setFileInput(String fileInput) {
            this.fileInput = fileInput;
        }

        @Override
        public final Builder fileInput(String fileInput) {
            this.fileInput = fileInput;
            return this;
        }

        public final String getInputColorSpace() {
            return this.inputColorSpace;
        }

        public final void setInputColorSpace(String inputColorSpace) {
            this.inputColorSpace = inputColorSpace;
        }

        @Override
        public final Builder inputColorSpace(String inputColorSpace) {
            this.inputColorSpace = inputColorSpace;
            return this;
        }

        @Override
        public final Builder inputColorSpace(ColorSpace inputColorSpace) {
            this.inputColorSpace(inputColorSpace == null ? null : inputColorSpace.toString());
            return this;
        }

        public final Integer getInputMasteringLuminance() {
            return this.inputMasteringLuminance;
        }

        public final void setInputMasteringLuminance(Integer inputMasteringLuminance) {
            this.inputMasteringLuminance = inputMasteringLuminance;
        }

        @Override
        public final Builder inputMasteringLuminance(Integer inputMasteringLuminance) {
            this.inputMasteringLuminance = inputMasteringLuminance;
            return this;
        }

        public final String getOutputColorSpace() {
            return this.outputColorSpace;
        }

        public final void setOutputColorSpace(String outputColorSpace) {
            this.outputColorSpace = outputColorSpace;
        }

        @Override
        public final Builder outputColorSpace(String outputColorSpace) {
            this.outputColorSpace = outputColorSpace;
            return this;
        }

        @Override
        public final Builder outputColorSpace(ColorSpace outputColorSpace) {
            this.outputColorSpace(outputColorSpace == null ? null : outputColorSpace.toString());
            return this;
        }

        public final Integer getOutputMasteringLuminance() {
            return this.outputMasteringLuminance;
        }

        public final void setOutputMasteringLuminance(Integer outputMasteringLuminance) {
            this.outputMasteringLuminance = outputMasteringLuminance;
        }

        @Override
        public final Builder outputMasteringLuminance(Integer outputMasteringLuminance) {
            this.outputMasteringLuminance = outputMasteringLuminance;
            return this;
        }

        public ColorConversion3DLUTSetting build() {
            return new ColorConversion3DLUTSetting(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ColorConversion3DLUTSetting> {
        public Builder fileInput(String var1);

        public Builder inputColorSpace(String var1);

        public Builder inputColorSpace(ColorSpace var1);

        public Builder inputMasteringLuminance(Integer var1);

        public Builder outputColorSpace(String var1);

        public Builder outputColorSpace(ColorSpace var1);

        public Builder outputMasteringLuminance(Integer var1);
    }
}

