/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.managedblockchain.model.AccessorNetworkType;
import software.amazon.awssdk.services.managedblockchain.model.AccessorStatus;
import software.amazon.awssdk.services.managedblockchain.model.AccessorType;
import software.amazon.awssdk.services.managedblockchain.model.OutputTagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Accessor
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Accessor> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(Accessor.getter(Accessor::id)).setter(Accessor.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(Accessor.getter(Accessor::typeAsString)).setter(Accessor.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> BILLING_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BillingToken").getter(Accessor.getter(Accessor::billingToken)).setter(Accessor.setter(Builder::billingToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingToken").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Accessor.getter(Accessor::statusAsString)).setter(Accessor.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(Accessor.getter(Accessor::creationDate)).setter(Accessor.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(Accessor.getter(Accessor::arn)).setter(Accessor.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(Accessor.getter(Accessor::tags)).setter(Accessor.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> NETWORK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkType").getter(Accessor.getter(Accessor::networkTypeAsString)).setter(Accessor.setter(Builder::networkType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TYPE_FIELD, BILLING_TOKEN_FIELD, STATUS_FIELD, CREATION_DATE_FIELD, ARN_FIELD, TAGS_FIELD, NETWORK_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Id", ID_FIELD);
            this.put("Type", TYPE_FIELD);
            this.put("BillingToken", BILLING_TOKEN_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("CreationDate", CREATION_DATE_FIELD);
            this.put("Arn", ARN_FIELD);
            this.put("Tags", TAGS_FIELD);
            this.put("NetworkType", NETWORK_TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String type;
    private final String billingToken;
    private final String status;
    private final Instant creationDate;
    private final String arn;
    private final Map<String, String> tags;
    private final String networkType;

    private Accessor(BuilderImpl builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.billingToken = builder.billingToken;
        this.status = builder.status;
        this.creationDate = builder.creationDate;
        this.arn = builder.arn;
        this.tags = builder.tags;
        this.networkType = builder.networkType;
    }

    public final String id() {
        return this.id;
    }

    public final AccessorType type() {
        return AccessorType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String billingToken() {
        return this.billingToken;
    }

    public final AccessorStatus status() {
        return AccessorStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final String arn() {
        return this.arn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final AccessorNetworkType networkType() {
        return AccessorNetworkType.fromValue(this.networkType);
    }

    public final String networkTypeAsString() {
        return this.networkType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.networkTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Accessor)) {
            return false;
        }
        Accessor other = (Accessor)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.billingToken(), other.billingToken()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.arn(), other.arn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.networkTypeAsString(), other.networkTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Accessor").add("Id", (Object)this.id()).add("Type", (Object)this.typeAsString()).add("BillingToken", (Object)this.billingToken()).add("Status", (Object)this.statusAsString()).add("CreationDate", (Object)this.creationDate()).add("Arn", (Object)this.arn()).add("Tags", this.hasTags() ? this.tags() : null).add("NetworkType", (Object)this.networkTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "BillingToken": {
                return Optional.ofNullable(clazz.cast(this.billingToken()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "NetworkType": {
                return Optional.ofNullable(clazz.cast(this.networkTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Accessor, T> g) {
        return obj -> g.apply((Accessor)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String type;
        private String billingToken;
        private String status;
        private Instant creationDate;
        private String arn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String networkType;

        private BuilderImpl() {
        }

        private BuilderImpl(Accessor model) {
            this.id(model.id);
            this.type(model.type);
            this.billingToken(model.billingToken);
            this.status(model.status);
            this.creationDate(model.creationDate);
            this.arn(model.arn);
            this.tags(model.tags);
            this.networkType(model.networkType);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AccessorType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getBillingToken() {
            return this.billingToken;
        }

        public final void setBillingToken(String billingToken) {
            this.billingToken = billingToken;
        }

        @Override
        public final Builder billingToken(String billingToken) {
            this.billingToken = billingToken;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AccessorStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = OutputTagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = OutputTagMapCopier.copy(tags);
            return this;
        }

        public final String getNetworkType() {
            return this.networkType;
        }

        public final void setNetworkType(String networkType) {
            this.networkType = networkType;
        }

        @Override
        public final Builder networkType(String networkType) {
            this.networkType = networkType;
            return this;
        }

        @Override
        public final Builder networkType(AccessorNetworkType networkType) {
            this.networkType(networkType == null ? null : networkType.toString());
            return this;
        }

        public Accessor build() {
            return new Accessor(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Accessor> {
        public Builder id(String var1);

        public Builder type(String var1);

        public Builder type(AccessorType var1);

        public Builder billingToken(String var1);

        public Builder status(String var1);

        public Builder status(AccessorStatus var1);

        public Builder creationDate(Instant var1);

        public Builder arn(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder networkType(String var1);

        public Builder networkType(AccessorNetworkType var1);
    }
}

