/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie2.model.AutoEnableMode;
import software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryStatus;
import software.amazon.awssdk.services.macie2.model.Macie2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAutomatedDiscoveryConfigurationResponse
extends Macie2Response
implements ToCopyableBuilder<Builder, GetAutomatedDiscoveryConfigurationResponse> {
    private static final SdkField<String> AUTO_ENABLE_ORGANIZATION_MEMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("autoEnableOrganizationMembers").getter(GetAutomatedDiscoveryConfigurationResponse.getter(GetAutomatedDiscoveryConfigurationResponse::autoEnableOrganizationMembersAsString)).setter(GetAutomatedDiscoveryConfigurationResponse.setter(Builder::autoEnableOrganizationMembers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoEnableOrganizationMembers").build()}).build();
    private static final SdkField<String> CLASSIFICATION_SCOPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("classificationScopeId").getter(GetAutomatedDiscoveryConfigurationResponse.getter(GetAutomatedDiscoveryConfigurationResponse::classificationScopeId)).setter(GetAutomatedDiscoveryConfigurationResponse.setter(Builder::classificationScopeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("classificationScopeId").build()}).build();
    private static final SdkField<Instant> DISABLED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("disabledAt").getter(GetAutomatedDiscoveryConfigurationResponse.getter(GetAutomatedDiscoveryConfigurationResponse::disabledAt)).setter(GetAutomatedDiscoveryConfigurationResponse.setter(Builder::disabledAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disabledAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> FIRST_ENABLED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("firstEnabledAt").getter(GetAutomatedDiscoveryConfigurationResponse.getter(GetAutomatedDiscoveryConfigurationResponse::firstEnabledAt)).setter(GetAutomatedDiscoveryConfigurationResponse.setter(Builder::firstEnabledAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstEnabledAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(GetAutomatedDiscoveryConfigurationResponse.getter(GetAutomatedDiscoveryConfigurationResponse::lastUpdatedAt)).setter(GetAutomatedDiscoveryConfigurationResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> SENSITIVITY_INSPECTION_TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sensitivityInspectionTemplateId").getter(GetAutomatedDiscoveryConfigurationResponse.getter(GetAutomatedDiscoveryConfigurationResponse::sensitivityInspectionTemplateId)).setter(GetAutomatedDiscoveryConfigurationResponse.setter(Builder::sensitivityInspectionTemplateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sensitivityInspectionTemplateId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetAutomatedDiscoveryConfigurationResponse.getter(GetAutomatedDiscoveryConfigurationResponse::statusAsString)).setter(GetAutomatedDiscoveryConfigurationResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_ENABLE_ORGANIZATION_MEMBERS_FIELD, CLASSIFICATION_SCOPE_ID_FIELD, DISABLED_AT_FIELD, FIRST_ENABLED_AT_FIELD, LAST_UPDATED_AT_FIELD, SENSITIVITY_INSPECTION_TEMPLATE_ID_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("autoEnableOrganizationMembers", AUTO_ENABLE_ORGANIZATION_MEMBERS_FIELD);
            this.put("classificationScopeId", CLASSIFICATION_SCOPE_ID_FIELD);
            this.put("disabledAt", DISABLED_AT_FIELD);
            this.put("firstEnabledAt", FIRST_ENABLED_AT_FIELD);
            this.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
            this.put("sensitivityInspectionTemplateId", SENSITIVITY_INSPECTION_TEMPLATE_ID_FIELD);
            this.put("status", STATUS_FIELD);
        }
    });
    private final String autoEnableOrganizationMembers;
    private final String classificationScopeId;
    private final Instant disabledAt;
    private final Instant firstEnabledAt;
    private final Instant lastUpdatedAt;
    private final String sensitivityInspectionTemplateId;
    private final String status;

    private GetAutomatedDiscoveryConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.autoEnableOrganizationMembers = builder.autoEnableOrganizationMembers;
        this.classificationScopeId = builder.classificationScopeId;
        this.disabledAt = builder.disabledAt;
        this.firstEnabledAt = builder.firstEnabledAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.sensitivityInspectionTemplateId = builder.sensitivityInspectionTemplateId;
        this.status = builder.status;
    }

    public final AutoEnableMode autoEnableOrganizationMembers() {
        return AutoEnableMode.fromValue(this.autoEnableOrganizationMembers);
    }

    public final String autoEnableOrganizationMembersAsString() {
        return this.autoEnableOrganizationMembers;
    }

    public final String classificationScopeId() {
        return this.classificationScopeId;
    }

    public final Instant disabledAt() {
        return this.disabledAt;
    }

    public final Instant firstEnabledAt() {
        return this.firstEnabledAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final String sensitivityInspectionTemplateId() {
        return this.sensitivityInspectionTemplateId;
    }

    public final AutomatedDiscoveryStatus status() {
        return AutomatedDiscoveryStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.autoEnableOrganizationMembersAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.classificationScopeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.disabledAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstEnabledAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.sensitivityInspectionTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAutomatedDiscoveryConfigurationResponse)) {
            return false;
        }
        GetAutomatedDiscoveryConfigurationResponse other = (GetAutomatedDiscoveryConfigurationResponse)((Object)obj);
        return Objects.equals(this.autoEnableOrganizationMembersAsString(), other.autoEnableOrganizationMembersAsString()) && Objects.equals(this.classificationScopeId(), other.classificationScopeId()) && Objects.equals(this.disabledAt(), other.disabledAt()) && Objects.equals(this.firstEnabledAt(), other.firstEnabledAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.sensitivityInspectionTemplateId(), other.sensitivityInspectionTemplateId()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetAutomatedDiscoveryConfigurationResponse").add("AutoEnableOrganizationMembers", (Object)this.autoEnableOrganizationMembersAsString()).add("ClassificationScopeId", (Object)this.classificationScopeId()).add("DisabledAt", (Object)this.disabledAt()).add("FirstEnabledAt", (Object)this.firstEnabledAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("SensitivityInspectionTemplateId", (Object)this.sensitivityInspectionTemplateId()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "autoEnableOrganizationMembers": {
                return Optional.ofNullable(clazz.cast(this.autoEnableOrganizationMembersAsString()));
            }
            case "classificationScopeId": {
                return Optional.ofNullable(clazz.cast(this.classificationScopeId()));
            }
            case "disabledAt": {
                return Optional.ofNullable(clazz.cast(this.disabledAt()));
            }
            case "firstEnabledAt": {
                return Optional.ofNullable(clazz.cast(this.firstEnabledAt()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "sensitivityInspectionTemplateId": {
                return Optional.ofNullable(clazz.cast(this.sensitivityInspectionTemplateId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetAutomatedDiscoveryConfigurationResponse, T> g) {
        return obj -> g.apply((GetAutomatedDiscoveryConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Macie2Response.BuilderImpl
    implements Builder {
        private String autoEnableOrganizationMembers;
        private String classificationScopeId;
        private Instant disabledAt;
        private Instant firstEnabledAt;
        private Instant lastUpdatedAt;
        private String sensitivityInspectionTemplateId;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAutomatedDiscoveryConfigurationResponse model) {
            super(model);
            this.autoEnableOrganizationMembers(model.autoEnableOrganizationMembers);
            this.classificationScopeId(model.classificationScopeId);
            this.disabledAt(model.disabledAt);
            this.firstEnabledAt(model.firstEnabledAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.sensitivityInspectionTemplateId(model.sensitivityInspectionTemplateId);
            this.status(model.status);
        }

        public final String getAutoEnableOrganizationMembers() {
            return this.autoEnableOrganizationMembers;
        }

        public final void setAutoEnableOrganizationMembers(String autoEnableOrganizationMembers) {
            this.autoEnableOrganizationMembers = autoEnableOrganizationMembers;
        }

        @Override
        public final Builder autoEnableOrganizationMembers(String autoEnableOrganizationMembers) {
            this.autoEnableOrganizationMembers = autoEnableOrganizationMembers;
            return this;
        }

        @Override
        public final Builder autoEnableOrganizationMembers(AutoEnableMode autoEnableOrganizationMembers) {
            this.autoEnableOrganizationMembers(autoEnableOrganizationMembers == null ? null : autoEnableOrganizationMembers.toString());
            return this;
        }

        public final String getClassificationScopeId() {
            return this.classificationScopeId;
        }

        public final void setClassificationScopeId(String classificationScopeId) {
            this.classificationScopeId = classificationScopeId;
        }

        @Override
        public final Builder classificationScopeId(String classificationScopeId) {
            this.classificationScopeId = classificationScopeId;
            return this;
        }

        public final Instant getDisabledAt() {
            return this.disabledAt;
        }

        public final void setDisabledAt(Instant disabledAt) {
            this.disabledAt = disabledAt;
        }

        @Override
        public final Builder disabledAt(Instant disabledAt) {
            this.disabledAt = disabledAt;
            return this;
        }

        public final Instant getFirstEnabledAt() {
            return this.firstEnabledAt;
        }

        public final void setFirstEnabledAt(Instant firstEnabledAt) {
            this.firstEnabledAt = firstEnabledAt;
        }

        @Override
        public final Builder firstEnabledAt(Instant firstEnabledAt) {
            this.firstEnabledAt = firstEnabledAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getSensitivityInspectionTemplateId() {
            return this.sensitivityInspectionTemplateId;
        }

        public final void setSensitivityInspectionTemplateId(String sensitivityInspectionTemplateId) {
            this.sensitivityInspectionTemplateId = sensitivityInspectionTemplateId;
        }

        @Override
        public final Builder sensitivityInspectionTemplateId(String sensitivityInspectionTemplateId) {
            this.sensitivityInspectionTemplateId = sensitivityInspectionTemplateId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AutomatedDiscoveryStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GetAutomatedDiscoveryConfigurationResponse build() {
            return new GetAutomatedDiscoveryConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Macie2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAutomatedDiscoveryConfigurationResponse> {
        public Builder autoEnableOrganizationMembers(String var1);

        public Builder autoEnableOrganizationMembers(AutoEnableMode var1);

        public Builder classificationScopeId(String var1);

        public Builder disabledAt(Instant var1);

        public Builder firstEnabledAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder sensitivityInspectionTemplateId(String var1);

        public Builder status(String var1);

        public Builder status(AutomatedDiscoveryStatus var1);
    }
}

